/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.vo.pr.tce;

import br.com.fiorilli.sip.commons.util.SIPUtil;
import br.com.fiorilli.sip.persistence.vo.ma.tce.Cpf;
import br.com.fiorilli.sip.persistence.vo.pr.tce.TcePrVOUtil;
import javax.validation.constraints.NotNull;

public class FolhaServidorVO {
    @NotNull(message="Obrigat\u00f3rio informar o codigo da entidade de origem")
    private final String idEntidadeOrigem;
    @Cpf
    private final String nrCpf;
    private final String nrMatricula;
    @NotNull(message="Obrigat\u00f3rio informar o tipo da situa\u00e7\u00e3o do servidor")
    private final String idTipoSituacaoServidor;
    private final Integer idTipoAtivo;
    private final String cdControleFuncao;
    private final String nmFuncao;
    private final String dsLotacao;
    private final Double nrPercentualPatronal;
    private Double nrPercentualDescontoServidor;
    @NotNull(message="Tipo de v\u00ednculo previdenci\u00e1rio inv\u00e1lido.")
    private final String idTipoVinculo;

    public FolhaServidorVO(String idEntidadeOrigem, String nrCpf, String nrMatricula, String idTipoSituacaoServidor, Integer idTipoAtivo, String cdControleFuncao, String nmFuncao, String dsLotacao, Double nrPercentualPatronal, String idTipoVinculo) {
        this.idEntidadeOrigem = idEntidadeOrigem;
        this.nrCpf = nrCpf;
        this.nrMatricula = SIPUtil.removeZeroEsquerda((String)nrMatricula);
        this.idTipoSituacaoServidor = idTipoSituacaoServidor;
        this.idTipoAtivo = idTipoAtivo;
        this.cdControleFuncao = cdControleFuncao;
        this.nmFuncao = nmFuncao;
        this.dsLotacao = dsLotacao;
        this.nrPercentualPatronal = nrPercentualPatronal;
        this.idTipoVinculo = idTipoVinculo;
    }

    public String getNrMatricula() {
        return this.nrMatricula;
    }

    public void setNrPercentualDescontoServidor(Double nrPercentualDescontoServidor) {
        this.nrPercentualDescontoServidor = nrPercentualDescontoServidor;
    }

    public Double getNrPercentualDescontoServidor() {
        return this.nrPercentualDescontoServidor;
    }

    public String toString() {
        return TcePrVOUtil.buildCsvLine(this.idEntidadeOrigem, this.nrCpf, this.nrMatricula, this.idTipoSituacaoServidor, TcePrVOUtil.intToString(this.idTipoAtivo), this.cdControleFuncao, this.nmFuncao, this.dsLotacao, SIPUtil.getBigDecimal((Double)this.nrPercentualPatronal).toString(), SIPUtil.getBigDecimal((Double)this.nrPercentualDescontoServidor).toString(), this.idTipoVinculo);
    }

    public static class FolhaServidorVOSql {
        public static final String FIND_BY_PARAMETROS = " SELECT DISTINCT new " + FolhaServidorVO.class.getName() + " (etc.pessoaId, t.documentosPessoais.cpf, t.trabalhadorPK.registro, " + " CASE " + "\tWHEN t.aposentado = true THEN '3' " + "\tWHEN t.pensionista = true THEN '2' " + "\tELSE '1' END, " + " CASE " + "\tWHEN t.tipoAdmissao = :cessao THEN " + " \t\t8 " + " \tWHEN ca.natureza = :estagiario THEN " + " \t\t10 " + "\tWHEN v.vinculoRais = :jovemAprendiz THEN " + "\t\t11 " + "\tWHEN ca.classificacaoAgentePolitico IS NOT NULL AND ca.classificacaoAgentePolitico <> :nenhum THEN " + "\t\t12 " + "\tWHEN ca.cbo = :conselheiroTutelar THEN " + "\t\t13 " + "\tWHEN t.tipoCargoInicial = :temporario THEN " + "\t\t3 " + "\tWHEN t.tipoCargoInicial = :comissionado THEN " + "\t\t5 " + "\tWHEN t.tipoCargoInicial <> :comissionado " + "\t\tAND t.tipoCargoAtual = :comissionado AND ca.regimeJuridico = :estatutario THEN " + "\t\t6 " + "\tWHEN t.tipoCargoInicial <> :comissionado " + "\t\tAND t.tipoCargoAtual = :comissionado AND ca.regimeJuridico = :clt THEN " + "\t\t7 " + "\tWHEN t.tipoCargoInicial IN (:efetivo, :emprego) AND ca.regimeJuridico = :estatutario THEN " + "\t\t1 " + "\tWHEN t.tipoCargoInicial IN (:efetivo, :emprego) AND ca.regimeJuridico = :estatutario THEN " + "\t\t2 " + "\tWHEN ca.natureza = :cargoEfetivo AND ca.regimeJuridico = :clt THEN " + "\t\t15 " + "\tELSE " + "\t\tnull " + " END, " + " CASE " + "\tWHEN v.vinculoRais = :jovemAprendiz THEN " + "\t\t'2147483642' " + "\tWHEN ca.natureza = :estagiario THEN " + "\t\t'2147483643' " + "\tWHEN ca.cbo = :conselheiroTutelar THEN " + "\t\t'2147483644' " + "\tELSE " + " \t\tca.codigoTceprEntidade " + " END, " + " ca.nome, u.nome, coalesce(b.taxaInssEntidadeMes + (b.taxainssacidentemes * b.taxaFapMes), 0.0), " + " CASE WHEN v.tabelaPrevidenciaria = 1 THEN '7' " + "      WHEN v.tabelaPrevidenciaria = 2 THEN '2' " + "      WHEN t.aposentado = true THEN '1' " + "\t   ELSE CAST(null as string) " + " END) " + " FROM Bases b " + " LEFT JOIN b.referencia r " + " LEFT JOIN b.vinculo v " + " LEFT JOIN b.unidade u " + " LEFT JOIN b.trabalhador t " + " LEFT JOIN t.cargoAtual ca " + " LEFT JOIN t.cargoInicial ci " + " LEFT JOIN t.aposentadoInativo a " + " LEFT JOIN t.entidade e " + " LEFT JOIN e.tcePr etc " + " WHERE etc.pessoaId = :codigoTcePr " + " AND r.codigo = :referenciaCodigo ";
    }
}

