/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.vo.mt.fiplan;

import org.apache.commons.lang3.StringUtils;

public enum SituacaoEnvioFiplan {
    NAO_ENVIADO(0, "N\u00e3o enviado"),
    ENVIADO_COM_SUCESSO(1, "Enviado com sucesso."),
    EXERCICIO_INVALIDO(2, "Ecerc\u00edcio inv\u00e1lido."),
    UO_INVALIDO(3, "C\u00f3digo da Unidade Or\u00e7ament\u00e1ria inv\u00e1lido."),
    MES_INVALIDO(4, "M\u00eas inv\u00e1lido."),
    TIPO_FOLHA_INVALIDO(5, "Identificador do tipo de folha inv\u00e1lido."),
    ERRO_DADOS(6, "Erro em dados do servidor."),
    OPERACAO_NAO_PERMITIDA(8, "Opera\u00e7\u00e3o n\u00e3o permitida."),
    DESCONHECIDO(9, "Erro Desconhecido");

    private final int codigo;
    private final String descricao;

    private SituacaoEnvioFiplan(int codigo, String descricao) {
        this.codigo = codigo;
        this.descricao = descricao;
    }

    public static SituacaoEnvioFiplan of(Integer codigo) {
        if (codigo == null) {
            return NAO_ENVIADO;
        }
        for (SituacaoEnvioFiplan t : SituacaoEnvioFiplan.values()) {
            if (t.getCodigo() != codigo.intValue()) continue;
            return t;
        }
        return DESCONHECIDO;
    }

    public static SituacaoEnvioFiplan of(String codigo) {
        if (codigo == null) {
            return NAO_ENVIADO;
        }
        if (StringUtils.isNumeric((CharSequence)codigo)) {
            for (SituacaoEnvioFiplan t : SituacaoEnvioFiplan.values()) {
                if (t.getCodigo() != Integer.valueOf(codigo).intValue()) continue;
                return t;
            }
        }
        return DESCONHECIDO;
    }

    public int getCodigo() {
        return this.codigo;
    }

    public String getDescricao() {
        return this.descricao;
    }

    public boolean isNaoEnviado() {
        return this == NAO_ENVIADO;
    }

    public boolean isEnviado() {
        return this == ENVIADO_COM_SUCESSO;
    }

    public boolean isErro() {
        return !this.isNaoEnviado() && !this.isEnviado();
    }
}

