/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.vo.graficos;

import br.com.fiorilli.filter.annotations.FilterConfigParameter;
import br.com.fiorilli.filter.annotations.FilterConfigParameters;
import br.com.fiorilli.filter.model.FilterCondition;
import br.com.fiorilli.filter.model.FilterInputType;
import br.com.fiorilli.sip.persistence.entity.Cargo;
import br.com.fiorilli.sip.persistence.entity.Divisao;
import br.com.fiorilli.sip.persistence.entity.LocalTrabalho;
import br.com.fiorilli.sip.persistence.entity.Unidade;
import br.com.fiorilli.sip.persistence.entity.Vinculo;
import br.com.fiorilli.sip.persistence.vo.graficos.GraficoEventualContainer;
import java.util.Date;

@FilterConfigParameters(value={@FilterConfigParameter(fieldClass=Date.class, id="data", label="Data", inputType=FilterInputType.CALENDAR, condition=FilterCondition.INTERVALO, required=true), @FilterConfigParameter(fieldClass=Cargo.class, id="cargoAtual", label="Cargo Atual", inputType=FilterInputType.AUTO_COMPLETE, query="SELECT c FROM Cargo c WHERE UPPER(concat(c.cargoPK.codigo, c.nome)) LIKE UPPER('%'||:param||'%') AND c.cargoPK.entidade = :entidadeCodigo ORDER BY c.nome"), @FilterConfigParameter(fieldClass=LocalTrabalho.class, id="localTrabalho", label="Local de Trabalho", inputType=FilterInputType.AUTO_COMPLETE, query="SELECT l FROM LocalTrabalho l where UPPER(concat(l.localTrabalhoPK.codigo, l.nome)) LIKE UPPER('%'||:param||'%') AND l.localTrabalhoPK.entidade = :entidadeCodigo"), @FilterConfigParameter(fieldClass=Vinculo.class, id="vinculo", label="V\u00ednculo", inputType=FilterInputType.AUTO_COMPLETE, query="SELECT v FROM Vinculo v WHERE concat(v.vinculoPK.codigo, v.nome) LIKE concat('%', :param, '%') AND v.vinculoPK.entidade = :entidadeCodigo"), @FilterConfigParameter(fieldClass=Divisao.class, id="divisao", label="Divis\u00e3o", inputType=FilterInputType.AUTO_COMPLETE, query="SELECT d FROM Divisao d WHERE UPPER(concat(d.divisaoPK.codigo, d.nome)) LIKE UPPER('%'||:param||'%') AND d.divisaoPK.entidade = :entidadeCodigo"), @FilterConfigParameter(fieldClass=Unidade.class, id="unidade", label="Unidade", inputType=FilterInputType.AUTO_COMPLETE, query="SELECT u FROM Unidade u WHERE UPPER(u.nome) LIKE UPPER('%'||:param||'%') AND u.responsavelEntidade = :entidadeCodigo AND YEAR(CURRENT_DATE) = u.ano")})
public class GraficoEventualVo
extends GraficoEventualContainer {
    public GraficoEventualVo(String codEvento, String nomeEvento, Long quantidade) {
        super(codEvento, nomeEvento, quantidade.intValue());
    }

    public static class GraficoEventualSql {
        public static final String GET_BY_PARAMS_NO_PERIODO = " SELECT new " + GraficoEventualVo.class.getName() + " (e.eventoCodigo, ev.nome, COUNT(e.codigo)) " + " FROM Eventuais e " + " INNER JOIN e.evento ev " + " INNER JOIN  e.trabalhador t " + " LEFT JOIN t.localTrabalho l " + " LEFT JOIN t.vinculo v " + " LEFT JOIN t.cargoAtual ca " + " LEFT JOIN t.divisao d " + " LEFT JOIN t.unidade u " + " WHERE e.entidade = :entidadeCodigo " + " AND $P{[localTrabalho],[l],[:localTrabalho]} " + " AND $P{[vinculo],[v],[:vinculo]} " + " AND $P{[cargoAtual],[t.cargoAtual],[:cargoAtual]} " + " AND $P{[divisao],[t.divisao],[:divisao]} " + " AND $P{[unidade],[t.unidade],[:unidade]} " + " AND e.dataInicial BETWEEN :dataStart AND :dataEnd " + " GROUP BY  e.eventoCodigo, ev.nome ";
        public static final String GET_FALTAS_BY_PARAMS_NO_PERIODO = " SELECT new " + GraficoEventualVo.class.getName() + " (f.eventoCodigo, e.nome, COUNT(f.id)) " + " FROM Falta f " + " INNER JOIN f.evento e " + " INNER JOIN  f.trabalhador t " + " LEFT JOIN t.localTrabalho l " + " LEFT JOIN t.vinculo v " + " LEFT JOIN t.cargoAtual ca " + " LEFT JOIN t.divisao d " + " LEFT JOIN t.unidade u " + " WHERE f.entidadeCodigo = :entidadeCodigo " + " AND $P{[localTrabalho],[l],[:localTrabalho]} " + " AND $P{[vinculo],[v],[:vinculo]} " + " AND $P{[cargoAtual],[t.cargoAtual],[:cargoAtual]} " + " AND $P{[divisao],[t.divisao],[:divisao]} " + " AND $P{[unidade],[t.unidade],[:unidade]} " + " AND f.data BETWEEN :dataStart AND :dataEnd " + " GROUP BY  f.eventoCodigo, e.nome ";
    }
}

