/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.vo.go.tcm;

import br.com.fiorilli.sip.persistence.entity.TcmgoTipoOrgao;

public class OrgaoTcmgo {
    private final String codigo;
    private final String descricao;
    private final Integer codEntidadeNoScpi;
    private final String codigoEntidade;
    private final String codigoDivisao;
    public static final String FIND_ALL = "SELECT DISTINCT         NEW " + OrgaoTcmgo.class.getName() + "        (go.codigoOrgao, go.tipoOrgao, scpi.codigoNoScpi, e.codigo) " + "FROM " + "        Entidade e " + "INNER JOIN " + "        e.tcmGo GO " + "LEFT JOIN " + "        e.scpi scpi";
    public static final String FIND_ALL_NEW = "SELECT DISTINCT         NEW " + OrgaoTcmgo.class.getName() + "        (dgo.codigoTcmgo, dgo.tipoOrgao, e.codigo, d.divisaoPK.codigo) " + "FROM " + "        DivisaoTcmgo dgo " + "INNER JOIN " + "        dgo.divisao d " + "INNER JOIN " + "        d.entidade e " + "LEFT JOIN " + "        e.scpi scpi " + "WHERE " + "        e.codigo = :entidade " + "AND   " + "        dgo.codigoTcmgo is not null " + "AND   " + "        dgo.codigoTcmgo <> '' " + "AND   " + "        dgo.tipoOrgao is not null " + "AND   " + "        dgo.tipoOrgao <> '' ";

    public OrgaoTcmgo(String codigo, String tipoOrgao, Integer codEntidadeNoScpi, String codigoEntidade) {
        this.codigo = codigo;
        this.descricao = codigo + " - " + TcmgoTipoOrgao.of(tipoOrgao).getDescricao();
        this.codEntidadeNoScpi = codEntidadeNoScpi;
        this.codigoEntidade = codigoEntidade;
        this.codigoDivisao = null;
    }

    public OrgaoTcmgo(String codigo, String tipoOrgao, String codigoEntidade, String codigoDivisao) {
        String descricaoTmp;
        this.codigo = codigo;
        try {
            TcmgoTipoOrgao tipoOrgaoEnum = TcmgoTipoOrgao.of(tipoOrgao);
            descricaoTmp = codigo + " - " + tipoOrgaoEnum.getDescricao();
        }
        catch (IllegalArgumentException e) {
            descricaoTmp = codigo + " - Tipo de org\u00e3o n\u00e3o identificado";
        }
        this.descricao = descricaoTmp;
        this.codEntidadeNoScpi = null;
        this.codigoEntidade = codigoEntidade;
        this.codigoDivisao = codigoDivisao;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OrgaoTcmgo)) {
            return false;
        }
        OrgaoTcmgo other = (OrgaoTcmgo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$codigo = this.getCodigo();
        String other$codigo = other.getCodigo();
        if (this$codigo == null ? other$codigo != null : !this$codigo.equals(other$codigo)) {
            return false;
        }
        String this$descricao = this.getDescricao();
        String other$descricao = other.getDescricao();
        if (this$descricao == null ? other$descricao != null : !this$descricao.equals(other$descricao)) {
            return false;
        }
        Integer this$codEntidadeNoScpi = this.getCodEntidadeNoScpi();
        Integer other$codEntidadeNoScpi = other.getCodEntidadeNoScpi();
        if (this$codEntidadeNoScpi == null ? other$codEntidadeNoScpi != null : !((Object)this$codEntidadeNoScpi).equals(other$codEntidadeNoScpi)) {
            return false;
        }
        String this$codigoEntidade = this.getCodigoEntidade();
        String other$codigoEntidade = other.getCodigoEntidade();
        if (this$codigoEntidade == null ? other$codigoEntidade != null : !this$codigoEntidade.equals(other$codigoEntidade)) {
            return false;
        }
        String this$codigoDivisao = this.getCodigoDivisao();
        String other$codigoDivisao = other.getCodigoDivisao();
        return !(this$codigoDivisao == null ? other$codigoDivisao != null : !this$codigoDivisao.equals(other$codigoDivisao));
    }

    protected boolean canEqual(Object other) {
        return other instanceof OrgaoTcmgo;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $codigo = this.getCodigo();
        result = result * 59 + ($codigo == null ? 43 : $codigo.hashCode());
        String $descricao = this.getDescricao();
        result = result * 59 + ($descricao == null ? 43 : $descricao.hashCode());
        Integer $codEntidadeNoScpi = this.getCodEntidadeNoScpi();
        result = result * 59 + ($codEntidadeNoScpi == null ? 43 : ((Object)$codEntidadeNoScpi).hashCode());
        String $codigoEntidade = this.getCodigoEntidade();
        result = result * 59 + ($codigoEntidade == null ? 43 : $codigoEntidade.hashCode());
        String $codigoDivisao = this.getCodigoDivisao();
        result = result * 59 + ($codigoDivisao == null ? 43 : $codigoDivisao.hashCode());
        return result;
    }

    public String getCodigo() {
        return this.codigo;
    }

    public String getDescricao() {
        return this.descricao;
    }

    public Integer getCodEntidadeNoScpi() {
        return this.codEntidadeNoScpi;
    }

    public String getCodigoEntidade() {
        return this.codigoEntidade;
    }

    public String getCodigoDivisao() {
        return this.codigoDivisao;
    }
}

