/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.vo.cartaoponto.rep;

public class Empregador {
    private Identificador identificador;
    private String cpfCnpj;
    private String cei;
    private String razaoSocial;

    public Empregador(Builder builder) {
        this.identificador = builder.identificador;
        this.cpfCnpj = builder.cpfCnpj;
        this.cei = builder.cei;
        this.razaoSocial = builder.razaoSocial;
    }

    public String toStringForAfd() {
        return this.identificador.getId() + this.cpfCnpj + this.cei + this.razaoSocial;
    }

    public Identificador getIdentificador() {
        return this.identificador;
    }

    public String getCpfCnpj() {
        return this.cpfCnpj;
    }

    public String getCei() {
        return this.cei;
    }

    public String getRazaoSocial() {
        return this.razaoSocial;
    }

    public static class Builder {
        private Identificador identificador;
        private String cpfCnpj;
        private String cei;
        private String razaoSocial;

        public Empregador build() {
            return new Empregador(this);
        }

        public Builder comIdentificador(Identificador identificador) {
            this.identificador = identificador;
            return this;
        }

        public Builder comCpfCnpj(String cpfCnpj) {
            this.cpfCnpj = cpfCnpj;
            return this;
        }

        public Builder comCei(String cei) {
            this.cei = cei;
            return this;
        }

        public Builder comRazaoSocial(String razaoSocial) {
            this.razaoSocial = razaoSocial;
            return this;
        }
    }

    public static enum Identificador {
        CNPJ("1"),
        CPF("2");

        private final String id;

        public static Identificador getBy(String id) {
            if (id != null) {
                for (Identificador identificador : Identificador.values()) {
                    if (!identificador.getId().equals(id)) continue;
                    return identificador;
                }
            }
            return null;
        }

        private Identificador(String id) {
            this.id = id;
        }

        public String getId() {
            return this.id;
        }
    }
}

