/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.vo.cartaoponto.autorizacaoHoraExtra;

import br.com.fiorilli.filter.annotations.FilterConfigParameter;
import br.com.fiorilli.filter.annotations.FilterConfigParameters;
import br.com.fiorilli.filter.model.FilterCondition;
import br.com.fiorilli.filter.model.FilterInputType;
import br.com.fiorilli.sip.persistence.entity.Divisao;
import br.com.fiorilli.sip.persistence.entity.DivisaoPK;
import br.com.fiorilli.sip.persistence.entity.Evento;
import br.com.fiorilli.sip.persistence.entity.GrupoPontoPK;
import br.com.fiorilli.sip.persistence.entity.Jornada;
import br.com.fiorilli.sip.persistence.entity.LocalTrabalho;
import br.com.fiorilli.sip.persistence.entity.PontoEventoTipo;
import br.com.fiorilli.sip.persistence.entity.Subdivisao;
import br.com.fiorilli.sip.persistence.vo.cartaoponto.autorizacaoHoraExtra.DocumentoDigitalVO;
import br.com.fiorilli.sip.persistence.vo.cartaoponto.autorizacaoHoraExtra.PontoEventoVO;
import java.util.List;
import java.util.Objects;
import org.joda.time.Duration;
import org.joda.time.ReadableDuration;

@FilterConfigParameters(value={@FilterConfigParameter(fieldClass=LocalTrabalho.class, id="localTrabalho", label="Local de Trabalho", inputType=FilterInputType.AUTO_COMPLETE, query="SELECT l FROM LocalTrabalho l where UPPER(concat(l.localTrabalhoPK.codigo, l.nome)) LIKE UPPER('%'||:param||'%') AND l.localTrabalhoPK.entidade = :entidadeCodigo"), @FilterConfigParameter(fieldClass=Divisao.class, id="divisao", label="Divis\u00e3o", inputType=FilterInputType.AUTO_COMPLETE, query="SELECT d FROM Divisao d WHERE UPPER(concat(d.divisaoPK.codigo, d.nome)) LIKE UPPER('%'||:param||'%') AND d.divisaoPK.entidade = :entidadeCodigo"), @FilterConfigParameter(fieldClass=Subdivisao.class, id="subdivisao", label="Subdivis\u00e3o", inputType=FilterInputType.AUTO_COMPLETE, query="SELECT s FROM Subdivisao s WHERE UPPER(concat(s.subdivisaoPK.codigo, s.nome)) LIKE UPPER('%'||:param||'%') AND s.subdivisaoPK.entidade = :entidadeCodigo"), @FilterConfigParameter(fieldClass=Jornada.class, id="jornada", label="Jornada", inputType=FilterInputType.AUTO_COMPLETE, query="SELECT j FROM Jornada j where j.jornadaPK.entidade = :entidadeCodigo \tand ((\t\t((length(cast(:param as text)) <= 3)) and (cast(j.jornadaPK.codigo as text) = cast(:param as text)))\t\tor ((length(cast(:param as text)) > 3) and \t\t   ((concat(j.jornadaPK.codigo, j.nome) LIKE concat('%', cast(:param as text), '%')) \t\t   or (concat('#', j.apelido) LIKE concat(cast(:param as text), '%')))\t\t))"), @FilterConfigParameter(fieldClass=DivisaoPK.class, id="divisoesPerfil", label="Divis\u00f5es Perfil", condition=FilterCondition.SEQUENCIA, hide=true, disable=true), @FilterConfigParameter(fieldClass=GrupoPontoPK.class, id="gruposPontoPerfil", label="Grupos de Ponto Perfil", condition=FilterCondition.SEQUENCIA, hide=true, disable=true), @FilterConfigParameter(fieldClass=Evento.class, id="evento", label="Evento", inputType=FilterInputType.AUTO_COMPLETE, query="SELECT e FROM Evento e WHERE UPPER(concat(e.eventoPK.codigo, e.nome)) LIKE UPPER(concat('%', :param, '%')) AND e.eventoPK.entidade = :entidadeCodigo ORDER BY e.nome")})
public class TrabalhadorVO {
    private String entidade;
    private String registro;
    private Integer matricula;
    private Short contrato;
    private String nome;
    private List<PontoEventoVO> pontoEventoVoList;
    private State estado = State.WAIT;
    private List<DocumentoDigitalVO> documentoDigitalVoList;

    public TrabalhadorVO(String entidade, String registro, Integer matricula, Short contrato, String nome) {
        this.entidade = entidade;
        this.registro = registro;
        this.matricula = matricula;
        this.contrato = contrato;
        this.nome = nome;
    }

    public Duration getQuantidadeHorasTotal() {
        Duration duration = Duration.ZERO;
        if (this.pontoEventoVoList != null && !this.pontoEventoVoList.isEmpty()) {
            for (PontoEventoVO pontoEventoVO : this.pontoEventoVoList) {
                duration = duration.plus((ReadableDuration)pontoEventoVO.getQuantidade());
            }
        }
        return duration;
    }

    public Duration getQuantidadeHorasAprovadasTotal() {
        Duration duration = Duration.ZERO;
        if (this.pontoEventoVoList != null && !this.pontoEventoVoList.isEmpty()) {
            for (PontoEventoVO pontoEventoVO : this.pontoEventoVoList) {
                duration = duration.plus((ReadableDuration)pontoEventoVO.getHorasAprovadas());
            }
        }
        return duration;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TrabalhadorVO that = (TrabalhadorVO)o;
        return Objects.equals(this.entidade, that.entidade) && Objects.equals(this.registro, that.registro);
    }

    public int hashCode() {
        return Objects.hash(this.entidade, this.registro);
    }

    public String getEntidade() {
        return this.entidade;
    }

    public String getRegistro() {
        return this.registro;
    }

    public Integer getMatricula() {
        return this.matricula;
    }

    public Short getContrato() {
        return this.contrato;
    }

    public String getNome() {
        return this.nome;
    }

    public List<PontoEventoVO> getPontoEventoVoList() {
        return this.pontoEventoVoList;
    }

    public State getEstado() {
        return this.estado;
    }

    public List<DocumentoDigitalVO> getDocumentoDigitalVoList() {
        return this.documentoDigitalVoList;
    }

    public void setEntidade(String entidade) {
        this.entidade = entidade;
    }

    public void setRegistro(String registro) {
        this.registro = registro;
    }

    public void setMatricula(Integer matricula) {
        this.matricula = matricula;
    }

    public void setContrato(Short contrato) {
        this.contrato = contrato;
    }

    public void setNome(String nome) {
        this.nome = nome;
    }

    public void setPontoEventoVoList(List<PontoEventoVO> pontoEventoVoList) {
        this.pontoEventoVoList = pontoEventoVoList;
    }

    public void setEstado(State estado) {
        this.estado = estado;
    }

    public void setDocumentoDigitalVoList(List<DocumentoDigitalVO> documentoDigitalVoList) {
        this.documentoDigitalVoList = documentoDigitalVoList;
    }

    public TrabalhadorVO() {
    }

    public static class TrabalhadorVoSql {
        public static final String FIND_TRABALHADORES_BY_PARAMS = " SELECT DISTINCT new " + TrabalhadorVO.class.getName() + " (t.trabalhadorPK.entidade, t.trabalhadorPK.registro, t.matricula, t.contrato, t.nome) " + " FROM PontoEvento pe " + " INNER JOIN pe.trabalhador t " + " WHERE pe.entidadeCodigo = :entidadeCodigo " + " AND pe.status in :status " + " AND pe.referenciaCodigo = :referencia " + " AND pe.tipo = '" + PontoEventoTipo.HORA_EXTRA.getId() + "' AND " + " $P{[divisoesPerfil], [t.divisao.divisaoPK], [:divisoesPerfil]} AND " + " $P{[localTrabalho],[t.localTrabalho],[:localTrabalho]} AND " + " $P{[divisao],[t.divisao],[:divisao]} AND " + " $P{[subdivisao],[t.subdivisao],[:subdivisao]} AND " + " $P{[jornada],[t.jornada],[:jornada]} AND " + " $P{[gruposPontoPerfil], [t.grupoPonto.grupoPontoPK], [:gruposPontoPerfil]} AND " + " $P{[evento], [pe.evento], [:evento]} " + " ORDER BY t.nome ";
    }

    public static enum State {
        WAIT,
        MAINTENANCE;


        public boolean isWait() {
            return this == WAIT;
        }

        public boolean isMaintenance() {
            return this == MAINTENANCE;
        }
    }
}

