/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.vo.cartaoponto.autorizacaoHoraExtra;

import br.com.fiorilli.sip.commons.util.TimeUtils;
import br.com.fiorilli.sip.persistence.entity.BancoHorasParametros;
import br.com.fiorilli.sip.persistence.entity.PontoEventoTipo;
import br.com.fiorilli.sip.persistence.entity.Referencia;
import br.com.fiorilli.sip.persistence.enums.StatusEventosPonto;
import br.com.fiorilli.sip.persistence.vo.ReferenciaMinVo;
import br.com.fiorilli.sip.persistence.vo.RelacaoVigenciasVo;
import java.util.Date;
import org.joda.time.Duration;
import org.joda.time.Period;
import org.joda.time.ReadableDuration;
import org.joda.time.ReadablePeriod;
import org.joda.time.format.PeriodFormatter;
import org.joda.time.format.PeriodFormatterBuilder;

public class PontoEventoVO {
    private Date data;
    private String codEvento;
    private String nomeEvento;
    private StatusEventosPonto status;
    private Integer codPonto;
    private Duration quantidade;
    private Long quantidadeMillis;
    private String quantidadeString;
    private boolean aprovado;
    private Integer codDocumentoDigital;
    private Duration horasAprovadas;
    private ReferenciaMinVo referenciaPagto;
    private Short destino;
    private RelacaoVigenciasVo bancoHorasVigencia;

    public PontoEventoVO(Date data, String codEvento, String nomeEvento, String status, Integer codPonto, Duration quantidade, Integer codDocumentoDigital) {
        this.data = data;
        this.codEvento = codEvento;
        this.nomeEvento = nomeEvento;
        this.status = StatusEventosPonto.getBy(status);
        this.codPonto = codPonto;
        this.quantidade = quantidade;
        Period period = quantidade.toPeriod();
        PeriodFormatter quantidadeFormatada = new PeriodFormatterBuilder().printZeroAlways().minimumPrintedDigits(2).appendHours().appendSeparator(":").appendMinutes().toFormatter();
        this.quantidadeString = quantidadeFormatada.print((ReadablePeriod)period);
        this.aprovado = this.status == StatusEventosPonto.APROVADO;
        this.codDocumentoDigital = codDocumentoDigital;
        this.horasAprovadas = new Duration(this.status == StatusEventosPonto.APROVADO ? quantidade : Long.valueOf(0L));
    }

    public PontoEventoVO(Date data, String codEvento, String nomeEvento, Long quantidadeMillis) {
        this.data = data;
        this.codEvento = codEvento;
        this.nomeEvento = nomeEvento;
        this.quantidadeMillis = quantidadeMillis;
    }

    public PontoEventoVO(Date data, String codEvento, String nomeEvento, String status, Integer codPonto, Duration quantidade, Integer codDocumentoDigital, Referencia referencia, Short destino, BancoHorasParametros bancoHorasVigencia) {
        this.data = data;
        this.codEvento = codEvento;
        this.nomeEvento = nomeEvento;
        this.status = StatusEventosPonto.getBy(status);
        this.codPonto = codPonto;
        this.quantidade = quantidade;
        Period period = quantidade.toPeriod();
        PeriodFormatter quantidadeFormatada = new PeriodFormatterBuilder().printZeroAlways().minimumPrintedDigits(2).appendHours().appendSeparator(":").appendMinutes().toFormatter();
        this.quantidadeString = quantidadeFormatada.print((ReadablePeriod)period);
        this.aprovado = this.status == StatusEventosPonto.APROVADO;
        this.codDocumentoDigital = codDocumentoDigital;
        this.horasAprovadas = new Duration(this.status == StatusEventosPonto.APROVADO ? quantidade : Long.valueOf(0L));
        this.referenciaPagto = ReferenciaMinVo.create(referencia);
        this.destino = destino;
        this.bancoHorasVigencia = bancoHorasVigencia != null ? new RelacaoVigenciasVo(bancoHorasVigencia.getCodigo(), bancoHorasVigencia.getDataVigenciaInicio(), bancoHorasVigencia.getDataVigenciaTermino()) : null;
    }

    public boolean isAnexadoDocumento() {
        return this.codDocumentoDigital != null && this.codDocumentoDigital > 0;
    }

    public void setAprovado(boolean aprovado) {
        this.aprovado = aprovado;
        this.status = aprovado ? StatusEventosPonto.APROVADO : StatusEventosPonto.REPROVADO;
    }

    public String getQuantidadeInHours() {
        Duration duration = Duration.ZERO;
        duration = duration.plus(this.quantidadeMillis.longValue());
        return TimeUtils.durationToString((Duration)duration);
    }

    public Double getHorasAprovadasInDecimal() throws ClassCastException {
        Double qtdeDecimal = Double.NaN;
        if (this.horasAprovadas != null && !this.horasAprovadas.isEqual((ReadableDuration)Duration.ZERO)) {
            qtdeDecimal = (double)this.horasAprovadas.toStandardMinutes().getMinutes() / 60.0;
        }
        if (qtdeDecimal.isNaN()) {
            throw new ClassCastException(String.format("Quantidade de Horas Aprovadas inv\u00e1lida: %d", qtdeDecimal));
        }
        return qtdeDecimal;
    }

    public Date getData() {
        return this.data;
    }

    public String getCodEvento() {
        return this.codEvento;
    }

    public String getNomeEvento() {
        return this.nomeEvento;
    }

    public StatusEventosPonto getStatus() {
        return this.status;
    }

    public Integer getCodPonto() {
        return this.codPonto;
    }

    public Duration getQuantidade() {
        return this.quantidade;
    }

    public Long getQuantidadeMillis() {
        return this.quantidadeMillis;
    }

    public String getQuantidadeString() {
        return this.quantidadeString;
    }

    public boolean isAprovado() {
        return this.aprovado;
    }

    public Integer getCodDocumentoDigital() {
        return this.codDocumentoDigital;
    }

    public Duration getHorasAprovadas() {
        return this.horasAprovadas;
    }

    public ReferenciaMinVo getReferenciaPagto() {
        return this.referenciaPagto;
    }

    public Short getDestino() {
        return this.destino;
    }

    public RelacaoVigenciasVo getBancoHorasVigencia() {
        return this.bancoHorasVigencia;
    }

    public void setData(Date data) {
        this.data = data;
    }

    public void setCodEvento(String codEvento) {
        this.codEvento = codEvento;
    }

    public void setNomeEvento(String nomeEvento) {
        this.nomeEvento = nomeEvento;
    }

    public void setStatus(StatusEventosPonto status) {
        this.status = status;
    }

    public void setCodPonto(Integer codPonto) {
        this.codPonto = codPonto;
    }

    public void setQuantidade(Duration quantidade) {
        this.quantidade = quantidade;
    }

    public void setQuantidadeMillis(Long quantidadeMillis) {
        this.quantidadeMillis = quantidadeMillis;
    }

    public void setQuantidadeString(String quantidadeString) {
        this.quantidadeString = quantidadeString;
    }

    public void setCodDocumentoDigital(Integer codDocumentoDigital) {
        this.codDocumentoDigital = codDocumentoDigital;
    }

    public void setHorasAprovadas(Duration horasAprovadas) {
        this.horasAprovadas = horasAprovadas;
    }

    public void setReferenciaPagto(ReferenciaMinVo referenciaPagto) {
        this.referenciaPagto = referenciaPagto;
    }

    public void setDestino(Short destino) {
        this.destino = destino;
    }

    public void setBancoHorasVigencia(RelacaoVigenciasVo bancoHorasVigencia) {
        this.bancoHorasVigencia = bancoHorasVigencia;
    }

    public PontoEventoVO() {
    }

    public static class PontoEventoVoSql {
        public static final String QUERY = " SELECT new " + PontoEventoVO.class.getName() + " (p.data, e.eventoPK.codigo, e.nome, pe.status, pe.pontoEventoPK.ponto, pe.quantidade, pe.idDocDigital) " + " FROM PontoEvento pe " + " INNER JOIN pe.trabalhador t " + " INNER JOIN pe.evento e " + " INNER JOIN pe.ponto p " + " WHERE pe.entidadeCodigo = :entidadeCodigo " + " AND pe.status in :status " + " AND pe.referenciaCodigo = :referencia " + " AND t.trabalhadorPK.registro = :registro " + " AND pe.tipo = '" + PontoEventoTipo.HORA_EXTRA.getId() + "' ";
        public static final String QUERY_WITH_REFERENCIA_AND_DESTINO = " SELECT new " + PontoEventoVO.class.getName() + " (p.data, " + " e.eventoPK.codigo, " + " e.nome, " + " pe.status, " + " pe.pontoEventoPK.ponto, " + " pe.quantidade, " + " pe.idDocDigital, " + " COALESCE(rp, r)," + " pe.destino," + " bh) " + " FROM PontoEvento pe " + " INNER JOIN pe.trabalhador t " + " INNER JOIN pe.evento e " + " INNER JOIN pe.ponto p " + " INNER JOIN pe.referencia r " + " LEFT JOIN pe.referenciaPagto rp " + " LEFT JOIN pe.bancoHorasVigencia bh " + " WHERE pe.entidadeCodigo = :entidadeCodigo " + " AND pe.status in :status " + " AND r.codigo = :referencia " + " AND t.trabalhadorPK.registro = :registro " + " AND pe.tipo = '" + PontoEventoTipo.HORA_EXTRA.getId() + "' ";
        public static final String ROW_COUNT = " SELECT COUNT(pe.pontoEventoPK.ponto)  FROM PontoEvento pe  INNER JOIN pe.trabalhador t  INNER JOIN pe.evento e  WHERE pe.entidadeCodigo = :entidadeCodigo  AND pe.status = :status  AND pe.referenciaCodigo = :referencia  AND pe.tipo = '" + PontoEventoTipo.HORA_EXTRA.getId() + "' AND " + " $P{[registro],[t.trabalhadorPK.registro],[:registro]} AND " + " $P{[matricula],[t.matricula],[:matricula]} AND " + " $P{[contrato],[t.contrato],[:contrato]} ";
        public static final String GET_BY_ENTIDADE_PONTO = " SELECT new " + PontoEventoVO.class.getName() + " (pe.entidadeCodigo, pe.registro, t.matricula, t.contrato, t.nome, e.eventoPK.codigo, e.nome, pe.status, pe.pontoEventoPK.ponto) " + " FROM PontoEvento pe " + " INNER JOIN pe.trabalhador t " + " INNER JOIN pe.evento e " + " WHERE pe.entidadeCodigo = :entidadeCodigo " + " AND pe.pontoEventoPK.ponto = :codPonto " + " AND pe.tipo = '" + PontoEventoTipo.HORA_EXTRA.getId() + "' ";
        public static final String FIND_BY_ENTIDADE_REGISTRO_EVENTOS = "SELECT new " + PontoEventoVO.class.getName() + "(p.data, e.eventoPK.codigo, e.nome, pe.quantidadeMillis) " + "FROM PontoEvento pe " + "INNER JOIN pe.ponto p " + "INNER JOIN pe.evento e " + "WHERE pe.entidadeCodigo = :entidadeCodigo AND pe.registro = :registro AND pe.evento IN (:eventos) AND pe.status = 'A' AND p.data <= :dataLimite " + "ORDER BY p.data, e.eventoPK.codigo ASC ";
    }
}

