/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.vo.cartaoponto;

import br.com.fiorilli.filter.annotations.FilterConfigParameter;
import br.com.fiorilli.filter.annotations.FilterConfigParameters;
import br.com.fiorilli.filter.annotations.FilterConfigType;
import br.com.fiorilli.filter.model.FilterCondition;
import br.com.fiorilli.filter.model.FilterInputType;
import br.com.fiorilli.sip.persistence.entity.Cargo;
import br.com.fiorilli.sip.persistence.entity.Divisao;
import br.com.fiorilli.sip.persistence.entity.DivisaoPK;
import br.com.fiorilli.sip.persistence.entity.GrupoPonto;
import br.com.fiorilli.sip.persistence.entity.GrupoPontoPK;
import br.com.fiorilli.sip.persistence.entity.Jornada;
import br.com.fiorilli.sip.persistence.entity.LocalTrabalho;
import br.com.fiorilli.sip.persistence.entity.Subdivisao;
import br.com.fiorilli.sip.persistence.entity.Vinculo;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;

@FilterConfigType(query="SELECT    $R{[tr.trabalhadorPK.registro],    [NEW br.com.fiorilli.sip.persistence.vo.cartaoponto.TrabalhadorExportadoVO   (min(tr.matricula), tr.nome, tr.documentosPessoais.pis, tr.documentosPessoais.cpf)]} FROM Trabalhador tr LEFT JOIN tr.jornada jo LEFT JOIN tr.cargoAtual ca LEFT JOIN tr.vinculo vi LEFT JOIN tr.divisao di LEFT JOIN tr.subdivisao su LEFT JOIN tr.localTrabalho lo LEFT JOIN tr.grupoPonto gp LEFT JOIN tr.unidade un WHERE tr.trabalhadorPK.entidade = :entidadeCodigo and tr.situacao = '1' AND (((:identificador = 'CPF') AND ((tr.documentosPessoais.cpf is not null) OR (trim(tr.documentosPessoais.cpf) = '')))    OR ((:identificador = 'PIS') AND ((tr.documentosPessoais.pis is not null) OR (trim(tr.documentosPessoais.pis) = '')))) AND $P{[divisoesPerfil], [tr.divisao.divisaoPK], [:divisoesPerfil]} AND $P{[registro],[tr.trabalhadorPK.registro],[:registro]} AND $P{[matricula],[tr.matricula],[:matricula]} AND $P{[contrato],[tr.contrato],[:contrato]} AND $P{[nome],[tr.nome],[:nome]} AND $P{[pis],[tr.documentosPessoais.pis],[:pis]} AND $P{[cpf],[tr.documentosPessoais.cpf],[:cpf]} AND $P{[numeroCartao],[tr.ponto.numeroCartao],[:numeroCartao]} AND $P{[dataAdmissao],[tr.dataAdmissao],[:dataAdmissao]} AND $P{[cargo],[tr.cargoAtual],[:cargo]} AND $P{[jornada],[tr.jornada],[:jornada]} AND $P{[divisao],[tr.divisao],[:divisao]}AND $P{[subdivisao],[tr.subdivisao],[:subdivisao]} AND $P{[localTrabalho],[tr.localTrabalho],[:localTrabalho]} AND $P{[vinculo],[tr.vinculo],[:vinculo]} AND $P{[jornadaNome],[concat(jo.jornadaPK.codigo, ' - ', jo.nome)],[:jornadaNome]} AND $P{[cargoNome],[concat(ca.cargoPK.codigo, ' - ', ca.nome)],[:cargoNome]} AND $P{[vinculoNome],[concat(vi.vinculoPK.codigo, ' - ', vi.nome)],[:vinculoNome]} AND $P{[grupoPonto],[tr.grupoPonto],[:grupoPonto]} AND $P{[grupoPontoNome],[concat(gp.grupoPontoPK.codigo, ' - ', gp.nome)],[:grupoPontoNome]} AND $P{[gruposPontoPerfil], [tr.grupoPonto.grupoPontoPK], [:gruposPontoPerfil]} GROUP BY tr.nome, tr.documentosPessoais.pis, tr.documentosPessoais.cpf ORDER BY tr.nome ", displayField=10)
@FilterConfigParameters(value={@FilterConfigParameter(fieldClass=String.class, id="registro", label="Registro", inputType=FilterInputType.NUMBER, order=3), @FilterConfigParameter(fieldClass=Integer.class, id="matricula", label="Matr\u00edcula", inputType=FilterInputType.NUMBER, order=1), @FilterConfigParameter(fieldClass=String.class, id="nome", label="Nome", inputType=FilterInputType.TEXT, condition=FilterCondition.COMECE, order=2), @FilterConfigParameter(fieldClass=Jornada.class, id="jornada", label="Jornada", inputType=FilterInputType.AUTO_COMPLETE, query="SELECT j FROM Jornada j where j.jornadaPK.entidade = :entidadeCodigo \tand ((\t\t((length(cast(:param as text)) <= 3)) and (cast(j.jornadaPK.codigo as text) = cast(:param as text)))\t\tor ((length(cast(:param as text)) > 3) and \t\t   ((concat(j.jornadaPK.codigo, j.nome) LIKE concat('%', cast(:param as text), '%')) \t\t   or (concat('#', j.apelido) LIKE concat(cast(:param as text), '%')))\t\t))", order=8), @FilterConfigParameter(fieldClass=LocalTrabalho.class, id="localTrabalho", label="Local de Trabalho", inputType=FilterInputType.AUTO_COMPLETE, query="SELECT l FROM LocalTrabalho l where UPPER(concat(l.localTrabalhoPK.codigo, l.nome)) LIKE UPPER('%'||:param||'%') AND l.localTrabalhoPK.entidade = :entidadeCodigo", order=6), @FilterConfigParameter(fieldClass=Divisao.class, id="divisao", label="Divis\u00e3o", inputType=FilterInputType.AUTO_COMPLETE, query="SELECT d FROM Divisao d WHERE UPPER(concat(d.divisaoPK.codigo, d.nome)) LIKE UPPER('%'||:param||'%') AND d.divisaoPK.entidade = :entidadeCodigo", order=7), @FilterConfigParameter(fieldClass=String.class, id="pis", label="PIS", inputType=FilterInputType.TEXT, order=4), @FilterConfigParameter(fieldClass=String.class, id="cpf", label="CPF", inputType=FilterInputType.TEXT, order=5), @FilterConfigParameter(fieldClass=Vinculo.class, id="vinculo", label="V\u00ednculo", inputType=FilterInputType.AUTO_COMPLETE, query="SELECT v FROM Vinculo v WHERE concat(v.vinculoPK.codigo, v.nome) LIKE concat('%', :param, '%') AND v.vinculoPK.entidade = :entidadeCodigo", order=9), @FilterConfigParameter(fieldClass=GrupoPonto.class, id="grupoPonto", label="Grupo", inputType=FilterInputType.AUTO_COMPLETE, query="SELECT g FROM GrupoPonto g where g.grupoPontoPK.entidade = :entidadeCodigo AND concat(g.grupoPontoPK.codigo, g.nome) LIKE concat('%', :param, '%') ", order=10), @FilterConfigParameter(fieldClass=Cargo.class, id="cargo", label="Cargo", inputType=FilterInputType.AUTO_COMPLETE, query="SELECT c FROM Cargo c WHERE UPPER(concat(c.cargoPK.codigo, c.nome)) LIKE UPPER('%'||:param||'%') AND c.cargoPK.entidade = :entidadeCodigo ORDER BY c.nome"), @FilterConfigParameter(fieldClass=Date.class, id="dataAdmissao", label="Dt. Admiss\u00e3o", inputType=FilterInputType.CALENDAR), @FilterConfigParameter(fieldClass=Subdivisao.class, id="subdivisao", label="Subdivis\u00e3o", inputType=FilterInputType.AUTO_COMPLETE, query="SELECT s FROM Subdivisao s WHERE UPPER(concat(s.subdivisaoPK.codigo, s.nome)) LIKE UPPER('%'||:param||'%') AND s.subdivisaoPK.entidade = :entidadeCodigo"), @FilterConfigParameter(fieldClass=Short.class, id="contrato", label="Contrato", inputType=FilterInputType.NUMBER), @FilterConfigParameter(fieldClass=String.class, id="numeroCartao", label="N\u00fam. Cart\u00e3o Ponto"), @FilterConfigParameter(fieldClass=String.class, id="jornadaNome", label="Jornada Nome", inputType=FilterInputType.TEXT, condition=FilterCondition.CONTENHA), @FilterConfigParameter(fieldClass=String.class, id="vinculoNome", label="V\u00ednculo Nome", inputType=FilterInputType.TEXT, condition=FilterCondition.CONTENHA), @FilterConfigParameter(fieldClass=String.class, id="cargoNome", label="Cargo Nome", inputType=FilterInputType.TEXT, condition=FilterCondition.CONTENHA), @FilterConfigParameter(fieldClass=String.class, id="grupoPontoNome", label="Grupo Nome", inputType=FilterInputType.TEXT, condition=FilterCondition.CONTENHA), @FilterConfigParameter(fieldClass=DivisaoPK.class, id="divisoesPerfil", label="Divis\u00f5es Perfil", condition=FilterCondition.SEQUENCIA, hide=true, disable=true), @FilterConfigParameter(fieldClass=GrupoPontoPK.class, id="gruposPontoPerfil", label="Grupo Ponto Perfil", condition=FilterCondition.SEQUENCIA, hide=true, disable=true)})
public class TrabalhadorExportadoVO {
    public static final String QUERY_FILTER = "SELECT    $R{[tr.trabalhadorPK.registro],    [NEW br.com.fiorilli.sip.persistence.vo.cartaoponto.TrabalhadorExportadoVO   (min(tr.matricula), tr.nome, tr.documentosPessoais.pis, tr.documentosPessoais.cpf)]} FROM Trabalhador tr LEFT JOIN tr.jornada jo LEFT JOIN tr.cargoAtual ca LEFT JOIN tr.vinculo vi LEFT JOIN tr.divisao di LEFT JOIN tr.subdivisao su LEFT JOIN tr.localTrabalho lo LEFT JOIN tr.grupoPonto gp LEFT JOIN tr.unidade un WHERE tr.trabalhadorPK.entidade = :entidadeCodigo and tr.situacao = '1' AND (((:identificador = 'CPF') AND ((tr.documentosPessoais.cpf is not null) OR (trim(tr.documentosPessoais.cpf) = '')))    OR ((:identificador = 'PIS') AND ((tr.documentosPessoais.pis is not null) OR (trim(tr.documentosPessoais.pis) = '')))) AND $P{[divisoesPerfil], [tr.divisao.divisaoPK], [:divisoesPerfil]} AND $P{[registro],[tr.trabalhadorPK.registro],[:registro]} AND $P{[matricula],[tr.matricula],[:matricula]} AND $P{[contrato],[tr.contrato],[:contrato]} AND $P{[nome],[tr.nome],[:nome]} AND $P{[pis],[tr.documentosPessoais.pis],[:pis]} AND $P{[cpf],[tr.documentosPessoais.cpf],[:cpf]} AND $P{[numeroCartao],[tr.ponto.numeroCartao],[:numeroCartao]} AND $P{[dataAdmissao],[tr.dataAdmissao],[:dataAdmissao]} AND $P{[cargo],[tr.cargoAtual],[:cargo]} AND $P{[jornada],[tr.jornada],[:jornada]} AND $P{[divisao],[tr.divisao],[:divisao]}AND $P{[subdivisao],[tr.subdivisao],[:subdivisao]} AND $P{[localTrabalho],[tr.localTrabalho],[:localTrabalho]} AND $P{[vinculo],[tr.vinculo],[:vinculo]} AND $P{[jornadaNome],[concat(jo.jornadaPK.codigo, ' - ', jo.nome)],[:jornadaNome]} AND $P{[cargoNome],[concat(ca.cargoPK.codigo, ' - ', ca.nome)],[:cargoNome]} AND $P{[vinculoNome],[concat(vi.vinculoPK.codigo, ' - ', vi.nome)],[:vinculoNome]} AND $P{[grupoPonto],[tr.grupoPonto],[:grupoPonto]} AND $P{[grupoPontoNome],[concat(gp.grupoPontoPK.codigo, ' - ', gp.nome)],[:grupoPontoNome]} AND $P{[gruposPontoPerfil], [tr.grupoPonto.grupoPontoPK], [:gruposPontoPerfil]} GROUP BY tr.nome, tr.documentosPessoais.pis, tr.documentosPessoais.cpf ORDER BY tr.nome ";
    private Integer matricula;
    private String pis;
    private String cpf;
    private String nome;

    public TrabalhadorExportadoVO(Integer matricula, String nome, String pis, String cpf) {
        this.matricula = matricula;
        this.pis = StringUtils.leftPad((String)pis, (int)12, (String)"0");
        this.cpf = StringUtils.leftPad((String)cpf, (int)12, (String)"0");
        this.nome = nome;
    }

    public Integer getMatricula() {
        return this.matricula;
    }

    public String getPis() {
        return this.pis;
    }

    public String getCpf() {
        return this.cpf;
    }

    public String getNome() {
        return this.nome;
    }

    public boolean isSameTrabalhador(TrabalhadorExportadoVO other) {
        return other != null && other.getCpf() != null && other.getCpf().equals(this.cpf);
    }

    public String printCPF(String acao) {
        return this.print(acao, this.cpf);
    }

    public String printPIS(String acao) {
        return this.print(acao, this.pis);
    }

    private String print(String acao, String identificador) {
        return String.format("1+1+%s[%s[%s[1[1[%s", acao, identificador, this.nome, this.matricula);
    }
}

