/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.vo.cartaoponto;

import br.com.fiorilli.filter.annotations.FilterConfigParameter;
import br.com.fiorilli.filter.annotations.FilterConfigParameters;
import br.com.fiorilli.filter.annotations.FilterConfigType;
import br.com.fiorilli.filter.model.FilterCondition;
import br.com.fiorilli.filter.model.FilterInputType;
import br.com.fiorilli.sip.commons.util.SIPDateUtil;
import br.com.fiorilli.sip.persistence.entity.Cargo;
import br.com.fiorilli.sip.persistence.entity.Divisao;
import br.com.fiorilli.sip.persistence.entity.DivisaoPK;
import br.com.fiorilli.sip.persistence.entity.GrupoPonto;
import br.com.fiorilli.sip.persistence.entity.GrupoPontoPK;
import br.com.fiorilli.sip.persistence.entity.Jornada;
import br.com.fiorilli.sip.persistence.entity.LocalTrabalho;
import br.com.fiorilli.sip.persistence.entity.Subdivisao;
import br.com.fiorilli.sip.persistence.entity.TipoPonto;
import br.com.fiorilli.sip.persistence.entity.TrabalhadorPK;
import br.com.fiorilli.sip.persistence.entity.TrabalhadorPonto;
import br.com.fiorilli.sip.persistence.entity.Vinculo;
import java.io.Serializable;
import java.util.Date;
import java.util.Objects;

@FilterConfigType(query="SELECT $R{   [tr.trabalhadorPK.registro],    [NEW br.com.fiorilli.sip.persistence.vo.cartaoponto.TrabalhadorCartaoPontoVO   (tr.trabalhadorPK, tr.matricula, tr.nome, tr.dataAdmissao, jo, gp, tr.ponto)]} FROM Trabalhador tr LEFT JOIN tr.jornada jo LEFT JOIN tr.grupoPonto gp WHERE tr.trabalhadorPK.entidade = :entidadeCodigo AND tr.situacao = '1' AND $P{[registro],[tr.trabalhadorPK.registro],[:registro]} AND $P{[matricula],[tr.matricula],[:matricula]} AND $P{[contrato],[tr.contrato],[:contrato]} AND $P{[nome],[tr.nome],[:nome]} AND $P{[pis],[tr.documentosPessoais.pis],[:pis]} AND $P{[cpf],[tr.documentosPessoais.cpf],[:cpf]} AND $P{[numeroCartao],[tr.ponto.numeroCartao],[:numeroCartao]} AND $P{[dataAdmissao],[tr.dataAdmissao],[:dataAdmissao]} AND $P{[cargo],[tr.cargoAtual],[:cargo]} AND $P{[jornada],[tr.jornada],[:jornada]} AND $P{[divisao],[tr.divisao],[:divisao]}AND $P{[subdivisao],[tr.subdivisao],[:subdivisao]} AND $P{[localTrabalho],[tr.localTrabalho],[:localTrabalho]} AND $P{[vinculo],[tr.vinculo],[:vinculo]} AND $P{[grupoPonto],[tr.grupoPonto],[:grupoPonto]} AND $P{[tipoPonto],[tr.ponto.tipo],[:tipoPonto]} AND $P{[divisoesPerfil], [tr.divisao.divisaoPK], [:divisoesPerfil]} AND $P{[gruposPontoPerfil], [tr.grupoPonto.grupoPontoPK], [:gruposPontoPerfil]} ", displayField=9)
@FilterConfigParameters(value={@FilterConfigParameter(fieldClass=String.class, id="registro", label="Registro", inputType=FilterInputType.NUMBER, order=2), @FilterConfigParameter(fieldClass=Integer.class, id="matricula", label="Matr\u00edcula", inputType=FilterInputType.NUMBER, order=1), @FilterConfigParameter(fieldClass=Short.class, id="contrato", label="Contrato", inputType=FilterInputType.NUMBER), @FilterConfigParameter(fieldClass=String.class, id="nome", label="Nome", inputType=FilterInputType.TEXT, condition=FilterCondition.COMECE, order=3), @FilterConfigParameter(fieldClass=Jornada.class, id="jornada", label="Jornada", inputType=FilterInputType.AUTO_COMPLETE, query="SELECT j FROM Jornada j where j.jornadaPK.entidade = :entidadeCodigo \tand ((\t\t((length(cast(:param as text)) <= 3)) and (cast(j.jornadaPK.codigo as text) = cast(:param as text)))\t\tor ((length(cast(:param as text)) > 3) and \t\t   ((concat(j.jornadaPK.codigo, j.nome) LIKE concat('%', cast(:param as text), '%')) \t\t   or (concat('#', j.apelido) LIKE concat(cast(:param as text), '%')))\t\t))", order=8), @FilterConfigParameter(fieldClass=LocalTrabalho.class, id="localTrabalho", label="Local de Trabalho", inputType=FilterInputType.AUTO_COMPLETE, query="SELECT l FROM LocalTrabalho l where UPPER(concat(l.localTrabalhoPK.codigo, l.nome)) LIKE UPPER('%'||:param||'%') AND l.localTrabalhoPK.entidade = :entidadeCodigo"), @FilterConfigParameter(fieldClass=Divisao.class, id="divisao", label="Divis\u00e3o", inputType=FilterInputType.AUTO_COMPLETE, query="SELECT d FROM Divisao d WHERE UPPER(concat(d.divisaoPK.codigo, d.nome)) LIKE UPPER('%'||:param||'%') AND d.divisaoPK.entidade = :entidadeCodigo", order=6), @FilterConfigParameter(fieldClass=String.class, id="pis", label="PIS", inputType=FilterInputType.TEXT, order=4), @FilterConfigParameter(fieldClass=String.class, id="cpf", label="CPF", inputType=FilterInputType.TEXT, order=5), @FilterConfigParameter(fieldClass=Vinculo.class, id="vinculo", label="V\u00ednculo", inputType=FilterInputType.AUTO_COMPLETE, query="SELECT v FROM Vinculo v WHERE concat(v.vinculoPK.codigo, v.nome) LIKE concat('%', :param, '%') AND v.vinculoPK.entidade = :entidadeCodigo", order=7), @FilterConfigParameter(fieldClass=GrupoPonto.class, id="grupoPonto", label="Grupo", inputType=FilterInputType.AUTO_COMPLETE, query="SELECT g FROM GrupoPonto g where g.grupoPontoPK.entidade = :entidadeCodigo AND concat(g.grupoPontoPK.codigo, g.nome) LIKE concat('%', :param, '%') ", order=9), @FilterConfigParameter(fieldClass=Character.class, id="tipoPonto", label="Tipo de Ponto", inputType=FilterInputType.SELECT_ONE_MENU, condition=FilterCondition.IGUAL, enumClass=TipoPonto.class, enumId="id", enumLabel="label"), @FilterConfigParameter(fieldClass=Cargo.class, id="cargo", label="Cargo", inputType=FilterInputType.AUTO_COMPLETE, query="SELECT c FROM Cargo c WHERE UPPER(concat(c.cargoPK.codigo, c.nome)) LIKE UPPER('%'||:param||'%') AND c.cargoPK.entidade = :entidadeCodigo ORDER BY c.nome"), @FilterConfigParameter(fieldClass=Date.class, id="dataAdmissao", label="Dt. Admiss\u00e3o", inputType=FilterInputType.CALENDAR), @FilterConfigParameter(fieldClass=Subdivisao.class, id="subdivisao", label="Subdivis\u00e3o", inputType=FilterInputType.AUTO_COMPLETE, query="SELECT s FROM Subdivisao s WHERE UPPER(concat(s.subdivisaoPK.codigo, s.nome)) LIKE UPPER('%'||:param||'%') AND s.subdivisaoPK.entidade = :entidadeCodigo"), @FilterConfigParameter(fieldClass=String.class, id="numeroCartao", label="N\u00fam. Cart\u00e3o Ponto"), @FilterConfigParameter(fieldClass=DivisaoPK.class, id="divisoesPerfil", label="Divis\u00f5es Perfil", condition=FilterCondition.SEQUENCIA, hide=true, disable=true), @FilterConfigParameter(fieldClass=GrupoPontoPK.class, id="gruposPontoPerfil", label="Grupo Ponto Perfil", condition=FilterCondition.SEQUENCIA, hide=true, disable=true)})
public class TrabalhadorCartaoPontoVO
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String QUERY_FILTER = "SELECT $R{   [tr.trabalhadorPK.registro],    [NEW br.com.fiorilli.sip.persistence.vo.cartaoponto.TrabalhadorCartaoPontoVO   (tr.trabalhadorPK, tr.matricula, tr.nome, tr.dataAdmissao, jo, gp, tr.ponto)]} FROM Trabalhador tr LEFT JOIN tr.jornada jo LEFT JOIN tr.grupoPonto gp WHERE tr.trabalhadorPK.entidade = :entidadeCodigo AND tr.situacao = '1' AND $P{[registro],[tr.trabalhadorPK.registro],[:registro]} AND $P{[matricula],[tr.matricula],[:matricula]} AND $P{[contrato],[tr.contrato],[:contrato]} AND $P{[nome],[tr.nome],[:nome]} AND $P{[pis],[tr.documentosPessoais.pis],[:pis]} AND $P{[cpf],[tr.documentosPessoais.cpf],[:cpf]} AND $P{[numeroCartao],[tr.ponto.numeroCartao],[:numeroCartao]} AND $P{[dataAdmissao],[tr.dataAdmissao],[:dataAdmissao]} AND $P{[cargo],[tr.cargoAtual],[:cargo]} AND $P{[jornada],[tr.jornada],[:jornada]} AND $P{[divisao],[tr.divisao],[:divisao]}AND $P{[subdivisao],[tr.subdivisao],[:subdivisao]} AND $P{[localTrabalho],[tr.localTrabalho],[:localTrabalho]} AND $P{[vinculo],[tr.vinculo],[:vinculo]} AND $P{[grupoPonto],[tr.grupoPonto],[:grupoPonto]} AND $P{[tipoPonto],[tr.ponto.tipo],[:tipoPonto]} AND $P{[divisoesPerfil], [tr.divisao.divisaoPK], [:divisoesPerfil]} AND $P{[gruposPontoPerfil], [tr.grupoPonto.grupoPontoPK], [:gruposPontoPerfil]} ";
    private final TrabalhadorPK pk;
    private final Integer matricula;
    private final String nome;
    private final Date dataAdmissao;
    private Jornada jornada;
    private Short jornadaCodigo;
    private String jornadaNome;
    private GrupoPonto grupoPonto;
    private Short grupoPontoCodigo;
    private String grupoPontoNome;
    private final TrabalhadorPonto ponto;

    public TrabalhadorCartaoPontoVO(TrabalhadorPK pk, Integer matricula, String nome, Date dataAdmissao, Jornada jornada, GrupoPonto grupoPonto, TrabalhadorPonto ponto) {
        this.pk = pk;
        this.matricula = matricula;
        this.nome = nome;
        this.dataAdmissao = dataAdmissao;
        this.setJornada(jornada);
        this.setGrupoPonto(grupoPonto);
        this.ponto = ponto;
    }

    public TrabalhadorPK getPk() {
        return this.pk;
    }

    public Integer getMatricula() {
        return this.matricula;
    }

    public String getNome() {
        return this.nome;
    }

    public Date getDataAdmissao() {
        return this.dataAdmissao;
    }

    public Jornada getJornada() {
        return this.jornada;
    }

    public void setJornada(Jornada jornada) {
        if (jornada != null) {
            this.jornadaCodigo = jornada.getJornadaPK().getCodigo();
            this.jornadaNome = jornada.getNome();
        } else {
            this.jornadaCodigo = null;
            this.jornadaNome = null;
        }
        this.jornada = jornada;
    }

    public void setJornadaCodigo(Short jornadaCodigo) {
        this.jornadaCodigo = jornadaCodigo;
    }

    public Short getJornadaCodigo() {
        return this.jornadaCodigo;
    }

    public String getJornadaNome() {
        return this.jornadaNome;
    }

    public GrupoPonto getGrupoPonto() {
        return this.grupoPonto;
    }

    public void setGrupoPonto(GrupoPonto grupoPonto) {
        if (grupoPonto != null) {
            this.grupoPontoCodigo = grupoPonto.getGrupoPontoPK().getCodigo();
            this.grupoPontoNome = grupoPonto.getNome();
        }
        this.grupoPonto = grupoPonto;
    }

    public void setGrupoPontoCodigo(Short grupoPontoCodigo) {
        this.grupoPontoCodigo = grupoPontoCodigo;
    }

    public Short getGrupoPontoCodigo() {
        return this.grupoPontoCodigo;
    }

    public String getGrupoPontoNome() {
        return this.grupoPontoNome;
    }

    public TrabalhadorPonto getPonto() {
        return this.ponto;
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TrabalhadorCartaoPontoVO that = (TrabalhadorCartaoPontoVO)o;
        return Objects.equals(this.pk, that.pk);
    }

    public int hashCode() {
        return Objects.hashCode(this.pk);
    }

    private String createChaveLog() {
        StringBuilder stringBuilder = new StringBuilder("[Chave]\n");
        if (this.pk != null) {
            stringBuilder.append("EMPRESA=").append(this.pk.getEntidade()).append("\n");
            stringBuilder.append("REGISTRO=").append(this.pk.getRegistro()).append("\n");
        }
        stringBuilder.append("\n");
        return stringBuilder.toString();
    }

    public String toSiplog(TrabalhadorCartaoPontoVO trabalhadorCartaoPontoVO) {
        StringBuilder mantido = new StringBuilder();
        StringBuilder alterado = new StringBuilder();
        StringBuilder log = new StringBuilder(this.createChaveLog());
        if (trabalhadorCartaoPontoVO != null) {
            if (trabalhadorCartaoPontoVO.getPonto().getTipo() != this.ponto.getTipo()) {
                alterado.append(String.format("TIPOPONTO -> Velho=%s -> Novo=%s\n", trabalhadorCartaoPontoVO.getPonto().getTipo() != null ? trabalhadorCartaoPontoVO.getPonto().getTipo().getId() : null, this.ponto.getTipo() != null ? this.ponto.getTipo().getId() : null));
            } else {
                mantido.append(String.format("TIPOPONTO=%s\n", this.ponto.getTipo() != null ? this.ponto.getTipo().getId() : null));
            }
            if (!Objects.equals(trabalhadorCartaoPontoVO.getPonto().getPontoWebAutorizado(), this.ponto.getPontoWebAutorizado())) {
                Object[] objectArray = new Object[2];
                Object object = trabalhadorCartaoPontoVO.getPonto().getPontoWebAutorizado() != null ? (trabalhadorCartaoPontoVO.getPonto().getPontoWebAutorizado().booleanValue() ? "S" : "N") : (objectArray[0] = null);
                objectArray[1] = this.ponto.getPontoWebAutorizado() != null ? (this.ponto.getPontoWebAutorizado().booleanValue() ? "S" : "N") : null;
                alterado.append(String.format("PONTO_WEB_AUTORIZADO -> Velho=%s -> Novo=%s\n", objectArray));
            } else {
                Object[] objectArray = new Object[1];
                objectArray[0] = this.ponto.getPontoWebAutorizado() != null ? (this.ponto.getPontoWebAutorizado().booleanValue() ? "S" : "N") : null;
                mantido.append(String.format("PONTO_WEB_AUTORIZADO=%s\n", objectArray));
            }
            if (!Objects.equals(trabalhadorCartaoPontoVO.getJornadaCodigo(), this.jornadaCodigo)) {
                alterado.append(String.format("JORNADA -> Velho=%s -> Novo=%s\n", trabalhadorCartaoPontoVO.getJornadaCodigo(), this.jornadaCodigo));
            } else {
                mantido.append(String.format("JORNADA=%s\n", this.jornadaCodigo));
            }
            if (!Objects.equals(trabalhadorCartaoPontoVO.getGrupoPontoCodigo(), this.grupoPontoCodigo)) {
                alterado.append(String.format("GRUPO_PONTO -> Velho=%s -> Novo=%s\n", trabalhadorCartaoPontoVO.getGrupoPonto(), this.grupoPontoCodigo));
            } else {
                mantido.append(String.format("GRUPO_PONTO=%s\n", this.grupoPontoCodigo));
            }
            if (!Objects.equals(trabalhadorCartaoPontoVO.getPonto().getNumeroCartao(), this.ponto.getNumeroCartao())) {
                alterado.append(String.format("PTONUMCARTAO -> Velho=%s -> Novo=%s\n", trabalhadorCartaoPontoVO.getPonto().getNumeroCartao(), this.ponto.getNumeroCartao()));
            } else {
                mantido.append(String.format("PTONUMCARTAO=%s\n", this.ponto.getNumeroCartao()));
            }
            if (!Objects.equals(trabalhadorCartaoPontoVO.getPonto().getNumeroChapeira(), this.ponto.getNumeroChapeira())) {
                alterado.append(String.format("PTONUMCHAPEIRA -> Velho=%s -> Novo=%s\n", trabalhadorCartaoPontoVO.getPonto().getNumeroChapeira(), this.ponto.getNumeroChapeira()));
            } else {
                mantido.append(String.format("PTONUMCHAPEIRA=%s\n", this.ponto.getNumeroChapeira()));
            }
            if (!Objects.equals(trabalhadorCartaoPontoVO.getPonto().getLimiteHoraExtra(), this.ponto.getLimiteHoraExtra())) {
                alterado.append(String.format("LIMITE_HORA_EXTRA -> Velho=%s -> Novo=%s\n", trabalhadorCartaoPontoVO.getPonto().getLimiteHoraExtra(), this.ponto.getLimiteHoraExtra()));
            } else {
                mantido.append(String.format("LIMITE_HORA_EXTRA=%s\n", this.ponto.getLimiteHoraExtra()));
            }
            if (!Objects.equals(trabalhadorCartaoPontoVO.getPonto().getDataImplantacaoCartao(), this.ponto.getDataImplantacaoCartao())) {
                alterado.append(String.format("DT_IMPLATACAO_CARTAO -> Velho=%s -> Novo=%s\n", trabalhadorCartaoPontoVO.getPonto().getDataImplantacaoCartao() != null ? SIPDateUtil.toString((Date)trabalhadorCartaoPontoVO.getPonto().getDataImplantacaoCartao()) : null, this.ponto.getDataImplantacaoCartao() != null ? SIPDateUtil.toString((Date)this.ponto.getDataImplantacaoCartao()) : null));
            } else {
                mantido.append(String.format("DT_IMPLATACAO_CARTAO=%s\n", this.ponto.getDataImplantacaoCartao() != null ? SIPDateUtil.toString((Date)this.ponto.getDataImplantacaoCartao()) : null));
            }
            if (alterado.length() > 0) {
                log.append("[ALTERADO]\n");
                log.append((CharSequence)alterado);
                log.append("\n");
            }
            if (mantido.length() > 0) {
                log.append("[MANTIDO]\n");
                log.append((CharSequence)mantido);
            }
            return log.toString();
        }
        return null;
    }
}

