/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.vo.cartaoponto;

import br.com.fiorilli.filter.annotations.FilterConfigParameter;
import br.com.fiorilli.filter.annotations.FilterConfigParameters;
import br.com.fiorilli.filter.annotations.FilterConfigType;
import br.com.fiorilli.filter.model.FilterCondition;
import br.com.fiorilli.filter.model.FilterInputType;
import br.com.fiorilli.sip.persistence.entity.Cargo;
import br.com.fiorilli.sip.persistence.entity.Divisao;
import br.com.fiorilli.sip.persistence.entity.Jornada;
import br.com.fiorilli.sip.persistence.entity.LocalTrabalho;
import br.com.fiorilli.sip.persistence.entity.Subdivisao;
import br.com.fiorilli.sip.persistence.entity.Vinculo;
import java.util.Date;

@FilterConfigType(query=" SELECT $R{   [pto.id],   [ new br.com.fiorilli.sip.persistence.vo.cartaoponto.PontoTipoOcorrenciaVO        (           pto.id,            p.data,            tr.trabalhadorPK.registro || ' - ' || tr.nome,            to.nome        )   ]}  FROM PontoTipoOcorrencia pto  LEFT JOIN pto.ponto p  LEFT JOIN p.trabalhador tr  LEFT JOIN pto.tipoOcorrencia to  WHERE p.entidadeCodigo = :entidadeCodigo AND $P{[registro],[tr.trabalhadorPK.registro],[:registro]} and $P{[matricula],[tr.matricula],[:matricula]} and $P{[nome],[tr.nome],[:nome]} and $P{[numeroCartao],[tr.ponto.numeroCartao],[:numeroCartao]} and $P{[cargo],[tr.cargoAtual],[:cargo]} and $P{[jornada],[tr.jornada],[:jornada]} and $P{[divisao],[tr.divisao],[:divisao]} and $P{[subdivisao],[tr.subdivisao],[:subdivisao]} and $P{[localTrabalho],[tr.localTrabalho],[:localTrabalho]} and $P{[vinculo],[tr.vinculo],[:vinculo]} ", autoFilter=true, rootEntityAlias="pto")
@FilterConfigParameters(value={@FilterConfigParameter(fieldClass=String.class, id="registro", label="Registro", inputType=FilterInputType.NUMBER, order=1), @FilterConfigParameter(fieldClass=Integer.class, id="matricula", label="Matr\u00edcula", inputType=FilterInputType.NUMBER, order=2), @FilterConfigParameter(fieldClass=String.class, id="nome", label="Nome", inputType=FilterInputType.TEXT, condition=FilterCondition.COMECE, order=3), @FilterConfigParameter(fieldClass=Jornada.class, id="jornada", label="Jornada", inputType=FilterInputType.AUTO_COMPLETE, query="SELECT j FROM Jornada j where j.jornadaPK.entidade = :entidadeCodigo \tand ((\t\t((length(cast(:param as text)) <= 3)) and (cast(j.jornadaPK.codigo as text) = cast(:param as text)))\t\tor ((length(cast(:param as text)) > 3) and \t\t   ((concat(j.jornadaPK.codigo, j.nome) LIKE concat('%', cast(:param as text), '%')) \t\t   or (concat('#', j.apelido) LIKE concat(cast(:param as text), '%')))\t\t))"), @FilterConfigParameter(fieldClass=LocalTrabalho.class, id="localTrabalho", label="Local de Trabalho", inputType=FilterInputType.AUTO_COMPLETE, query="SELECT l FROM LocalTrabalho l where UPPER(concat(l.localTrabalhoPK.codigo, l.nome)) LIKE UPPER('%'||:param||'%') AND l.localTrabalhoPK.entidade = :entidadeCodigo"), @FilterConfigParameter(fieldClass=Vinculo.class, id="vinculo", label="V\u00ednculo", inputType=FilterInputType.AUTO_COMPLETE, query="SELECT v FROM Vinculo v WHERE concat(v.vinculoPK.codigo, v.nome) LIKE concat('%', :param, '%') AND v.vinculoPK.entidade = :entidadeCodigo"), @FilterConfigParameter(fieldClass=Cargo.class, id="cargo", label="Cargo", inputType=FilterInputType.AUTO_COMPLETE, query="SELECT c FROM Cargo c WHERE UPPER(concat(c.cargoPK.codigo, c.nome)) LIKE UPPER('%'||:param||'%') AND c.cargoPK.entidade = :entidadeCodigo ORDER BY c.nome"), @FilterConfigParameter(fieldClass=Divisao.class, id="divisao", label="Divis\u00e3o", inputType=FilterInputType.AUTO_COMPLETE, query="SELECT d FROM Divisao d WHERE UPPER(concat(d.divisaoPK.codigo, d.nome)) LIKE UPPER('%'||:param||'%') AND d.divisaoPK.entidade = :entidadeCodigo"), @FilterConfigParameter(fieldClass=Subdivisao.class, id="subdivisao", label="Subdivis\u00e3o", inputType=FilterInputType.AUTO_COMPLETE, query="SELECT s FROM Subdivisao s WHERE UPPER(concat(s.subdivisaoPK.codigo, s.nome)) LIKE UPPER('%'||:param||'%') AND s.subdivisaoPK.entidade = :entidadeCodigo"), @FilterConfigParameter(fieldClass=String.class, id="numeroCartao", label="N\u00fam. Cart\u00e3o Ponto")})
public class PontoTipoOcorrenciaVO {
    private Integer id;
    private Date data;
    private String trabalhador;
    private String nomeOcorrencia;

    public Integer getId() {
        return this.id;
    }

    public Date getData() {
        return this.data;
    }

    public String getTrabalhador() {
        return this.trabalhador;
    }

    public String getNomeOcorrencia() {
        return this.nomeOcorrencia;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public void setData(Date data) {
        this.data = data;
    }

    public void setTrabalhador(String trabalhador) {
        this.trabalhador = trabalhador;
    }

    public void setNomeOcorrencia(String nomeOcorrencia) {
        this.nomeOcorrencia = nomeOcorrencia;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PontoTipoOcorrenciaVO)) {
            return false;
        }
        PontoTipoOcorrenciaVO other = (PontoTipoOcorrenciaVO)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$id = this.getId();
        Integer other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Date this$data = this.getData();
        Date other$data = other.getData();
        if (this$data == null ? other$data != null : !((Object)this$data).equals(other$data)) {
            return false;
        }
        String this$trabalhador = this.getTrabalhador();
        String other$trabalhador = other.getTrabalhador();
        if (this$trabalhador == null ? other$trabalhador != null : !this$trabalhador.equals(other$trabalhador)) {
            return false;
        }
        String this$nomeOcorrencia = this.getNomeOcorrencia();
        String other$nomeOcorrencia = other.getNomeOcorrencia();
        return !(this$nomeOcorrencia == null ? other$nomeOcorrencia != null : !this$nomeOcorrencia.equals(other$nomeOcorrencia));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PontoTipoOcorrenciaVO;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Date $data = this.getData();
        result = result * 59 + ($data == null ? 43 : ((Object)$data).hashCode());
        String $trabalhador = this.getTrabalhador();
        result = result * 59 + ($trabalhador == null ? 43 : $trabalhador.hashCode());
        String $nomeOcorrencia = this.getNomeOcorrencia();
        result = result * 59 + ($nomeOcorrencia == null ? 43 : $nomeOcorrencia.hashCode());
        return result;
    }

    public String toString() {
        return "PontoTipoOcorrenciaVO(id=" + this.getId() + ", data=" + this.getData() + ", trabalhador=" + this.getTrabalhador() + ", nomeOcorrencia=" + this.getNomeOcorrencia() + ")";
    }

    public PontoTipoOcorrenciaVO(Integer id, Date data, String trabalhador, String nomeOcorrencia) {
        this.id = id;
        this.data = data;
        this.trabalhador = trabalhador;
        this.nomeOcorrencia = nomeOcorrencia;
    }

    public static class PontoTipoOcorrenciaVOSql {
        public static final String QUERY = " SELECT $R{   [pto.id],   [ new br.com.fiorilli.sip.persistence.vo.cartaoponto.PontoTipoOcorrenciaVO        (           pto.id,            p.data,            tr.trabalhadorPK.registro || ' - ' || tr.nome,            to.nome        )   ]}  FROM PontoTipoOcorrencia pto  LEFT JOIN pto.ponto p  LEFT JOIN p.trabalhador tr  LEFT JOIN pto.tipoOcorrencia to  WHERE p.entidadeCodigo = :entidadeCodigo AND $P{[registro],[tr.trabalhadorPK.registro],[:registro]} and $P{[matricula],[tr.matricula],[:matricula]} and $P{[nome],[tr.nome],[:nome]} and $P{[numeroCartao],[tr.ponto.numeroCartao],[:numeroCartao]} and $P{[cargo],[tr.cargoAtual],[:cargo]} and $P{[jornada],[tr.jornada],[:jornada]} and $P{[divisao],[tr.divisao],[:divisao]} and $P{[subdivisao],[tr.subdivisao],[:subdivisao]} and $P{[localTrabalho],[tr.localTrabalho],[:localTrabalho]} and $P{[vinculo],[tr.vinculo],[:vinculo]} ";
    }
}

