/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.vo.cartaoponto;

import br.com.fiorilli.sip.persistence.entity.Jornada;
import br.com.fiorilli.sip.persistence.entity.JornadaDia;
import br.com.fiorilli.sip.persistence.entity.JornadaDiaSemana;
import java.util.Date;
import java.util.List;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.LocalDate;
import org.joda.time.ReadableInstant;

public class JornadaPeriodoVO {
    private final Short jornadaCodigo;
    private final Boolean jornadaLivre;
    private final Interval periodo;
    private final List<JornadaDia> jornadasDias;
    private final Jornada jornada;

    public JornadaPeriodoVO(Jornada jornada, Date dataInicio, Date dataTermino, List<JornadaDia> jornadasDias) {
        this.jornada = jornada;
        this.jornadaCodigo = jornada.getJornadaPK().getCodigo();
        this.jornadaLivre = jornada.getJornadaLivre();
        this.jornadasDias = jornadasDias;
        this.periodo = new Interval((ReadableInstant)new DateTime((Object)dataInicio), (ReadableInstant)new DateTime((Object)dataTermino));
    }

    public Short getJornadaCodigo() {
        return this.jornadaCodigo;
    }

    public Boolean isJornadaLivre() {
        return this.jornadaLivre;
    }

    public Interval getPeriodo() {
        return this.periodo;
    }

    public String toString() {
        return "JornadaPeriodoVO [jornadaCodigo=" + this.jornadaCodigo + ", jornadaLivre=" + this.jornadaLivre + ", periodo=" + this.periodo + "]";
    }

    public JornadaDia getJornadaDia(DateTime dataPonto) {
        JornadaDiaSemana diaDoPonto = JornadaDiaSemana.getByDate(dataPonto.toDate());
        for (JornadaDia jornadaDia : this.jornadasDias) {
            JornadaDiaSemana dia = jornadaDia.getJornadaDiasPK().getDia();
            if (dia != diaDoPonto && !dia.isTurno()) continue;
            return jornadaDia;
        }
        return null;
    }

    public JornadaDia getJornadaDia(LocalDate dataPonto) {
        JornadaDiaSemana diaDoPonto = JornadaDiaSemana.getByDate(dataPonto.toDate());
        for (JornadaDia jornadaDia : this.jornadasDias) {
            JornadaDiaSemana dia = jornadaDia.getJornadaDiasPK().getDia();
            if (dia != diaDoPonto && !dia.isTurno()) continue;
            return jornadaDia;
        }
        return null;
    }

    public JornadaDia getFirstJornadaDia() {
        return !this.jornadasDias.isEmpty() ? this.jornadasDias.listIterator().next() : null;
    }

    public Jornada getJornada() {
        return this.jornada;
    }
}

