/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.vo.cartaoponto;

import br.com.fiorilli.filter.annotations.FilterConfigType;
import br.com.fiorilli.sip.persistence.entity.RepModelo;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;

@FilterConfigType(query="select $R{   [ag.id],   [       new br.com.fiorilli.sip.persistence.vo.cartaoponto.AgendamentoDeJornadaVo       (           ag.id,            concat(tr.matricula, '-', tr.contrato, ' ', tr.nome),            concat(re.mesCodigo, '/', re.ano)        )   ]} from AgendamentoDeJornada ag left join ag.trabalhador tr left join ag.referencia re where ag.entidadeCodigo = :entidadeCodigo and ag.referenciaCodigo = :referenciaCodigo and $P{[registro],[tr.trabalhadorPK.registro],[:registro]} and $P{[matricula],[tr.matricula],[:matricula]} and $P{[nome],[tr.nome],[:nome]} and $P{[numeroCartao],[tr.ponto.numeroCartao],[:numeroCartao]} and $P{[cargo],[tr.cargoAtual],[:cargo]} and $P{[jornada],[tr.jornada],[:jornada]} and $P{[divisao],[tr.divisao],[:divisao]} and $P{[subdivisao],[tr.subdivisao],[:subdivisao]} and $P{[localTrabalho],[tr.localTrabalho],[:localTrabalho]} and $P{[vinculo],[tr.vinculo],[:vinculo]} ")
public class ColetorHistoricoVO {
    private Integer idRep;
    private String descricao;
    private String marca;
    private String modelo;
    private Boolean coletaAutomatica;
    private String horarioColetaAutomatica;
    private Date dataUltimaColeta;
    private Boolean coletado;
    private Boolean importado;

    public ColetorHistoricoVO(Integer idRep, String descricao, RepModelo modelo, Boolean coletaAutomatica, String hora, String minuto, String segundo, Date dataUltimaColeta, Boolean coletado, Boolean importado) {
        this.idRep = idRep;
        this.descricao = descricao;
        this.marca = modelo.getMarca().getDescricao();
        this.modelo = modelo.getDescricao();
        this.coletaAutomatica = coletaAutomatica;
        this.dataUltimaColeta = dataUltimaColeta;
        this.coletado = coletado;
        hora = StringUtils.leftPad((String)hora, (int)2, (String)"0");
        minuto = StringUtils.leftPad((String)minuto, (int)2, (String)"0");
        segundo = StringUtils.leftPad((String)segundo, (int)2, (String)"0");
        this.horarioColetaAutomatica = hora + ":" + minuto + ":" + segundo;
        this.importado = importado;
    }

    public Integer getIdRep() {
        return this.idRep;
    }

    public String getDescricao() {
        return this.descricao;
    }

    public String getMarca() {
        return this.marca;
    }

    public String getModelo() {
        return this.modelo;
    }

    public Boolean getColetaAutomatica() {
        return this.coletaAutomatica;
    }

    public String getHorarioColetaAutomatica() {
        return this.horarioColetaAutomatica;
    }

    public Date getDataUltimaColeta() {
        return this.dataUltimaColeta;
    }

    public Boolean getColetado() {
        return this.coletado;
    }

    public Boolean getImportado() {
        return this.importado;
    }

    public void setIdRep(Integer idRep) {
        this.idRep = idRep;
    }

    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    public void setMarca(String marca) {
        this.marca = marca;
    }

    public void setModelo(String modelo) {
        this.modelo = modelo;
    }

    public void setColetaAutomatica(Boolean coletaAutomatica) {
        this.coletaAutomatica = coletaAutomatica;
    }

    public void setHorarioColetaAutomatica(String horarioColetaAutomatica) {
        this.horarioColetaAutomatica = horarioColetaAutomatica;
    }

    public void setDataUltimaColeta(Date dataUltimaColeta) {
        this.dataUltimaColeta = dataUltimaColeta;
    }

    public void setColetado(Boolean coletado) {
        this.coletado = coletado;
    }

    public void setImportado(Boolean importado) {
        this.importado = importado;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ColetorHistoricoVO)) {
            return false;
        }
        ColetorHistoricoVO other = (ColetorHistoricoVO)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$idRep = this.getIdRep();
        Integer other$idRep = other.getIdRep();
        if (this$idRep == null ? other$idRep != null : !((Object)this$idRep).equals(other$idRep)) {
            return false;
        }
        String this$descricao = this.getDescricao();
        String other$descricao = other.getDescricao();
        if (this$descricao == null ? other$descricao != null : !this$descricao.equals(other$descricao)) {
            return false;
        }
        String this$marca = this.getMarca();
        String other$marca = other.getMarca();
        if (this$marca == null ? other$marca != null : !this$marca.equals(other$marca)) {
            return false;
        }
        String this$modelo = this.getModelo();
        String other$modelo = other.getModelo();
        if (this$modelo == null ? other$modelo != null : !this$modelo.equals(other$modelo)) {
            return false;
        }
        Boolean this$coletaAutomatica = this.getColetaAutomatica();
        Boolean other$coletaAutomatica = other.getColetaAutomatica();
        if (this$coletaAutomatica == null ? other$coletaAutomatica != null : !((Object)this$coletaAutomatica).equals(other$coletaAutomatica)) {
            return false;
        }
        String this$horarioColetaAutomatica = this.getHorarioColetaAutomatica();
        String other$horarioColetaAutomatica = other.getHorarioColetaAutomatica();
        if (this$horarioColetaAutomatica == null ? other$horarioColetaAutomatica != null : !this$horarioColetaAutomatica.equals(other$horarioColetaAutomatica)) {
            return false;
        }
        Date this$dataUltimaColeta = this.getDataUltimaColeta();
        Date other$dataUltimaColeta = other.getDataUltimaColeta();
        if (this$dataUltimaColeta == null ? other$dataUltimaColeta != null : !((Object)this$dataUltimaColeta).equals(other$dataUltimaColeta)) {
            return false;
        }
        Boolean this$coletado = this.getColetado();
        Boolean other$coletado = other.getColetado();
        if (this$coletado == null ? other$coletado != null : !((Object)this$coletado).equals(other$coletado)) {
            return false;
        }
        Boolean this$importado = this.getImportado();
        Boolean other$importado = other.getImportado();
        return !(this$importado == null ? other$importado != null : !((Object)this$importado).equals(other$importado));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ColetorHistoricoVO;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $idRep = this.getIdRep();
        result = result * 59 + ($idRep == null ? 43 : ((Object)$idRep).hashCode());
        String $descricao = this.getDescricao();
        result = result * 59 + ($descricao == null ? 43 : $descricao.hashCode());
        String $marca = this.getMarca();
        result = result * 59 + ($marca == null ? 43 : $marca.hashCode());
        String $modelo = this.getModelo();
        result = result * 59 + ($modelo == null ? 43 : $modelo.hashCode());
        Boolean $coletaAutomatica = this.getColetaAutomatica();
        result = result * 59 + ($coletaAutomatica == null ? 43 : ((Object)$coletaAutomatica).hashCode());
        String $horarioColetaAutomatica = this.getHorarioColetaAutomatica();
        result = result * 59 + ($horarioColetaAutomatica == null ? 43 : $horarioColetaAutomatica.hashCode());
        Date $dataUltimaColeta = this.getDataUltimaColeta();
        result = result * 59 + ($dataUltimaColeta == null ? 43 : ((Object)$dataUltimaColeta).hashCode());
        Boolean $coletado = this.getColetado();
        result = result * 59 + ($coletado == null ? 43 : ((Object)$coletado).hashCode());
        Boolean $importado = this.getImportado();
        result = result * 59 + ($importado == null ? 43 : ((Object)$importado).hashCode());
        return result;
    }

    public String toString() {
        return "ColetorHistoricoVO(idRep=" + this.getIdRep() + ", descricao=" + this.getDescricao() + ", marca=" + this.getMarca() + ", modelo=" + this.getModelo() + ", coletaAutomatica=" + this.getColetaAutomatica() + ", horarioColetaAutomatica=" + this.getHorarioColetaAutomatica() + ", dataUltimaColeta=" + this.getDataUltimaColeta() + ", coletado=" + this.getColetado() + ", importado=" + this.getImportado() + ")";
    }

    public static final class ColetorHistoricoVOSql {
        public static final String QUERY = "SELECT new " + ColetorHistoricoVO.class.getName() + " (r.id, r.descricao, r.modelo, r.habilitado, CAST(COALESCE(r.hora, '00') AS text), CAST(COALESCE(r.minuto, '00') AS text), CAST(COALESCE(r.segundo, '00') AS text), " + " c.dataColeta, c.coletado, c.importado) " + " FROM RepConfig r, ColetorRepHistorico c  " + " WHERE r.entidadeCodigo = :entidade " + " AND c.id = (SELECT MAX(c2.id) FROM ColetorRepHistorico c2 WHERE c2.repConfigId = r.id) " + " ORDER BY r.id ASC, c.dataColeta DESC ";
    }
}

