/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.vo.cartaoponto;

import br.com.fiorilli.filter.annotations.FilterConfigParameter;
import br.com.fiorilli.filter.annotations.FilterConfigParameters;
import br.com.fiorilli.filter.annotations.FilterConfigType;
import br.com.fiorilli.filter.model.FilterCondition;
import br.com.fiorilli.filter.model.FilterInputType;
import br.com.fiorilli.sip.persistence.entity.Cargo;
import br.com.fiorilli.sip.persistence.entity.Divisao;
import br.com.fiorilli.sip.persistence.entity.Jornada;
import br.com.fiorilli.sip.persistence.entity.LocalTrabalho;
import br.com.fiorilli.sip.persistence.entity.Subdivisao;
import br.com.fiorilli.sip.persistence.entity.Vinculo;
import java.util.Objects;

@FilterConfigType(query="select $R{   [ag.id],   [       new br.com.fiorilli.sip.persistence.vo.cartaoponto.AgendamentoDeJornadaVo       (           ag.id,            concat(tr.matricula, '-', tr.contrato, ' ', tr.nome),            concat(re.mesCodigo, '/', re.ano)        )   ]} from AgendamentoDeJornada ag left join ag.trabalhador tr left join ag.referencia re where ag.entidadeCodigo = :entidadeCodigo and ag.referenciaCodigo = :referenciaCodigo and $P{[registro],[tr.trabalhadorPK.registro],[:registro]} and $P{[matricula],[tr.matricula],[:matricula]} and $P{[nome],[tr.nome],[:nome]} and $P{[numeroCartao],[tr.ponto.numeroCartao],[:numeroCartao]} and $P{[cargo],[tr.cargoAtual],[:cargo]} and $P{[jornada],[tr.jornada],[:jornada]} and $P{[divisao],[tr.divisao],[:divisao]} and $P{[subdivisao],[tr.subdivisao],[:subdivisao]} and $P{[localTrabalho],[tr.localTrabalho],[:localTrabalho]} and $P{[vinculo],[tr.vinculo],[:vinculo]} ", rootEntityAlias="ag", autoFilter=true)
@FilterConfigParameters(value={@FilterConfigParameter(fieldClass=String.class, id="registro", label="Registro", inputType=FilterInputType.NUMBER, order=1), @FilterConfigParameter(fieldClass=Integer.class, id="matricula", label="Matr\u00edcula", inputType=FilterInputType.NUMBER, order=2), @FilterConfigParameter(fieldClass=String.class, id="nome", label="Nome", inputType=FilterInputType.TEXT, condition=FilterCondition.COMECE, order=3), @FilterConfigParameter(fieldClass=Jornada.class, id="jornada", label="Jornada", inputType=FilterInputType.AUTO_COMPLETE, query="SELECT j FROM Jornada j where j.jornadaPK.entidade = :entidadeCodigo \tand ((\t\t((length(cast(:param as text)) <= 3)) and (cast(j.jornadaPK.codigo as text) = cast(:param as text)))\t\tor ((length(cast(:param as text)) > 3) and \t\t   ((concat(j.jornadaPK.codigo, j.nome) LIKE concat('%', cast(:param as text), '%')) \t\t   or (concat('#', j.apelido) LIKE concat(cast(:param as text), '%')))\t\t))"), @FilterConfigParameter(fieldClass=LocalTrabalho.class, id="localTrabalho", label="Local de Trabalho", inputType=FilterInputType.AUTO_COMPLETE, query="SELECT l FROM LocalTrabalho l where UPPER(concat(l.localTrabalhoPK.codigo, l.nome)) LIKE UPPER('%'||:param||'%') AND l.localTrabalhoPK.entidade = :entidadeCodigo"), @FilterConfigParameter(fieldClass=Vinculo.class, id="vinculo", label="V\u00ednculo", inputType=FilterInputType.AUTO_COMPLETE, query="SELECT v FROM Vinculo v WHERE concat(v.vinculoPK.codigo, v.nome) LIKE concat('%', :param, '%') AND v.vinculoPK.entidade = :entidadeCodigo"), @FilterConfigParameter(fieldClass=Cargo.class, id="cargo", label="Cargo", inputType=FilterInputType.AUTO_COMPLETE, query="SELECT c FROM Cargo c WHERE UPPER(concat(c.cargoPK.codigo, c.nome)) LIKE UPPER('%'||:param||'%') AND c.cargoPK.entidade = :entidadeCodigo ORDER BY c.nome"), @FilterConfigParameter(fieldClass=Divisao.class, id="divisao", label="Divis\u00e3o", inputType=FilterInputType.AUTO_COMPLETE, query="SELECT d FROM Divisao d WHERE UPPER(concat(d.divisaoPK.codigo, d.nome)) LIKE UPPER('%'||:param||'%') AND d.divisaoPK.entidade = :entidadeCodigo"), @FilterConfigParameter(fieldClass=Subdivisao.class, id="subdivisao", label="Subdivis\u00e3o", inputType=FilterInputType.AUTO_COMPLETE, query="SELECT s FROM Subdivisao s WHERE UPPER(concat(s.subdivisaoPK.codigo, s.nome)) LIKE UPPER('%'||:param||'%') AND s.subdivisaoPK.entidade = :entidadeCodigo"), @FilterConfigParameter(fieldClass=String.class, id="numeroCartao", label="N\u00fam. Cart\u00e3o Ponto")})
public class AgendamentoDeJornadaVo {
    public static final String QUERY = "select $R{   [ag.id],   [       new br.com.fiorilli.sip.persistence.vo.cartaoponto.AgendamentoDeJornadaVo       (           ag.id,            concat(tr.matricula, '-', tr.contrato, ' ', tr.nome),            concat(re.mesCodigo, '/', re.ano)        )   ]} from AgendamentoDeJornada ag left join ag.trabalhador tr left join ag.referencia re where ag.entidadeCodigo = :entidadeCodigo and ag.referenciaCodigo = :referenciaCodigo and $P{[registro],[tr.trabalhadorPK.registro],[:registro]} and $P{[matricula],[tr.matricula],[:matricula]} and $P{[nome],[tr.nome],[:nome]} and $P{[numeroCartao],[tr.ponto.numeroCartao],[:numeroCartao]} and $P{[cargo],[tr.cargoAtual],[:cargo]} and $P{[jornada],[tr.jornada],[:jornada]} and $P{[divisao],[tr.divisao],[:divisao]} and $P{[subdivisao],[tr.subdivisao],[:subdivisao]} and $P{[localTrabalho],[tr.localTrabalho],[:localTrabalho]} and $P{[vinculo],[tr.vinculo],[:vinculo]} ";
    private Integer id;
    private String trabalhador;
    private String referencia;

    public AgendamentoDeJornadaVo(Integer id, String trabalhador, String referencia) {
        this.id = id;
        this.trabalhador = trabalhador;
        this.referencia = referencia;
    }

    public Integer getId() {
        return this.id;
    }

    public String getTrabalhador() {
        return this.trabalhador;
    }

    public String getReferencia() {
        return this.referencia;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AgendamentoDeJornadaVo that = (AgendamentoDeJornadaVo)o;
        return Objects.equals(this.id, that.id);
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }

    public String toString() {
        return "AgendamentoDeJornadaVo{id=" + this.id + ", trabalhador='" + this.trabalhador + '\'' + ", referencia='" + this.referencia + '\'' + '}';
    }
}

