/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.vo.audesp;

import br.com.fiorilli.sip.commons.util.SIPUtil;
import br.com.fiorilli.sip.persistence.entity.Parentesco;
import br.com.fiorilli.sip.persistence.entity.Pessoa;
import br.com.fiorilli.sip.persistence.vo.audesp.AgentePublicoPensionistaAudespVO;
import br.gov.sp.tce.persistence.entity.QualificacaoPensionistaAudesp;
import br.gov.sp.tce.persistence.entity.TipoDocumentoPessoalAudesp;
import java.util.Date;
import java.util.Objects;

public class PensionistaAudespVO {
    private final String nome;
    private final Date dataNascimento;
    private final Short tipoDocumento;
    private final String numero;
    private final Short qualificacaoPensionista;
    private final String outraQualificacao;
    private final AgentePublicoPensionistaAudespVO agentePublico;

    public PensionistaAudespVO(String nome, Date dataNascimento, String cpf, String certidaoNascimento, String rg, String pis, String parentescoCodigo, Date dataConcessaoPensao, String nomeAgente, String cpfAgente, String pisAgente, String codigoCargo, String nomeCargo, Date dataLotacao, Date dataExercicio, Boolean aposentado, Date dataObito, String fundamentoLegal, Pessoa responsavel, String codigoMunicipio, Integer codigoEntidade) {
        this.nome = SIPUtil.getSemAcento((String)nome);
        this.dataNascimento = dataNascimento;
        if (!cpf.trim().isEmpty()) {
            this.tipoDocumento = TipoDocumentoPessoalAudesp.CPF.getCodigo();
            this.numero = cpf;
        } else if (!certidaoNascimento.trim().isEmpty()) {
            this.tipoDocumento = TipoDocumentoPessoalAudesp.CERTIDAO_NASCIMENTO.getCodigo();
            this.numero = certidaoNascimento;
        } else if (!rg.trim().isEmpty()) {
            this.tipoDocumento = TipoDocumentoPessoalAudesp.RG.getCodigo();
            this.numero = rg;
        } else if (!pis.trim().isEmpty()) {
            this.tipoDocumento = TipoDocumentoPessoalAudesp.PIS_PASEP.getCodigo();
            this.numero = pis;
        } else {
            this.tipoDocumento = 0;
            this.numero = "";
        }
        Parentesco parentesco = Parentesco.of(parentescoCodigo);
        this.qualificacaoPensionista = QualificacaoPensionistaAudesp.getBy(parentesco).getCodigo();
        this.outraQualificacao = QualificacaoPensionistaAudesp.getBy(this.qualificacaoPensionista).isOutros() ? parentesco.getDescricaoAbreviada() : null;
        this.agentePublico = new AgentePublicoPensionistaAudespVO(nomeAgente, cpfAgente, pisAgente, codigoCargo, nomeCargo, dataLotacao, dataExercicio, aposentado != false ? "" : null, dataObito, dataConcessaoPensao, fundamentoLegal, responsavel != null ? responsavel.getCpf() : "", responsavel != null ? responsavel.getNome() : "", codigoMunicipio, codigoEntidade);
        this.agentePublico.addPensionista(this);
    }

    public String getNome() {
        return this.nome;
    }

    public Date getDataNascimento() {
        return this.dataNascimento;
    }

    public Short getTipoDocumento() {
        return this.tipoDocumento;
    }

    public String getNumero() {
        return this.numero;
    }

    public Short getQualificacaoPensionista() {
        return this.qualificacaoPensionista;
    }

    public String getOutraQualificacao() {
        return this.outraQualificacao;
    }

    public AgentePublicoPensionistaAudespVO getAgentePublico() {
        return this.agentePublico;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PensionistaAudespVO that = (PensionistaAudespVO)o;
        return Objects.equals(this.nome, that.nome) && Objects.equals(this.dataNascimento, that.dataNascimento);
    }

    public int hashCode() {
        return Objects.hash(this.nome, this.dataNascimento);
    }
}

