/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.vo.audesp;

import br.com.fiorilli.sip.commons.util.SIPUtil;
import br.com.fiorilli.sip.persistence.entity.CargoNatureza;
import br.com.fiorilli.sip.persistence.entity.ClassificacaoCargoAgentePolitico;
import br.com.fiorilli.sip.persistence.entity.EntidadeAudesp;
import br.com.fiorilli.sip.persistence.entity.RegimeJuridico;
import br.com.fiorilli.sip.persistence.entity.TrabalhadorTipoCargo;
import br.com.fiorilli.sip.persistence.vo.audesp.IdentificacaoTrabalhadorAudespVO;
import br.gov.sp.tce.persistence.entity.FuncaoGoverno;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class PagamentoFolhaOrdinariaAudespVO {
    private final boolean pagamentoNaContaCorrente;
    private final IdentificacaoTrabalhadorAudespVO identificacaoTrabalhador;
    private final String banco;
    private final String agencia;
    private final String contaCorrente;
    private final Boolean pensionista;
    private final Double valor;
    private final String tipoConta;

    public PagamentoFolhaOrdinariaAudespVO(Integer entidade, String municipio, String cpf, String nome, String cargo, String tipoCargo, ClassificacaoCargoAgentePolitico classificacao, FuncaoGoverno funcaoGoverno, CargoNatureza natureza, RegimeJuridico regimeJuridico, Boolean pensionista, String banco, String agencia, String agenciaDigito, String contaCorrente, String contaCorrenteDigito, Double valor, String tipoConta) {
        this.identificacaoTrabalhador = new IdentificacaoTrabalhadorAudespVO(cpf, nome, new EntidadeAudesp(entidade, municipio), cargo, "", TrabalhadorTipoCargo.of(tipoCargo), classificacao, funcaoGoverno, natureza, regimeJuridico, null, false, pensionista);
        this.banco = banco;
        String agenciaTmp = SIPUtil.removeZerosAtLeftIn((String)agencia);
        if (!StringUtils.isEmpty((CharSequence)agenciaDigito) && !StringUtils.isBlank((CharSequence)agenciaDigito)) {
            agenciaTmp = agenciaTmp + agenciaDigito;
        }
        this.agencia = agenciaTmp;
        String contaCorrenteTmp = SIPUtil.removeZerosAtLeftIn((String)contaCorrente);
        if (!StringUtils.isEmpty((CharSequence)contaCorrenteDigito) && !StringUtils.isBlank((CharSequence)contaCorrenteDigito)) {
            contaCorrenteTmp = contaCorrenteTmp + contaCorrenteDigito;
        }
        this.contaCorrente = contaCorrenteTmp;
        this.pensionista = pensionista;
        this.valor = valor;
        this.pagamentoNaContaCorrente = StringUtils.isNotBlank((CharSequence)banco) && !banco.equals("000") && StringUtils.isNotBlank((CharSequence)agencia) && StringUtils.isNotBlank((CharSequence)contaCorrente);
        this.tipoConta = tipoConta;
    }

    public IdentificacaoTrabalhadorAudespVO getIdentificacaoTrabalhador() {
        return this.identificacaoTrabalhador;
    }

    public String getBanco() {
        return this.banco;
    }

    public String getAgencia() {
        return this.agencia;
    }

    public String getContaCorrente() {
        return this.contaCorrente;
    }

    public Boolean isPensionista() {
        return this.pensionista;
    }

    public Double getValor() {
        return this.valor;
    }

    public boolean isPagamentoNaContaCorrente() {
        return this.pagamentoNaContaCorrente;
    }

    public String getTipoConta() {
        return this.tipoConta;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PagamentoFolhaOrdinariaAudespVO that = (PagamentoFolhaOrdinariaAudespVO)o;
        return Objects.equals(this.identificacaoTrabalhador, that.identificacaoTrabalhador);
    }

    public int hashCode() {
        return Objects.hash(this.identificacaoTrabalhador);
    }

    public String toString() {
        return "FolhaOrdinariaPagamentoAudespVO [entidade=" + this.identificacaoTrabalhador.getEntidadeAudesp() + ", cpf=" + this.identificacaoTrabalhador.getCpf() + ", cargo=" + this.identificacaoTrabalhador.getCargo() + ", banco=" + this.banco + ", agencia=" + this.agencia + ", contaCorrente=" + this.contaCorrente + ", valor=" + this.valor + "]";
    }
}

