/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.vo.audesp;

import br.com.fiorilli.sip.persistence.entity.CargoNatureza;
import br.com.fiorilli.sip.persistence.entity.TrabalhadorTipoCargo;
import br.gov.sp.tce.persistence.entity.FormaProvimentoCargoAudesp;
import br.gov.sp.tce.persistence.entity.FuncaoGoverno;
import br.gov.sp.tce.persistence.entity.TipoExercicioAtividadeCargoAudesp;
import java.util.Date;

public class LotacaoAgentePublicoAudespVO {
    private final String cpf;
    private final Date dataLotacao;
    private final TipoExercicioAtividadeCargoAudesp tipoExercicioAtividade;
    private final String unidade;
    private final FuncaoGoverno funcaoGoverno;
    private final FormaProvimentoCargoAudesp formaProvimento;
    private final Date dataExercicio;
    private final String codigoCargo;
    private final String nome;
    private final boolean temporario;

    public LotacaoAgentePublicoAudespVO(String nome, String codigoCargo, String cpf, Date dataExercicio, Date dataLotacao, String tipoCargoInicial, String tipoCargoAtual, FormaProvimentoCargoAudesp formaProvimento, String unidade, FuncaoGoverno funcaoGoverno, CargoNatureza natureza) {
        this.nome = nome;
        this.codigoCargo = codigoCargo;
        this.cpf = cpf;
        this.dataExercicio = dataExercicio;
        this.dataLotacao = dataLotacao;
        this.formaProvimento = this.updateFormaProvimento(tipoCargoInicial, formaProvimento);
        this.unidade = unidade;
        this.funcaoGoverno = funcaoGoverno;
        this.tipoExercicioAtividade = this.getTipoExercicioAtividade(tipoCargoInicial, tipoCargoAtual, natureza);
        this.temporario = TrabalhadorTipoCargo.CONTRATO_TEMPORARIO.getCodigo().equals(tipoCargoInicial);
    }

    public LotacaoAgentePublicoAudespVO(String nome, String codigoCargo, String cpf, Date dataExercicio, Date dataLotacao, TipoExercicioAtividadeCargoAudesp exercicioAtividade, FormaProvimentoCargoAudesp formaProvimento, String unidade, FuncaoGoverno funcaoGoverno, String tipoCargoInicial) {
        this.nome = nome;
        this.codigoCargo = codigoCargo;
        this.cpf = cpf;
        this.dataExercicio = dataExercicio;
        this.dataLotacao = dataLotacao;
        this.tipoExercicioAtividade = exercicioAtividade;
        this.formaProvimento = formaProvimento;
        this.unidade = unidade;
        this.funcaoGoverno = funcaoGoverno;
        this.temporario = TrabalhadorTipoCargo.CONTRATO_TEMPORARIO.getCodigo().equals(tipoCargoInicial);
    }

    public LotacaoAgentePublicoAudespVO(String nome, String codigoCargo, String cpf, Date dataExercicio, Date dataLotacao, TipoExercicioAtividadeCargoAudesp tipoExercicioAtividade, Integer codigoExercicioAtividade, FormaProvimentoCargoAudesp formaProvimento, String unidade, FuncaoGoverno funcaoGoverno, String tipoCargoInicial) {
        this.nome = nome;
        this.codigoCargo = codigoCargo;
        this.cpf = cpf;
        this.dataExercicio = dataExercicio;
        this.dataLotacao = dataLotacao;
        this.tipoExercicioAtividade = tipoExercicioAtividade != null ? tipoExercicioAtividade : TipoExercicioAtividadeCargoAudesp.of(codigoExercicioAtividade.shortValue());
        this.formaProvimento = formaProvimento;
        this.unidade = unidade;
        this.funcaoGoverno = funcaoGoverno;
        this.temporario = TrabalhadorTipoCargo.CONTRATO_TEMPORARIO.getCodigo().equals(tipoCargoInicial);
    }

    public String getCodigoCargo() {
        return this.codigoCargo;
    }

    public String getCpf() {
        return this.cpf;
    }

    public Date getDataExercicio() {
        return this.dataExercicio;
    }

    public Date getDataLotacao() {
        return this.dataLotacao;
    }

    public FormaProvimentoCargoAudesp getFormaProvimento() {
        return this.formaProvimento;
    }

    public FuncaoGoverno getFuncaoGoverno() {
        return this.funcaoGoverno;
    }

    public String getUnidade() {
        return this.unidade;
    }

    public TipoExercicioAtividadeCargoAudesp getTipoExercicioAtividade() {
        return this.tipoExercicioAtividade;
    }

    private TipoExercicioAtividadeCargoAudesp getTipoExercicioAtividade(String tipoCargoInicialCodigo, String tipoCargoAtualCodigo, CargoNatureza natureza) {
        if (natureza != null && natureza == CargoNatureza.ESTAVEL) {
            return TipoExercicioAtividadeCargoAudesp.ESTAVEL;
        }
        if (FormaProvimentoCargoAudesp.ELEICAO == this.formaProvimento) {
            return TipoExercicioAtividadeCargoAudesp.ELETIVO;
        }
        TrabalhadorTipoCargo tipoInicial = TrabalhadorTipoCargo.of(tipoCargoInicialCodigo);
        TrabalhadorTipoCargo tipoAtual = TrabalhadorTipoCargo.of(tipoCargoAtualCodigo);
        if ((tipoInicial.isCargoEfetivo() || tipoInicial.isEmpregoEfetivo()) && tipoAtual.isComissaoConfianca()) {
            return TipoExercicioAtividadeCargoAudesp.EFETIVO_EM_COMISSAO;
        }
        if (tipoInicial.isComissaoConfianca() && tipoAtual.isComissaoConfianca()) {
            return TipoExercicioAtividadeCargoAudesp.EXCLUSIVAMENTE_EM_COMISSAO;
        }
        if (tipoAtual.isCargoEfetivo() || tipoAtual.isEmpregoEfetivo()) {
            return TipoExercicioAtividadeCargoAudesp.EFETIVO;
        }
        return TipoExercicioAtividadeCargoAudesp.TEMPORARIO;
    }

    private FormaProvimentoCargoAudesp updateFormaProvimento(String tipoCargoInicial, FormaProvimentoCargoAudesp formaProvimento) {
        if (FormaProvimentoCargoAudesp.ELEICAO.equals((Object)formaProvimento)) {
            return formaProvimento;
        }
        if ("1".equals(tipoCargoInicial)) {
            return FormaProvimentoCargoAudesp.CONCURSO_PUBLICO;
        }
        if ("2".equals(tipoCargoInicial)) {
            return FormaProvimentoCargoAudesp.LIVRE_PROVIMENTO;
        }
        if ("4".equals(tipoCargoInicial)) {
            return FormaProvimentoCargoAudesp.TEMPO_DETERMINADO;
        }
        return formaProvimento;
    }

    public String getKey() {
        return this.cpf + this.codigoCargo + this.dataLotacao + this.dataExercicio;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.codigoCargo == null ? 0 : this.codigoCargo.hashCode());
        result = 31 * result + (this.cpf == null ? 0 : this.cpf.hashCode());
        result = 31 * result + (this.dataLotacao == null ? 0 : this.dataLotacao.hashCode());
        result = 31 * result + (this.dataExercicio == null ? 0 : this.dataExercicio.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LotacaoAgentePublicoAudespVO other = (LotacaoAgentePublicoAudespVO)obj;
        if (this.codigoCargo == null ? other.codigoCargo != null : !this.codigoCargo.equals(other.codigoCargo)) {
            return false;
        }
        if (this.cpf == null ? other.cpf != null : !this.cpf.equals(other.cpf)) {
            return false;
        }
        if (this.dataLotacao == null ? other.dataLotacao != null : !this.dataLotacao.equals(other.dataLotacao)) {
            return false;
        }
        return !(this.dataExercicio == null ? other.dataExercicio != null : !this.dataExercicio.equals(other.dataExercicio));
    }

    public String toString() {
        return "LotacaoAgentePublicoAudespVO [cpf=" + this.cpf + ", dataLotacao=" + this.dataLotacao + ", tipoExercicioAtividade=" + (Object)((Object)this.tipoExercicioAtividade) + ", unidade=" + this.unidade + ", funcaoGoverno=" + (Object)((Object)this.funcaoGoverno) + ", formaProvimento=" + (Object)((Object)this.formaProvimento) + ", dataExercicio=" + this.dataExercicio + ", codigoCargo=" + this.codigoCargo + ", nome=" + this.nome + "]";
    }

    public String getNome() {
        return this.nome;
    }

    public boolean isTemporario() {
        return this.temporario;
    }
}

