/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.vo.audesp;

import br.com.fiorilli.sip.persistence.entity.EntidadeAudesp;
import br.com.fiorilli.sip.persistence.entity.EventoNatureza;

public class FolhaDetalhesAudespVO {
    private final EntidadeAudesp entidadeAudesp;
    private final String entidade;
    private final String registro;
    private final String cpf;
    private final String evento;
    private final Double valor;
    private final Integer natureza;
    private final EventoNatureza especie;
    private final Integer classificacaoTCE;
    private final String cargoCodigo;
    private final TipoVerba tipoVerba;
    private Object quantidade;
    private final Integer codigoReferencia;

    public FolhaDetalhesAudespVO(String entidade, String registro, Integer codigoEntidadeAudesp, String codigoMunicipioAudesp, String cpf, String evento, Integer natureza, EventoNatureza especie, Integer classificacaoTCE, String cargoCodigo, Double valor, Object quantidade, Integer codigoReferencia) {
        this.registro = registro;
        this.cargoCodigo = cargoCodigo;
        this.entidadeAudesp = new EntidadeAudesp(codigoEntidadeAudesp, codigoMunicipioAudesp);
        this.cpf = cpf;
        this.entidade = entidade;
        this.evento = evento;
        this.valor = valor;
        this.natureza = natureza;
        this.especie = especie;
        this.classificacaoTCE = classificacaoTCE;
        this.tipoVerba = TipoVerba.getBy(classificacaoTCE);
        this.quantidade = quantidade;
        this.codigoReferencia = codigoReferencia;
    }

    public String getEvento() {
        return this.evento;
    }

    public Double getValor() {
        return this.valor;
    }

    public Integer getNatureza() {
        return this.natureza;
    }

    public EventoNatureza getEspecie() {
        return this.especie;
    }

    public String getEntidade() {
        return this.entidade;
    }

    public Integer getClassificacaoTCE() {
        return this.classificacaoTCE;
    }

    public String getCpf() {
        return this.cpf;
    }

    public EntidadeAudesp getEntidadeAudesp() {
        return this.entidadeAudesp;
    }

    public String getCargoCodigo() {
        return this.cargoCodigo;
    }

    public String getRegistro() {
        return this.registro;
    }

    public Object getQuantidade() {
        return this.quantidade;
    }

    public void setQuantidade(Object quantidade) {
        this.quantidade = quantidade;
    }

    public TipoVerba getTipoVerba() {
        return this.tipoVerba;
    }

    public Integer getCodigoReferencia() {
        return this.codigoReferencia;
    }

    public static enum TipoVerba {
        SUBSIDIO(100, "Subs\u00eddio"),
        VERBA_REPRESENTACAO(101, "Verba de Representa\u00e7\u00e3o"),
        SESSOES_EXTRAORDINARIAS(102, "Sess\u00f5es Extraordin\u00e1rias"),
        VENCIMENTOS_VANTAGENS_FIXAS_PESSOAL_CIVIL_MILITAR(103, "Vencimentos e Vantagens Fixas Pessoal Civil e Militar"),
        VANTAGENS_PESSOAIS(104, "Vantagens Pessoais"),
        HONORARIOS_ADVOCATICIOS(105, "Honor\u00e1rios Advocat\u00edcios"),
        FERIAS_UM_TERCO(106, "F\u00e9rias 1/3"),
        HORA_EXTRA(107, "Hora Extra"),
        JETON_HONORARIO_MEMBRO_CONSELHO(108, "Jeton/Honor\u00e1rio Membro de Conselho"),
        GRATIFICACAOES(109, "Gratifica\u00e7\u00f5es"),
        OUTRAS_VERBAS(110, "Outras Verbas Remunerat\u00f3rias"),
        REMUNERACAO_ATRASO(111, "Remunera\u00e7\u00e3o em Atraso"),
        INDENIZACOES(112, "Indeniza\u00e7\u00f5es"),
        BENEFICIOS_PREVIDENCIARIOS(113, "Benef\u00edcios Previdenci\u00e1rios e Assistenciais"),
        OUTROS_BENEFICIOS(114, "Outros Benef\u00edcios"),
        ABONO_PERMANENCIA(115, "Abono Perman\u00eancia"),
        PROVENTOS_APOSENTADORIA_RESERVA_REFORMA(116, "Proventos de Aposentadoria, de Reserva ou de Reforma"),
        PROVENTOS_PENSAO(117, "Proventos de Pens\u00e3o"),
        DECISAO_JUDICIAL(118, "Decis\u00e3o Judicial"),
        DECIMO_TERCEIRO(119, "13\u00ba Sal\u00e1rio"),
        DECIMO_QUARTO(120, "14\u00ba Sal\u00e1rio"),
        DECIMO_QUINTO(121, "15\u00ba Sal\u00e1rio"),
        BENEFICIOS_ASSISTENCIAS(122, "Benef\u00edcios Assistenciais"),
        FERIAS_INDENIZADAS(123, "F\u00e9rias"),
        LICENCA_PREMIO_INDENIZADAS(124, "Licen\u00e7a-Pr\u00eamio Indenizada"),
        CONTRIBUICAO_PREVIDENCIARIA_REGIME_GERAL(200, "Contribui\u00e7\u00e3o Previdenci\u00e1ria Regime Geral"),
        CONTRIBUICAO_PREVIDENCIARIA_REGIME_PROPRIO(201, "Contribui\u00e7\u00e3o Previdenci\u00e1ria Regime Pr\u00f3prio"),
        CONTRIBUICAO_PREVIDENCIARIA_COMPLEMENTAR(202, "Contribui\u00e7\u00e3o Previdenci\u00e1ria Complementar - Facultativa"),
        OUTRAS_CONTRIBUICOES_PREVIDENCIARIAS(203, "Outras Contribui\u00e7\u00f5es Previdenci\u00e1rias"),
        IMPOSTO_DE_RENDA(204, "Imposto de Renda Retido na Fonte - IRRF"),
        IMPOSTO_DE_RENDA_FERIAS(205, "Imposto de Renda Retido na Fonte - IRRF s/ F\u00e9rias"),
        IMPOSTO_DE_RENDA_13(206, "Imposto de Renda Retido na Fonte - 13\u00ba Sal\u00e1rio"),
        IMPOSTO_DE_RENDA_14(207, "Imposto de Renda Retido na Fonte - 14\u00ba Sal\u00e1rio"),
        IMPOSTO_DE_RENDA_15(208, "Imposto de Renda Retido na Fonte - 15\u00ba Sal\u00e1rio"),
        PENSAO_ALIMENTICIA(209, "Pens\u00e3o Aliment\u00edcia"),
        REDUTOR_SALARIAL(210, "Redutor Salarial"),
        ADIANTAMENTO_SALARIAL(211, "Adiantamento Salarial"),
        FALTAS_E_ATRASOS(212, "Faltas e Atrasos"),
        OUTROS_DESCONTOS(213, "Outros Descontos");

        private final int codigo;
        private final String descricao;

        private TipoVerba(int codigo, String descricao) {
            this.codigo = codigo;
            this.descricao = descricao;
        }

        public int getCodigo() {
            return this.codigo;
        }

        public String getDescricao() {
            return this.descricao;
        }

        public static TipoVerba getBy(Integer codigo) {
            if (codigo != null) {
                for (TipoVerba tipoVerba : TipoVerba.values()) {
                    if (tipoVerba.getCodigo() != codigo.intValue()) continue;
                    return tipoVerba;
                }
            }
            return null;
        }
    }
}

