/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.vo.audesp;

import br.com.fiorilli.sip.commons.util.SIPUtil;
import br.com.fiorilli.sip.persistence.entity.CargoNatureza;
import br.com.fiorilli.sip.persistence.entity.ClassificacaoCargoAgentePolitico;
import br.com.fiorilli.sip.persistence.entity.EntidadeAudesp;
import br.com.fiorilli.sip.persistence.entity.RegimeJuridico;
import br.com.fiorilli.sip.persistence.entity.TrabalhadorTipoCargo;
import br.com.fiorilli.sip.persistence.vo.audesp.FolhaDetalhesAudespVO;
import br.com.fiorilli.sip.persistence.vo.audesp.IdentificacaoTrabalhadorAudespVO;
import br.gov.sp.tce.persistence.entity.FuncaoGoverno;
import br.gov.sp.tce.persistence.entity.SituacaoLotacaoAudesp;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class FolhaAudespVO {
    private final String entidade;
    private final String registro;
    private final IdentificacaoTrabalhadorAudespVO identificacaoTrabalhador;
    private final Double valorBruto;
    private final Double valorLiquido;
    private final Double valorDescontado;
    private final String unidade;
    private final Date dataNascimento;
    private final String parentesco;
    private final String banco;
    private final String agencia;
    private final String contaCorrente;
    private final List<FolhaDetalhesAudespVO> detalhes = new LinkedList<FolhaDetalhesAudespVO>();
    private final boolean pagamentoNaContaCorrente;

    public FolhaAudespVO(Integer codigoEntidadeAudesp, String codigoMunicipioAudesp, String entidade, String registro, String cpf, String nome, String cargo, String cbo, String tipoCargoAtual, ClassificacaoCargoAgentePolitico classificacao, FuncaoGoverno funcaoGoverno, String unidade, CargoNatureza natureza, RegimeJuridico regimeJuridico, Date dataNascimento, String parentesco, Boolean pensionista, Boolean aposentado, String banco, String agencia, String agenciaDigito, String contaCorrente, String contaCorrenteDigito, Double valorBruto, Double valorLiquido, Double valorDescontado) {
        this.entidade = entidade;
        this.registro = registro;
        this.identificacaoTrabalhador = new IdentificacaoTrabalhadorAudespVO(cpf, nome, new EntidadeAudesp(codigoEntidadeAudesp, codigoMunicipioAudesp), cargo, cbo, TrabalhadorTipoCargo.of(tipoCargoAtual), classificacao, funcaoGoverno, natureza, regimeJuridico, SituacaoLotacaoAudesp.ATIVO, aposentado, pensionista);
        this.banco = banco;
        String agenciaTmp = SIPUtil.removeZerosAtLeftIn((String)agencia);
        if (!StringUtils.isEmpty((CharSequence)agenciaDigito) && !StringUtils.isBlank((CharSequence)agenciaDigito)) {
            agenciaTmp = agenciaTmp + agenciaDigito;
        }
        this.agencia = agenciaTmp;
        String contaCorrenteTmp = SIPUtil.removeZerosAtLeftIn((String)contaCorrente);
        if (!StringUtils.isEmpty((CharSequence)contaCorrenteDigito) && !StringUtils.isBlank((CharSequence)contaCorrenteDigito)) {
            contaCorrenteTmp = contaCorrenteTmp + contaCorrenteDigito;
        }
        this.contaCorrente = contaCorrenteTmp;
        this.valorBruto = valorBruto;
        this.valorLiquido = valorBruto - valorDescontado;
        this.valorDescontado = valorDescontado;
        this.dataNascimento = dataNascimento;
        this.parentesco = parentesco;
        this.unidade = unidade;
        this.pagamentoNaContaCorrente = StringUtils.isNotBlank((CharSequence)banco) && StringUtils.isNotBlank((CharSequence)agencia) && StringUtils.isNotBlank((CharSequence)contaCorrente);
    }

    private FolhaAudespVO(EntidadeAudesp entidadeAudesp, String entidade, String registro, String cpf, String nome, String cargo, String cbo, Double valorBruto, Double valorLiquido, Double valorDescontado, TrabalhadorTipoCargo tipoCargo, ClassificacaoCargoAgentePolitico classificacao, String unidade, FuncaoGoverno funcaoGoverno, CargoNatureza natureza, RegimeJuridico regimeJuridico, Date dataNascimento, String parentesco, Boolean pensionista, Boolean aposentado, String banco, String agencia, String contaCorrente, SituacaoLotacaoAudesp lotacaoAudesp, boolean pagamentoNaContaCorrente) {
        this.entidade = entidade;
        this.registro = registro;
        this.identificacaoTrabalhador = new IdentificacaoTrabalhadorAudespVO(cpf, nome, entidadeAudesp, cargo, cbo, tipoCargo, classificacao, funcaoGoverno, natureza, regimeJuridico, lotacaoAudesp, aposentado, pensionista);
        this.valorBruto = valorBruto;
        this.valorLiquido = valorLiquido;
        this.valorDescontado = valorDescontado;
        this.unidade = unidade;
        this.dataNascimento = dataNascimento;
        this.parentesco = parentesco;
        this.banco = banco;
        this.agencia = agencia;
        this.contaCorrente = contaCorrente;
        this.pagamentoNaContaCorrente = pagamentoNaContaCorrente;
    }

    public Date getDataNascimento() {
        return this.dataNascimento;
    }

    public String getParentesco() {
        return this.parentesco;
    }

    public IdentificacaoTrabalhadorAudespVO getIdentificacaoTrabalhador() {
        return this.identificacaoTrabalhador;
    }

    public Double getValorBruto() {
        return this.valorBruto;
    }

    public Double getValorLiquido() {
        return this.valorLiquido;
    }

    public Double getValorDescontado() {
        return this.valorDescontado;
    }

    public List<FolhaDetalhesAudespVO> getDetalhes() {
        return this.detalhes;
    }

    public boolean isPagamentoNaContaCorrente() {
        return this.pagamentoNaContaCorrente;
    }

    public String getBanco() {
        return this.banco;
    }

    public String getAgencia() {
        return this.agencia;
    }

    public String getContaCorrente() {
        return this.contaCorrente;
    }

    public String getUnidade() {
        return this.unidade;
    }

    public String getEntidade() {
        return this.entidade;
    }

    public String getRegistro() {
        return this.registro;
    }

    public FolhaAudespVO plusValores(FolhaAudespVO vo) {
        Double valorBruto = this.valorBruto + vo.valorBruto;
        Double valorDescontado = this.valorDescontado + vo.valorDescontado;
        Double valorLiquido = this.valorLiquido + vo.valorLiquido;
        return new FolhaAudespVO(this.identificacaoTrabalhador.getEntidadeAudesp(), this.entidade, this.registro, this.identificacaoTrabalhador.getCpf(), this.identificacaoTrabalhador.getNome(), this.identificacaoTrabalhador.getCargo(), this.identificacaoTrabalhador.getCbo(), valorBruto, valorLiquido, valorDescontado, this.identificacaoTrabalhador.getTipoCargo(), this.identificacaoTrabalhador.getClassificacao(), this.unidade, this.identificacaoTrabalhador.getFuncaoGoverno(), this.identificacaoTrabalhador.getNatureza(), this.identificacaoTrabalhador.getRegimeJuridico(), this.dataNascimento, this.parentesco, this.identificacaoTrabalhador.isPensionista(), this.identificacaoTrabalhador.isAposentado(), this.banco, this.agencia, this.contaCorrente, this.identificacaoTrabalhador.getSituacaoLotacao(), this.pagamentoNaContaCorrente);
    }
}

