/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.vo.audesp;

import br.com.fiorilli.sip.commons.util.SIPUtil;
import br.com.fiorilli.sip.persistence.entity.Concurso;
import br.com.fiorilli.sip.persistence.entity.ConcursoCargo;
import br.com.fiorilli.sip.persistence.vo.audesp.CargoConcursoAudespVO;
import br.gov.sp.tce.persistence.entity.TipoProcessoSelecaoAudesp;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class ConvocacaoConcursoAudespVO {
    private final TipoProcessoSelecaoAudesp tipoProcessoSelecaoAudesp;
    private final String numeroConcurso;
    private final Integer anoConcurso;
    private final List<CargoConcursoAudespVO> cargosConcurso = new ArrayList<CargoConcursoAudespVO>();

    public ConvocacaoConcursoAudespVO(Concurso concurso) {
        if (concurso != null) {
            this.numeroConcurso = SIPUtil.getNumDocSemAno((String)concurso.getNumeroConcurso());
            this.anoConcurso = SIPUtil.getAnoFromNumDoc((String)concurso.getNumeroConcurso());
            this.tipoProcessoSelecaoAudesp = TipoProcessoSelecaoAudesp.fromModalidade(concurso.getModalidade());
            for (ConcursoCargo cargo : concurso.getCargos()) {
                this.cargosConcurso.add(new CargoConcursoAudespVO(cargo, this.tipoProcessoSelecaoAudesp));
            }
        } else {
            this.numeroConcurso = null;
            this.anoConcurso = null;
            this.tipoProcessoSelecaoAudesp = null;
        }
    }

    public TipoProcessoSelecaoAudesp getTipoProcessoSelecao() {
        return this.tipoProcessoSelecaoAudesp;
    }

    public String getNumeroConcurso() {
        return this.numeroConcurso;
    }

    public Integer getAnoConcurso() {
        return this.anoConcurso;
    }

    public List<CargoConcursoAudespVO> getCargosConcurso() {
        return this.cargosConcurso;
    }

    public boolean equals(Object o) {
        if (!(o instanceof ConvocacaoConcursoAudespVO)) {
            return false;
        }
        ConvocacaoConcursoAudespVO that = (ConvocacaoConcursoAudespVO)o;
        return this.tipoProcessoSelecaoAudesp == that.tipoProcessoSelecaoAudesp && Objects.equals(this.numeroConcurso, that.numeroConcurso) && Objects.equals(this.anoConcurso, that.anoConcurso);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.tipoProcessoSelecaoAudesp, this.numeroConcurso, this.anoConcurso});
    }
}

