/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.vo.audesp;

import br.com.fiorilli.sip.commons.util.SIPUtil;
import br.com.fiorilli.sip.persistence.entity.DocumentoDigital;
import br.com.fiorilli.sip.persistence.entity.Trabalhador;
import br.com.fiorilli.sip.persistence.entity.TrabalhadorDocumentoApresentado;
import java.util.Date;

public class ContratacaoTemporarioAudespVO {
    final String cpf;
    final String nome;
    final String pisPasep;
    final Date dataInicio;
    final Date dataTermino;
    final String houveEntregaDeclaracaoBens;
    final String cpfReponsavelContratacao;
    final String codigoFuncao;
    final String concursoNumero;
    final Integer concursoAno;
    final Short tipoProcessoSeletivo;
    final Integer prazoMaximoContratacao;
    final String fundamentoLegal;
    final String codigoFuncaoConcurso;

    public ContratacaoTemporarioAudespVO(Trabalhador trabalhador, DocumentoDigital documentoDigital) {
        this.cpf = trabalhador.getDocumentosPessoais().getCpf();
        this.nome = trabalhador.getNome();
        this.pisPasep = trabalhador.getDocumentosPessoais().getPis();
        this.dataInicio = trabalhador.getDataAdmissao();
        this.dataTermino = trabalhador.getDataTermino();
        this.houveEntregaDeclaracaoBens = trabalhador.getDocumentoApresentados() != null && trabalhador.getDocumentoApresentados().contains((Object)TrabalhadorDocumentoApresentado.DECLARACAO_BENS) ? "S" : "N";
        this.codigoFuncao = SIPUtil.coalesce((String[])new String[]{trabalhador.getCargoAtual().getCargoAudesp(), trabalhador.getCargoAtual().getCargoPK().getCodigo()});
        if (trabalhador.getConcurso() != null) {
            this.concursoNumero = SIPUtil.getNumDocSemAno((String)trabalhador.getConcurso().getNumeroConcurso());
            this.concursoAno = SIPUtil.getAnoFromNumDoc((String)trabalhador.getConcurso().getNumeroConcurso());
            switch (trabalhador.getConcurso().getModalidade()) {
                case PROCESSO_SELETIVO_PUBLICO_PELA_UG: 
                case PROCESSO_SELETIVO_PUBLICO_POR_OUTRA_UG: {
                    this.tipoProcessoSeletivo = 2;
                    break;
                }
                case PROCESSO_SELETIVO_SIMPLIFICADO_PELA_UG: 
                case PROCESSO_SELETIVO_SIMPLIFICADO_POR_OUTRA_UG: {
                    this.tipoProcessoSeletivo = 3;
                    break;
                }
                default: {
                    this.tipoProcessoSeletivo = 1;
                    break;
                }
            }
        } else {
            this.concursoNumero = null;
            this.concursoAno = null;
            this.tipoProcessoSeletivo = null;
        }
        this.codigoFuncaoConcurso = trabalhador.getCargoConcurso() != null ? SIPUtil.coalesce((String[])new String[]{trabalhador.getCargoConcurso().getCargo().getCargoAudesp(), trabalhador.getCargoConcurso().getCargoCodigo()}) : SIPUtil.coalesce((String[])new String[]{trabalhador.getCargoAtual().getCargoAudesp(), trabalhador.getCargoAtual().getCargoPK().getCodigo()});
        this.prazoMaximoContratacao = trabalhador.getPrazoMaximoContratacaoTemporario();
        if (documentoDigital != null) {
            this.fundamentoLegal = String.format("%s %s", documentoDigital.getTipoLegal() != null ? documentoDigital.getTipoLegal().getNome() : "", documentoDigital.getNumeroDocumento());
            this.cpfReponsavelContratacao = documentoDigital.getResponsavel() != null ? documentoDigital.getResponsavel().getCpf() : null;
        } else {
            this.fundamentoLegal = null;
            this.cpfReponsavelContratacao = null;
        }
    }

    public String getCpf() {
        return this.cpf;
    }

    public String getNome() {
        return this.nome;
    }

    public String getPisPasep() {
        return this.pisPasep;
    }

    public Date getDataInicio() {
        return this.dataInicio;
    }

    public Date getDataTermino() {
        return this.dataTermino;
    }

    public String getHouveEntregaDeclaracaoBens() {
        return this.houveEntregaDeclaracaoBens;
    }

    public String getCpfReponsavelContratacao() {
        return this.cpfReponsavelContratacao;
    }

    public String getCodigoFuncao() {
        return this.codigoFuncao;
    }

    public String getConcursoNumero() {
        return this.concursoNumero;
    }

    public Integer getConcursoAno() {
        return this.concursoAno;
    }

    public Short getTipoProcessoSeletivo() {
        return this.tipoProcessoSeletivo;
    }

    public Integer getPrazoMaximoContratacao() {
        return this.prazoMaximoContratacao;
    }

    public String getFundamentoLegal() {
        return this.fundamentoLegal;
    }

    public String getCodigoFuncaoConcurso() {
        return this.codigoFuncaoConcurso;
    }
}

