/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.vo.audesp;

import br.com.fiorilli.sip.commons.util.SIPUtil;
import br.com.fiorilli.sip.persistence.entity.Concurso;
import br.com.fiorilli.sip.persistence.entity.ConcursoCargo;
import br.com.fiorilli.sip.persistence.entity.ConcursoEdital;
import br.com.fiorilli.sip.persistence.entity.ConcursoEditalTipo;
import br.com.fiorilli.sip.persistence.vo.audesp.CargoConcursoAudespVO;
import br.com.fiorilli.sip.persistence.vo.audesp.EditalConcursoAudespVO;
import br.gov.sp.tce.persistence.entity.TipoProcessoSelecaoAudesp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Objects;

public class ConcursoPublicoAudespVO {
    private final TipoProcessoSelecaoAudesp tipoProcessoSelecao;
    private final String numero;
    private final Integer ano;
    private final Double percentualVagaAfrodescendente;
    private final Double percentualVagaDeficiente;
    private final Short fatorArredondamentoVagas;
    private final Date validadeInicial;
    private final Date validadeFinal;
    private final Boolean validadePorrogavel;
    private final Date previsaoProrrogacao;
    private final Date validadeProrrogada;
    private final Date publicacaoProrrogacao;
    private final List<EditalConcursoAudespVO> editais;
    private final List<CargoConcursoAudespVO> cargos = new ArrayList<CargoConcursoAudespVO>();
    private final boolean relacionarAtividadeCargo;

    public ConcursoPublicoAudespVO(Concurso concurso) {
        this.tipoProcessoSelecao = TipoProcessoSelecaoAudesp.fromModalidade(concurso.getModalidade());
        this.numero = SIPUtil.getNumDocSemAno((String)concurso.getNumeroConcurso());
        this.ano = SIPUtil.getAnoFromNumDoc((String)concurso.getNumeroConcurso());
        this.percentualVagaAfrodescendente = concurso.getPercentualVagaAfrodescendente();
        this.percentualVagaDeficiente = concurso.getPercentualVagaDeficiente();
        this.fatorArredondamentoVagas = concurso.getFatorArredondamentoVagas();
        this.validadeInicial = concurso.getPrazoInicial();
        this.validadeFinal = concurso.getPrazoFinal();
        this.validadePorrogavel = concurso.getPrazoPorrogavel();
        this.previsaoProrrogacao = concurso.getPrevisaoProrrogacao();
        this.validadeProrrogada = concurso.getPrazoProrrogado();
        this.publicacaoProrrogacao = concurso.getDocumentoProrrogacao() != null ? concurso.getDocumentoProrrogacao().getData() : null;
        this.editais = this.loadEditais(concurso.getEditais(), ConcursoEditalTipo.ABERTURA, ConcursoEditalTipo.HOMOLOGACAO, ConcursoEditalTipo.RESULTADO_FINAL);
        if (concurso.getCargos() != null && !concurso.getCargos().isEmpty()) {
            for (ConcursoCargo cargo : concurso.getCargos()) {
                this.cargos.add(new CargoConcursoAudespVO(cargo, this.tipoProcessoSelecao));
            }
        }
        this.relacionarAtividadeCargo = concurso.getEntidade().getOpcoesGerais().getRelacionarAtividadesComCargo();
    }

    public TipoProcessoSelecaoAudesp getTipoProcessoSelecao() {
        return this.tipoProcessoSelecao;
    }

    public String getNumero() {
        return this.numero;
    }

    public Integer getAno() {
        return this.ano;
    }

    public Double getPercentualVagaAfrodescendente() {
        return this.percentualVagaAfrodescendente;
    }

    public Double getPercentualVagaDeficiente() {
        return this.percentualVagaDeficiente;
    }

    public Short getFatorArredondamentoVagas() {
        return this.fatorArredondamentoVagas;
    }

    public Date getValidadeInicial() {
        return this.validadeInicial;
    }

    public Date getValidadeFinal() {
        return this.validadeFinal;
    }

    public Boolean getValidadePorrogavel() {
        return this.validadePorrogavel;
    }

    public Date getPrevisaoProrrogacao() {
        return this.previsaoProrrogacao;
    }

    public Date getValidadeProrrogada() {
        return this.validadeProrrogada;
    }

    public Date getPublicacaoProrrogacao() {
        return this.publicacaoProrrogacao;
    }

    public List<EditalConcursoAudespVO> getEditais() {
        return this.editais;
    }

    public List<CargoConcursoAudespVO> getCargos() {
        return this.cargos;
    }

    public boolean isRelacionarAtividadeCargo() {
        return this.relacionarAtividadeCargo;
    }

    private List<EditalConcursoAudespVO> loadEditais(List<ConcursoEdital> editais, ConcursoEditalTipo ... tipos) {
        ArrayList<EditalConcursoAudespVO> listEditais = new ArrayList<EditalConcursoAudespVO>();
        List<ConcursoEditalTipo> tiposList = Arrays.asList(tipos);
        for (ConcursoEdital edital : editais) {
            if (!tiposList.contains((Object)edital.getTipoEdital())) continue;
            listEditais.add(this.castToEditalVO(edital));
        }
        return listEditais;
    }

    private EditalConcursoAudespVO castToEditalVO(ConcursoEdital edital) {
        if (edital != null) {
            String cpfResponsavel = edital.getDocumentoDigital() != null ? (edital.getDocumentoDigital().getResponsavel() != null ? edital.getDocumentoDigital().getResponsavel().getCpf() : null) : null;
            Integer idPdf = edital.getDocumentoDigital() != null && edital.getDocumentoDigital().getDocumentoDigitalPdf() != null ? edital.getDocumentoDigital().getDocumentoDigitalPdf().getId() : null;
            return new EditalConcursoAudespVO(edital.getNumeroEdital(), edital.getDataPublicacaoEdital(), edital.getTipoEdital(), edital.getDataEdital(), edital.getVeiculoPublicacao(), edital.getLocalPublicacao(), cpfResponsavel, idPdf);
        }
        return null;
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConcursoPublicoAudespVO that = (ConcursoPublicoAudespVO)o;
        return Objects.equals((Object)this.tipoProcessoSelecao, (Object)that.tipoProcessoSelecao) && Objects.equals(this.numero, that.numero) && Objects.equals(this.ano, that.ano);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.tipoProcessoSelecao, this.numero, this.ano});
    }
}

