/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.vo.audesp;

import br.com.fiorilli.sip.commons.util.SIPUtil;
import br.gov.sp.tce.persistence.entity.TipoAlteracaoVaga;
import java.math.BigDecimal;
import java.util.Date;

public class CargoHistoricoAudespVO {
    private final String cargoCodigo;
    private final String cargoNome;
    private final Date dataVigenciaAto;
    private final Integer tipoLegalCodigo;
    private final String numeroDocumento;
    private final Integer anoDocumento;
    private final String numDocSemAno;
    private final BigDecimal quantidade;
    private final TipoAlteracaoVaga tipoAlteracao;
    private final Date dataDocumento;

    public CargoHistoricoAudespVO(String cargoCodigo, String cargoNome, Integer tipoLegalCodigo, String numeroDocumento, Date dataDocumento, Double quantidade, Date dataVigenciaAto, String tipoAlteracaoCodigo) {
        this.cargoCodigo = cargoCodigo;
        this.cargoNome = cargoNome;
        this.dataVigenciaAto = dataVigenciaAto;
        this.tipoLegalCodigo = tipoLegalCodigo;
        this.numeroDocumento = numeroDocumento;
        this.anoDocumento = SIPUtil.getAnoFromNumDoc((String)numeroDocumento);
        this.numDocSemAno = SIPUtil.getNumDocSemAno((String)numeroDocumento);
        this.quantidade = BigDecimal.valueOf(quantidade);
        this.tipoAlteracao = TipoAlteracaoVaga.of(tipoAlteracaoCodigo);
        this.dataDocumento = dataDocumento;
    }

    public String getCargoCodigo() {
        return this.cargoCodigo;
    }

    public Date getDataVigenciaAto() {
        return this.dataVigenciaAto;
    }

    public Integer getTipoLegalCodigo() {
        return this.tipoLegalCodigo;
    }

    public Integer getAnoDocumento() {
        return this.anoDocumento;
    }

    public String getNumDocSemAno() {
        return this.numDocSemAno;
    }

    public BigDecimal getQuantidade() {
        return this.quantidade;
    }

    public TipoAlteracaoVaga getTipoAlteracao() {
        return this.tipoAlteracao;
    }

    public Date getDataDocumento() {
        return this.dataDocumento;
    }

    public String getNumeroDocumento() {
        return this.numeroDocumento;
    }

    public String getCargoNome() {
        return this.cargoNome;
    }
}

