/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.vo.audesp;

import br.com.fiorilli.sip.commons.util.SIPUtil;
import br.com.fiorilli.sip.persistence.entity.ConcursoCargo;
import br.com.fiorilli.sip.persistence.entity.ConcursoInscrito;
import br.com.fiorilli.sip.persistence.entity.ConcursoInscritoSituacao;
import br.com.fiorilli.sip.persistence.vo.audesp.ClassificadoConcursoAudespVO;
import br.com.fiorilli.sip.persistence.vo.audesp.ConvocadoConcursoAudespVO;
import br.gov.sp.tce.persistence.entity.TipoProcessoSelecaoAudesp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class CargoConcursoAudespVO {
    private final Integer id;
    private final String codigo;
    private Integer numeroVagas;
    private final Boolean atribuicaoPontoTitulo;
    private final List<ClassificadoConcursoAudespVO> classificados;
    private final List<ConvocadoConcursoAudespVO> convocados;
    private final boolean isFuncao;

    public CargoConcursoAudespVO(ConcursoCargo cargo, TipoProcessoSelecaoAudesp tipoProcessoSelecao) {
        this.id = cargo.getCodigo();
        this.codigo = SIPUtil.coalesce((String[])new String[]{cargo.getCargo().getCargoAudesp(), cargo.getCargoCodigo()});
        this.numeroVagas = cargo.getNumeroVagas() != null ? cargo.getNumeroVagas().intValue() : 0;
        this.atribuicaoPontoTitulo = cargo.getAtribuicaoPontoTitulo();
        this.classificados = new ArrayList<ClassificadoConcursoAudespVO>();
        this.convocados = new ArrayList<ConvocadoConcursoAudespVO>();
        for (ConcursoInscrito inscrito : cargo.getInscritos()) {
            if (Arrays.asList(ConcursoInscritoSituacao.APROVADO, ConcursoInscritoSituacao.CLASSIFICADO).contains((Object)inscrito.getSituacao()) || inscrito.getClassificacao() != null && inscrito.getClassificacao() > 0) {
                this.classificados.add(new ClassificadoConcursoAudespVO(inscrito.getCpf(), SIPUtil.getSemAcento((String)inscrito.getNome()), inscrito.getClassificacao() != null ? inscrito.getClassificacao().intValue() : 0, inscrito.getPortadorDeficiencia(), inscrito.getAfrodescendente()));
            }
            if (inscrito.getConcursoConvocado() == null) continue;
            this.convocados.add(new ConvocadoConcursoAudespVO(inscrito.getCpf(), inscrito.getClassificacao() != null ? inscrito.getClassificacao().intValue() : 0, inscrito.getConcursoConvocado().getSituacoes(), inscrito.getPortadorDeficiencia(), inscrito.getAfrodescendente()));
        }
        if (!this.classificados.isEmpty() && this.classificados.size() > 1) {
            Collections.sort(this.classificados, new ClassificadoConcursoAudespVO.ClassificadoConcursoAudespVOComparator());
        }
        if (!this.convocados.isEmpty() && this.convocados.size() > 1) {
            Collections.sort(this.convocados, new ConvocadoConcursoAudespVO.ConvocadoConcursoAudespVOComparator());
        }
        this.isFuncao = cargo.getCargo().isTemporario() || !tipoProcessoSelecao.isConcursoEfetivo();
    }

    public Integer getId() {
        return this.id;
    }

    public String getCodigo() {
        return this.codigo;
    }

    public Integer getNumeroVagas() {
        return this.numeroVagas;
    }

    public void setNumeroVagas(Integer numeroVagas) {
        this.numeroVagas = numeroVagas;
    }

    public Boolean getAtribuicaoPontoTitulo() {
        return this.atribuicaoPontoTitulo;
    }

    public List<ClassificadoConcursoAudespVO> getClassificados() {
        return this.classificados;
    }

    public List<ConvocadoConcursoAudespVO> getConvocados() {
        return this.convocados;
    }

    public boolean isFuncao() {
        return this.isFuncao;
    }
}

