/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.vo.audesp;

import br.com.fiorilli.sip.commons.util.SIPUtil;
import br.com.fiorilli.sip.persistence.entity.Pessoa;
import br.com.fiorilli.sip.persistence.vo.EmpregoAnteriorVO;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;

public class AposentadoAudespVO {
    private final String codigoCargo;
    private final String nomeCargo;
    private final Date dataLotacao;
    private final Date dataExercicio;
    private final String cpf;
    private final String pis;
    private final String nome;
    private final Date dataAposentadoria;
    private final Short tipoAposentadoria;
    private final Short tipoRegimePrevidencia;
    private final Short tipoProventos;
    private final Date dataAdmissaoServicoPublico;
    private final String cpfResponsavel;
    private final String nomeResponsavel;
    private final String fundamentoLegal;
    private List<EmpregoAnteriorVO> empregoAnteriorVOList = new ArrayList<EmpregoAnteriorVO>();
    private final Long contagemTempoAte16dez1998;
    private final Long contagemTempoAte31dez2003;
    private final Long contagemTempoServicoPublico;
    private final Long contagemTempoServicoPrivado;
    private final String codigoMunicipio;
    private final Integer codigoEntidade;

    public AposentadoAudespVO(String codigoCargo, String nomeCargo, Date dataLotacao, Date dataExercicio, String cpf, String pis, String nome, Date dataAposentadoria, Integer tipoAposentadoria, Integer tipoRegimePrevidencia, Integer tipoProventos, Date dataAdmissaoServicoPublico, String fundamentoLegal, Pessoa responsavel, String codigoMunicipio, Integer codigoEntidade, Long contagemTempoAte16dez1998, Long contagemTempoAte31dez2003, Long contagemTempoServicoPublico, Long contagemTempoServicoPrivado) {
        this.codigoCargo = codigoCargo;
        this.nomeCargo = nomeCargo;
        this.dataLotacao = dataLotacao;
        this.dataExercicio = dataExercicio;
        this.cpf = cpf;
        this.pis = pis;
        this.nome = SIPUtil.getSemAcento((String)nome);
        this.dataAposentadoria = dataAposentadoria;
        this.tipoAposentadoria = tipoAposentadoria != null ? tipoAposentadoria.shortValue() : (short)0;
        this.tipoRegimePrevidencia = tipoRegimePrevidencia != null ? tipoRegimePrevidencia.shortValue() : (short)0;
        this.tipoProventos = tipoProventos != null ? tipoProventos.shortValue() : (short)0;
        this.dataAdmissaoServicoPublico = dataAdmissaoServicoPublico;
        if (responsavel != null) {
            this.cpfResponsavel = responsavel.getCpf();
            this.nomeResponsavel = SIPUtil.getSemAcento((String)responsavel.getNome());
        } else {
            this.cpfResponsavel = "";
            this.nomeResponsavel = "";
        }
        this.fundamentoLegal = fundamentoLegal;
        this.contagemTempoAte16dez1998 = contagemTempoAte16dez1998;
        this.contagemTempoAte31dez2003 = contagemTempoAte31dez2003;
        this.contagemTempoServicoPublico = contagemTempoServicoPublico;
        this.contagemTempoServicoPrivado = contagemTempoServicoPrivado;
        this.codigoMunicipio = codigoMunicipio;
        this.codigoEntidade = codigoEntidade;
    }

    public String getCodigoCargo() {
        return this.codigoCargo;
    }

    public String getNomeCargo() {
        return this.nomeCargo;
    }

    public Date getDataLotacao() {
        return this.dataLotacao;
    }

    public Date getDataExercicio() {
        return this.dataExercicio;
    }

    public String getCpf() {
        return this.cpf;
    }

    public String getNome() {
        return this.nome;
    }

    public Date getDataAposentadoria() {
        return this.dataAposentadoria;
    }

    public String getPis() {
        return this.pis;
    }

    public Short getTipoAposentadoria() {
        return this.tipoAposentadoria;
    }

    public Short getTipoRegimePrevidencia() {
        return this.tipoRegimePrevidencia;
    }

    public Short getTipoProventos() {
        return this.tipoProventos;
    }

    public Date getDataAdmissaoServicoPublico() {
        return this.dataAdmissaoServicoPublico;
    }

    public String getCpfResponsavel() {
        return this.cpfResponsavel;
    }

    public String getNomeResponsavel() {
        return this.nomeResponsavel;
    }

    public String getFundamentoLegal() {
        return this.fundamentoLegal;
    }

    public Long getContagemTempoAte16dez1998() {
        return this.contagemTempoAte16dez1998;
    }

    public Long getContagemTempoAte31dez2003() {
        return this.contagemTempoAte31dez2003;
    }

    public Long getContagemTempoServicoPublico() {
        return this.contagemTempoServicoPublico;
    }

    public Long getContagemTempoServicoPrivado() {
        return this.contagemTempoServicoPrivado;
    }

    public String getCodigoMunicipio() {
        return this.codigoMunicipio;
    }

    public Integer getCodigoEntidade() {
        return this.codigoEntidade;
    }

    public List<EmpregoAnteriorVO> getEmpregoAnteriorVOList() {
        return this.empregoAnteriorVOList;
    }

    public void addAllEmpregoAnterior(List<EmpregoAnteriorVO> empregoAnteriorVOList) {
        this.empregoAnteriorVOList.addAll(empregoAnteriorVOList);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AposentadoAudespVO that = (AposentadoAudespVO)o;
        return Objects.equals(this.cpf, that.cpf);
    }

    public int hashCode() {
        return Objects.hash(this.cpf);
    }
}

