/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.vo.audesp;

import br.com.fiorilli.sip.commons.util.SIPUtil;
import br.com.fiorilli.sip.persistence.vo.audesp.PensionistaAudespVO;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;

public class AgentePublicoPensionistaAudespVO {
    private final String nome;
    private final String cpf;
    private final String pisPasep;
    private final String codigoCargo;
    private final String nomeCargo;
    private final Date dataLotacao;
    private final Date dataExercicio;
    private final String aposentado;
    private final Date dataObito;
    private final Date dataConcessaoPensao;
    private final String fundamentoLegal;
    private final String cpfResponsavelAto;
    private final String nomeResponsavelAto;
    private final String codigoMunicipio;
    private final Integer codigoEntidade;
    private List<PensionistaAudespVO> pensionistas = new ArrayList<PensionistaAudespVO>();

    public AgentePublicoPensionistaAudespVO(String nome, String cpf, String pisPasep, String codigoCargo, String nomeCargo, Date dataLotacao, Date dataExercicio, String aposentado, Date dataObito, Date dataConcessaoPensao, String fundamentoLegal, String cpfResponsavelAto, String nomeResponsavelAto, String codigoMunicipio, Integer codigoEntidade) {
        this.nome = SIPUtil.getSemAcento((String)nome);
        this.cpf = cpf;
        this.pisPasep = pisPasep;
        this.codigoCargo = codigoCargo;
        this.nomeCargo = nomeCargo;
        this.dataLotacao = dataLotacao;
        this.dataExercicio = dataExercicio;
        this.aposentado = aposentado;
        this.dataObito = dataObito;
        this.dataConcessaoPensao = dataConcessaoPensao;
        this.fundamentoLegal = fundamentoLegal;
        this.cpfResponsavelAto = cpfResponsavelAto;
        this.nomeResponsavelAto = SIPUtil.getSemAcento((String)nomeResponsavelAto);
        this.codigoMunicipio = codigoMunicipio;
        this.codigoEntidade = codigoEntidade;
    }

    public String getNome() {
        return this.nome;
    }

    public String getCpf() {
        return this.cpf;
    }

    public String getPisPasep() {
        return this.pisPasep;
    }

    public String getCodigoCargo() {
        return this.codigoCargo;
    }

    public String getNomeCargo() {
        return this.nomeCargo;
    }

    public Date getDataLotacao() {
        return this.dataLotacao;
    }

    public Date getDataExercicio() {
        return this.dataExercicio;
    }

    public String getAposentado() {
        return this.aposentado;
    }

    public Date getDataObito() {
        return this.dataObito;
    }

    public Date getDataConcessaoPensao() {
        return this.dataConcessaoPensao;
    }

    public String getFundamentoLegal() {
        return this.fundamentoLegal;
    }

    public String getCpfResponsavelAto() {
        return this.cpfResponsavelAto;
    }

    public String getNomeResponsavelAto() {
        return this.nomeResponsavelAto;
    }

    public String getCodigoMunicipio() {
        return this.codigoMunicipio;
    }

    public Integer getCodigoEntidade() {
        return this.codigoEntidade;
    }

    public List<PensionistaAudespVO> getPensionistas() {
        return this.pensionistas;
    }

    public void addPensionista(PensionistaAudespVO pensionista) {
        if (pensionista != null && !this.pensionistas.contains(pensionista)) {
            this.pensionistas.add(pensionista);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AgentePublicoPensionistaAudespVO that = (AgentePublicoPensionistaAudespVO)o;
        return Objects.equals(this.cpf, that.cpf) && Objects.equals(this.dataConcessaoPensao, that.dataConcessaoPensao);
    }

    public int hashCode() {
        return Objects.hash(this.cpf, this.dataConcessaoPensao);
    }
}

