/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.vo.audesp;

import br.com.fiorilli.sip.commons.util.SIPUtil;
import br.com.fiorilli.sip.persistence.entity.Trabalhador;
import br.com.fiorilli.sip.persistence.entity.TrabalhadorDocumentoApresentado;
import java.util.Date;

public class AdmissaoEfetivoAudespVO {
    final String cpf;
    final String nome;
    final String pisPasep;
    final Date dataAdmissao;
    final String houveEntregaDeclaracaoBens;
    final String cpfReponsavelAdmissao;
    final String codigoCargo;
    final String concursoNumero;
    final Integer concursoAno;
    final String codigoCargoConcurso;

    public AdmissaoEfetivoAudespVO(Trabalhador trabalhador, String cpfReponsavelAdmissao) {
        this.cpf = trabalhador.getDocumentosPessoais().getCpf();
        this.nome = trabalhador.getNome();
        this.pisPasep = trabalhador.getDocumentosPessoais().getPis();
        this.dataAdmissao = trabalhador.getDataAdmissao();
        this.houveEntregaDeclaracaoBens = trabalhador.getDocumentoApresentados() != null && trabalhador.getDocumentoApresentados().contains((Object)TrabalhadorDocumentoApresentado.DECLARACAO_BENS) ? "S" : "N";
        this.cpfReponsavelAdmissao = cpfReponsavelAdmissao;
        this.codigoCargo = SIPUtil.coalesce((String[])new String[]{trabalhador.getCargoAtual().getCargoAudesp(), trabalhador.getCargoAtual().getCargoPK().getCodigo()});
        this.concursoNumero = trabalhador.getConcurso() != null ? SIPUtil.getNumDocSemAno((String)trabalhador.getConcurso().getNumeroConcurso()) : null;
        this.concursoAno = trabalhador.getConcurso() != null ? SIPUtil.getAnoFromNumDoc((String)trabalhador.getConcurso().getNumeroConcurso()) : null;
        this.codigoCargoConcurso = trabalhador.getCargoConcurso() != null ? SIPUtil.coalesce((String[])new String[]{trabalhador.getCargoConcurso().getCargo().getCargoAudesp(), trabalhador.getCargoConcurso().getCargoCodigo()}) : SIPUtil.coalesce((String[])new String[]{trabalhador.getCargoAtual().getCargoAudesp(), trabalhador.getCargoAtual().getCargoPK().getCodigo()});
    }

    public String getCpf() {
        return this.cpf;
    }

    public String getNome() {
        return this.nome;
    }

    public String getPisPasep() {
        return this.pisPasep;
    }

    public Date getDataAdmissao() {
        return this.dataAdmissao;
    }

    public String getHouveEntregaDeclaracaoBens() {
        return this.houveEntregaDeclaracaoBens;
    }

    public String getCpfReponsavelAdmissao() {
        return this.cpfReponsavelAdmissao;
    }

    public String getCodigoCargo() {
        return this.codigoCargo;
    }

    public String getConcursoNumero() {
        return this.concursoNumero;
    }

    public Integer getConcursoAno() {
        return this.concursoAno;
    }

    public String getCodigoCargoConcurso() {
        return this.codigoCargoConcurso;
    }
}

