/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.vo;

import br.com.fiorilli.sip.commons.util.SIPDateUtil;
import br.com.fiorilli.sip.persistence.entity.TipoPonto;
import br.com.fiorilli.sip.persistence.entity.TrabalhadorPK;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.DateTime;
import org.joda.time.LocalTime;
import org.joda.time.ReadableInstant;

public class TrabalhadorBatidaVo {
    private TrabalhadorPK pk;
    private String pis;
    private TipoPonto pontoTipo;
    private Short jornadaCodigo;
    private String cracha;
    private Date dataDemissao;
    private String periodoInicio;
    private String periodoFim;
    private Date dataAdmissao;
    private String cpf;

    public TrabalhadorBatidaVo() {
    }

    public TrabalhadorBatidaVo(TrabalhadorPK pk, String pis, Character pontoTipo, Short jornadaCodigo, String cracha, Date dataDemissao) {
        this.pk = pk;
        this.pis = pis;
        this.dataDemissao = dataDemissao;
        this.pontoTipo = TipoPonto.getEntity(pontoTipo);
        this.jornadaCodigo = jornadaCodigo;
        this.cracha = cracha;
    }

    public TrabalhadorBatidaVo(TrabalhadorPK pk, String pis, Character pontoTipo, Short jornadaCodigo, String cracha, Date dataDemissao, String periodoInicio, String periodoFim) {
        this.pk = pk;
        this.pis = pis;
        this.pontoTipo = TipoPonto.getEntity(pontoTipo);
        this.jornadaCodigo = jornadaCodigo;
        this.cracha = cracha;
        this.dataDemissao = dataDemissao;
        this.periodoInicio = StringUtils.isBlank((CharSequence)periodoInicio) || StringUtils.trim((String)periodoInicio).equals(":") ? "00:00" : periodoInicio;
        this.periodoFim = StringUtils.isBlank((CharSequence)periodoFim) || StringUtils.trim((String)periodoFim).equals(":") ? "23:59" : periodoFim;
    }

    public TrabalhadorBatidaVo(TrabalhadorPK pk, String pis, Character pontoTipo, Short jornadaCodigo, String cracha, Date dataDemissao, String periodoInicio, String periodoFim, Date dataAdmissao, String cpf) {
        this.pk = pk;
        this.pis = pis;
        this.pontoTipo = TipoPonto.getEntity(pontoTipo);
        this.jornadaCodigo = jornadaCodigo;
        this.cracha = cracha;
        this.dataDemissao = dataDemissao;
        this.periodoInicio = StringUtils.isBlank((CharSequence)periodoInicio) || StringUtils.trim((String)periodoInicio).equals(":") ? "00:00" : periodoInicio;
        this.periodoFim = StringUtils.isBlank((CharSequence)periodoFim) || StringUtils.trim((String)periodoFim).equals(":") ? "23:59" : periodoFim;
        this.dataAdmissao = dataAdmissao;
        this.cpf = cpf;
    }

    public String getPis() {
        return this.pis;
    }

    public TrabalhadorPK getPk() {
        return this.pk;
    }

    public boolean isAutorizadoUsarCartaoPonto() {
        return this.pontoTipo.isUtilizaCartao();
    }

    public Short getJornadaCodigo() {
        return this.jornadaCodigo;
    }

    public String getCracha() {
        return this.cracha;
    }

    public String getPeriodoInicio() {
        return this.periodoInicio;
    }

    public String getPeriodoFim() {
        return this.periodoFim;
    }

    public Date getDataDemissao() {
        return this.dataDemissao;
    }

    public Date getDataAdmissao() {
        return this.dataAdmissao;
    }

    public String getCpf() {
        return this.cpf;
    }

    public void setCpf(String cpf) {
        this.cpf = cpf;
    }

    public static TrabalhadorBatidaVo empty() {
        TrabalhadorBatidaVo trabalhadorBatidaVo = new TrabalhadorBatidaVo();
        trabalhadorBatidaVo.pk = new TrabalhadorPK();
        trabalhadorBatidaVo.pis = "";
        return trabalhadorBatidaVo;
    }

    public boolean isEmpty() {
        return "".equals(this.pis) && this.pk.getEntidade() == null;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.pk == null ? 0 : this.pk.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TrabalhadorBatidaVo other = (TrabalhadorBatidaVo)obj;
        return !(this.pk == null ? other.pk != null : !this.pk.equals(other.pk));
    }

    public boolean isBatidaOnPeriodoDeImportacao(Date dataHora) {
        if (dataHora != null) {
            try {
                DateTime batida = new DateTime((Object)dataHora);
                DateTime inicio = batida.withTime(new LocalTime((Object)this.periodoInicio));
                DateTime fim = batida.withTime(new LocalTime((Object)this.periodoFim));
                if (fim.isBefore((ReadableInstant)inicio)) {
                    return !((!batida.isAfter((ReadableInstant)inicio.minusDays(1)) && !batida.isEqual((ReadableInstant)inicio.minusDays(1)) || !batida.isBefore((ReadableInstant)fim) && !batida.isEqual((ReadableInstant)fim)) && (!batida.isAfter((ReadableInstant)inicio) && !batida.isEqual((ReadableInstant)inicio) || !batida.isBefore((ReadableInstant)fim.plusDays(1)) && !batida.isEqual((ReadableInstant)fim.plusDays(1))));
                }
                return !(!batida.isAfter((ReadableInstant)inicio) && !batida.isEqual((ReadableInstant)inicio) || !batida.isBefore((ReadableInstant)fim) && !batida.isEqual((ReadableInstant)fim));
            }
            catch (Exception e) {
                e.printStackTrace();
                return false;
            }
        }
        return false;
    }

    public boolean isBatidaOnPeriodoAtivo(Date dataHoraBatida) {
        Date dataBatida = SIPDateUtil.toDate((String)SIPDateUtil.toString((String)"dd/MM/yyy", (Date)dataHoraBatida));
        return dataBatida.compareTo(this.dataAdmissao) >= 0 && (this.dataDemissao == null || dataBatida.compareTo(this.dataDemissao) <= 0);
    }

    public String toString() {
        return "TrabalhadorBatidaVo(pk=" + this.getPk() + ", pis=" + this.getPis() + ", pontoTipo=" + (Object)((Object)this.pontoTipo) + ", jornadaCodigo=" + this.getJornadaCodigo() + ", cracha=" + this.getCracha() + ", dataDemissao=" + this.getDataDemissao() + ", periodoInicio=" + this.getPeriodoInicio() + ", periodoFim=" + this.getPeriodoFim() + ", dataAdmissao=" + this.getDataAdmissao() + ", cpf=" + this.getCpf() + ")";
    }
}

