/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.vo;

import br.com.fiorilli.sip.persistence.entity.Trabalhador;
import java.io.Serializable;

public class TrabalhadorAutocompleteVo
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String entidade;
    private final String registro;
    private final Integer matricula;
    private final Short contrato;
    private final String nome;

    public TrabalhadorAutocompleteVo(String entidade, String registro, Integer matricula, Short contrato, String nome) {
        this.entidade = entidade;
        this.registro = registro;
        this.matricula = matricula;
        this.contrato = contrato;
        this.nome = nome;
    }

    public TrabalhadorAutocompleteVo(Trabalhador trabalhador) {
        this.entidade = trabalhador.getTrabalhadorPK().getEntidade();
        this.registro = trabalhador.getTrabalhadorPK().getRegistro();
        this.matricula = trabalhador.getMatricula();
        this.contrato = trabalhador.getContrato();
        this.nome = trabalhador.getNome();
    }

    public String getMatriculaContrato() {
        return this.matricula + "-" + this.contrato;
    }

    public String getEntidade() {
        return this.entidade;
    }

    public String getRegistro() {
        return this.registro;
    }

    public Integer getMatricula() {
        return this.matricula;
    }

    public Short getContrato() {
        return this.contrato;
    }

    public String getNome() {
        return this.nome;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.entidade == null ? 0 : this.entidade.hashCode());
        result = 31 * result + (this.registro == null ? 0 : this.registro.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TrabalhadorAutocompleteVo other = (TrabalhadorAutocompleteVo)obj;
        if (this.entidade == null ? other.entidade != null : !this.entidade.equals(other.entidade)) {
            return false;
        }
        return !(this.registro == null ? other.registro != null : !this.registro.equals(other.registro));
    }

    public String toString() {
        return "TrabalhadorAutocompleteVo [entidade=" + this.entidade + ", registro=" + this.registro + "]";
    }
}

