/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.vo;

import br.com.fiorilli.sip.commons.util.SIPDateUtil;
import br.com.fiorilli.sip.persistence.entity.MesNomeEnum;
import br.com.fiorilli.sip.persistence.entity.Usuario;
import br.com.fiorilli.sip.persistence.vo.EntidadeMinVo;
import java.util.Date;

public class TceMgParameters {
    private final MesNomeEnum[] meses = MesNomeEnum.values();
    private EntidadeMinVo entidade;
    private final Usuario connectedUser;
    private MesNomeEnum mes;
    private String ano;
    private boolean cargaInicial;
    private String consideracoes;
    private boolean enviarConsideracoes;
    private TipoArquivo tipoArquivoConsideracoes;

    public TceMgParameters(EntidadeMinVo entidadeMinVo, Usuario connectedUser) {
        this.entidade = entidadeMinVo;
        this.connectedUser = connectedUser;
    }

    public final MesNomeEnum getMes() {
        return this.mes;
    }

    public final void setMes(MesNomeEnum mes) {
        this.mes = mes;
    }

    public final String getAno() {
        return this.ano;
    }

    public final int getAnoInt() {
        return Integer.parseInt(this.ano);
    }

    public final void setAno(String ano) {
        this.ano = ano;
    }

    public final MesNomeEnum[] getMeses() {
        return this.meses;
    }

    public EntidadeMinVo getEntidade() {
        return this.entidade;
    }

    public void setEntidade(EntidadeMinVo entidade) {
        this.entidade = entidade;
    }

    public final Usuario getConnectedUser() {
        return this.connectedUser;
    }

    public boolean isCargaInicial() {
        return this.cargaInicial;
    }

    public void setCargaInicial(boolean cargaInicial) {
        this.cargaInicial = cargaInicial;
    }

    public Date getDataInicioReferencia() {
        return SIPDateUtil.getFirstDateOfMonth((String)this.ano, (String)this.mes.getCodigo());
    }

    public Date getDataFimReferenciaAnterior() {
        if (this.mes.getCodigoInt() == 1) {
            return SIPDateUtil.getLastDateOfMonth((Integer)(Integer.parseInt(this.ano) - 1), (Integer)12);
        }
        return SIPDateUtil.getLastDateOfMonth((Integer)Integer.parseInt(this.ano), (Integer)(this.mes.getCodigoInt() - 1));
    }

    public Date getDataFimReferencia() {
        return SIPDateUtil.getLastDateOfMonth((String)this.ano, (String)this.mes.getCodigo());
    }

    public boolean isCargaInicial2018() {
        return this.ano.equals("2018") && this.mes == MesNomeEnum.JANEIRO;
    }

    public boolean isCargaInicial2019() {
        return this.ano.equals("2019") && this.mes == MesNomeEnum.JANEIRO;
    }

    public String getConsideracoes() {
        return this.consideracoes;
    }

    public void setConsideracoes(String consideracoes) {
        this.consideracoes = consideracoes;
    }

    public boolean isEnviarConsideracoes() {
        return this.enviarConsideracoes;
    }

    public void setEnviarConsideracoes(boolean enviarConsideracoes) {
        this.enviarConsideracoes = enviarConsideracoes;
    }

    public TipoArquivo getTipoArquivoConsideracoes() {
        return this.tipoArquivoConsideracoes;
    }

    public void setTipoArquivoConsideracoes(TipoArquivo tipoArquivoConsideracoes) {
        this.tipoArquivoConsideracoes = tipoArquivoConsideracoes;
    }

    public static enum TipoArquivo {
        IDE,
        PESSOA,
        VIAP,
        AFAST,
        TEREM,
        FLPGO,
        RESPINF,
        CONSID;

    }
}

