/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.vo;

import br.com.fiorilli.sip.commons.util.SIPDateUtil;
import java.util.Date;
import java.util.Objects;

public class RelacaoVigenciasVo {
    public static final String QUERY_BY_EMPRESA = "SELECT NEW br.com.fiorilli.sip.persistence.vo.RelacaoVigenciasVo(b.codigo, b.dataVigenciaInicio, b.dataVigenciaTermino) FROM BancoHorasParametros b WHERE b.entidadeCodigo = :entidadeCodigo ORDER BY b.dataVigenciaInicio DESC ";
    private final Integer codigo;
    private final Date dataVigenciaInicio;
    private final Date dataVigenciaTermino;
    private final String periodoString;

    public RelacaoVigenciasVo(Integer codigo, Date dataVigenciaInicio, Date dataVigenciaTermino) {
        this.codigo = codigo;
        this.dataVigenciaInicio = dataVigenciaInicio;
        this.dataVigenciaTermino = dataVigenciaTermino;
        this.periodoString = SIPDateUtil.toString((Date)dataVigenciaInicio) + " - " + SIPDateUtil.toString((Date)(dataVigenciaTermino != null ? dataVigenciaTermino : new Date()));
    }

    public Date getDataVigenciaInicio() {
        return this.dataVigenciaInicio;
    }

    public Date getDataVigenciaTermino() {
        return this.dataVigenciaTermino;
    }

    public Integer getCodigo() {
        return this.codigo;
    }

    public String getPeriodoString() {
        return this.periodoString;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RelacaoVigenciasVo that = (RelacaoVigenciasVo)o;
        return Objects.equals(this.codigo, that.codigo);
    }

    public int hashCode() {
        return Objects.hash(this.codigo);
    }
}

