/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.vo;

import br.com.fiorilli.filter.annotations.FilterConfigParameter;
import br.com.fiorilli.filter.annotations.FilterConfigParameters;
import br.com.fiorilli.filter.annotations.FilterConfigType;
import br.com.fiorilli.filter.model.FilterCondition;
import br.com.fiorilli.filter.model.FilterInputType;
import java.util.Date;

@FilterConfigType(query="select $R{[r.codigo], [new br.com.fiorilli.sip.persistence.vo.RegistroControleEpiFilterVo(r.codigo, t.matricula, t.contrato, t.nome, e.nome, r.dtentrega, r.dtdevolucao)]} from RegistroControleEpi r left join r.trabalhador t left join r.epi e WHERE $P{[registro],[t.trabalhadorPK.registro],[:registro]} AND $P{[matricula],[t.matricula],[:matricula]} AND $P{[contrato],[t.contrato],[:contrato]} AND $P{[nome],[t.nome],[:nome]} AND $P{[nomeEpi],[e.nome],[:nomeEpi]} AND $P{[dataEntrega],[r.dtentrega],[:dataEntrega]} AND $P{[dataDevolucao],[r.dtdevolucao],[:dataDevolucao]} ", autoFilter=true, rootEntityAlias="r")
@FilterConfigParameters(value={@FilterConfigParameter(fieldClass=String.class, id="registro", label="Registro", inputType=FilterInputType.NUMBER, order=1), @FilterConfigParameter(fieldClass=Integer.class, id="matricula", label="Matr\u00edcula", inputType=FilterInputType.NUMBER, order=2), @FilterConfigParameter(fieldClass=Short.class, id="contrato", label="Contrato", inputType=FilterInputType.NUMBER, order=3), @FilterConfigParameter(fieldClass=String.class, id="nome", label="Nome", inputType=FilterInputType.TEXT, condition=FilterCondition.COMECE, order=4), @FilterConfigParameter(fieldClass=String.class, id="nomeEpi", label="Nome EPI", inputType=FilterInputType.TEXT, condition=FilterCondition.CONTENHA, order=5), @FilterConfigParameter(fieldClass=Date.class, id="dataEntrega", label="Data Entrega", inputType=FilterInputType.CALENDAR, condition=FilterCondition.IGUAL, order=6), @FilterConfigParameter(fieldClass=Date.class, id="dataDevolucao", label="Data Devolucao", inputType=FilterInputType.CALENDAR, condition=FilterCondition.IGUAL, order=7)})
public class RegistroControleEpiFilterVo {
    public static final String QUERY = "select $R{[r.codigo], [new br.com.fiorilli.sip.persistence.vo.RegistroControleEpiFilterVo(r.codigo, t.matricula, t.contrato, t.nome, e.nome, r.dtentrega, r.dtdevolucao)]} from RegistroControleEpi r left join r.trabalhador t left join r.epi e WHERE $P{[registro],[t.trabalhadorPK.registro],[:registro]} AND $P{[matricula],[t.matricula],[:matricula]} AND $P{[contrato],[t.contrato],[:contrato]} AND $P{[nome],[t.nome],[:nome]} AND $P{[nomeEpi],[e.nome],[:nomeEpi]} AND $P{[dataEntrega],[r.dtentrega],[:dataEntrega]} AND $P{[dataDevolucao],[r.dtdevolucao],[:dataDevolucao]} ";
    private final Integer codigo;
    private final Integer matricula;
    private final Short contrato;
    private final String nome;
    private final String nomeEpi;
    private final Date dtEntrega;
    private final Date dtDevolucao;

    public RegistroControleEpiFilterVo(Integer codigo, Integer matricula, Short contrato, String nome, String nomeEpi, Date dtEntrega, Date dtDevolucao) {
        this.codigo = codigo;
        this.matricula = matricula;
        this.contrato = contrato;
        this.nome = nome;
        this.nomeEpi = nomeEpi;
        this.dtEntrega = dtEntrega;
        this.dtDevolucao = dtDevolucao;
    }

    public Integer getCodigo() {
        return this.codigo;
    }

    public Integer getMatricula() {
        return this.matricula;
    }

    public Short getContrato() {
        return this.contrato;
    }

    public String getNome() {
        return this.nome;
    }

    public String getNomeEpi() {
        return this.nomeEpi;
    }

    public Date getDtEntrega() {
        return this.dtEntrega;
    }

    public Date getDtDevolucao() {
        return this.dtDevolucao;
    }

    public String getMatriculaContrato() {
        return this.matricula + "-" + this.contrato;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.codigo == null ? 0 : this.codigo.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RegistroControleEpiFilterVo other = (RegistroControleEpiFilterVo)obj;
        return !(this.codigo == null ? other.codigo != null : !this.codigo.equals(other.codigo));
    }

    public String toString() {
        return "RegistroControleEpiFilterVo [codigo=" + this.codigo + "]";
    }
}

