/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.vo;

import br.com.fiorilli.sip.persistence.entity.MesNomeEnum;
import br.com.fiorilli.sip.persistence.entity.Referencia;
import br.com.fiorilli.sip.persistence.entity.ReferenciaTipo;
import java.util.Date;

public class ReferenciaMinVo {
    private int codigo;
    private String entidade;
    private String ano;
    private String mesCodigo;
    private MesNomeEnum mes;
    private ReferenciaTipo tipoReferencia;
    private Date dataPagamento;
    private Date primeiroDia;
    private Date ultimoDia;
    private Date primeiroDiaFrequencia;
    private Date ultimoDiaFrequencia;
    private Boolean encerrado;

    public ReferenciaMinVo(int codigo, String entidade, String ano, String mesCodigo, ReferenciaTipo tipo, Date dataPagamento, Date primeiroDia, Date ultimoDia, Date primeiroDiaFrequencia, Date ultimoDiaFrequencia, Boolean encerrado) {
        this.codigo = codigo;
        this.entidade = entidade;
        this.ano = ano;
        this.mesCodigo = mesCodigo;
        this.mes = MesNomeEnum.of(mesCodigo);
        this.tipoReferencia = tipo;
        this.dataPagamento = dataPagamento;
        this.primeiroDia = primeiroDia;
        this.ultimoDia = ultimoDia;
        this.primeiroDiaFrequencia = primeiroDiaFrequencia;
        this.ultimoDiaFrequencia = ultimoDiaFrequencia;
        this.encerrado = encerrado;
    }

    public boolean exists() {
        return this.codigo > 0;
    }

    public final int getCodigo() {
        return this.codigo;
    }

    public String getEntidade() {
        return this.entidade;
    }

    public final String getAno() {
        return this.ano;
    }

    public final String getMesCodigo() {
        return this.mesCodigo;
    }

    public final MesNomeEnum getMes() {
        return this.mes;
    }

    public final ReferenciaTipo getTipoReferencia() {
        return this.tipoReferencia;
    }

    public final Date getDataPagamento() {
        return this.dataPagamento;
    }

    public final Date getPrimeiroDia() {
        return this.primeiroDia;
    }

    public final Date getUltimoDia() {
        return this.ultimoDia;
    }

    public Date getPrimeiroDiaFrequencia() {
        return this.primeiroDiaFrequencia;
    }

    public Date getUltimoDiaFrequencia() {
        return this.ultimoDiaFrequencia;
    }

    public Boolean getEncerrado() {
        return this.encerrado;
    }

    public ReferenciaMinVo withCodigo(int codigo) {
        return new ReferenciaMinVo(codigo, this.entidade, this.ano, this.mesCodigo, this.tipoReferencia, this.dataPagamento, this.primeiroDia, this.ultimoDia, this.primeiroDiaFrequencia, this.ultimoDiaFrequencia, this.encerrado);
    }

    public String getMesAno() {
        return String.format("%s/%s", this.mesCodigo, this.ano);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.codigo;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ReferenciaMinVo other = (ReferenciaMinVo)obj;
        return this.codigo == other.codigo;
    }

    public String toString() {
        return "ReferenciaMinVo [codigo=" + this.codigo + ", ano=" + this.ano + ", mes=" + this.mesCodigo + ", tipoReferencia=" + (Object)((Object)this.tipoReferencia) + ", dataPagamento=" + this.dataPagamento + "]";
    }

    public static ReferenciaMinVo create(Referencia r) {
        return new ReferenciaMinVo(r.getCodigo(), r.getEntidadeCodigo(), r.getAno(), r.getMesCodigo(), r.getTipoReferencia(), r.getDataPagamento(), r.getPrimeiroDia(), r.getUltimoDia(), r.getPrimeiroDiaFreq(), r.getUltimoDiaFreq(), r.getEncerrado());
    }

    public String getID() {
        return String.valueOf(this.codigo);
    }

    public ReferenciaMinVo() {
    }
}

