/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.vo;

import br.com.fiorilli.filter.annotations.FilterConfigParameter;
import br.com.fiorilli.filter.annotations.FilterConfigParameters;
import br.com.fiorilli.filter.annotations.FilterConfigType;
import br.com.fiorilli.filter.model.FilterCondition;
import br.com.fiorilli.filter.model.FilterInputType;
import br.com.fiorilli.sip.commons.util.SIPUtil;
import br.com.fiorilli.sip.commons.util.TimeUtils;
import br.com.fiorilli.sip.persistence.entity.Cargo;
import br.com.fiorilli.sip.persistence.entity.Divisao;
import br.com.fiorilli.sip.persistence.entity.DivisaoPK;
import br.com.fiorilli.sip.persistence.entity.Evento;
import br.com.fiorilli.sip.persistence.entity.GrupoPonto;
import br.com.fiorilli.sip.persistence.entity.GrupoPontoPK;
import br.com.fiorilli.sip.persistence.entity.Jornada;
import br.com.fiorilli.sip.persistence.entity.LocalTrabalho;
import br.com.fiorilli.sip.persistence.entity.Subdivisao;
import br.com.fiorilli.sip.persistence.entity.TrabalhadorTipoSalario;
import br.com.fiorilli.sip.persistence.entity.Vinculo;
import br.com.fiorilli.sip.persistence.enums.TipoFiltroRelatorio;
import java.math.BigDecimal;
import java.util.Date;
import java.util.Objects;
import javax.swing.text.MaskFormatter;
import org.joda.time.Duration;

@FilterConfigType(query="SELECT $R{[pm.pontoMesPK.registro], [NEW br.com.fiorilli.sip.persistence.vo.PontoMesVo(pm.pontoMesPK.entidade, pm.pontoMesPK.registro, tr.dadosEstadoSaoPaulo.registroServidor, pm.pontoMesPK.referencia, tr.matricula, tr.contrato, tr.nome, tr.documentosPessoais.cpf, tr.documentosPessoais.pis, tr.documentosPessoais.rg.numero, tr.dataAdmissao, coalesce(tr.ponto.numeroCartao, ''), tr.ponto.dataImplantacaoCartao, tr.horasMes, pm.jornadaCodigo, jo.nome, pm.cargoCodigo, ca.nome, pm.vinculoCodigo, vi.nome, pm.divisaoCodigo, di.nome, pm.subdivisaoCodigo, su.nome, si.codigo, si.nome, pm.localTrabalhoCodigo, lo.nome,pm.horasNormais, pm.horasNoturnas, pm.horasTrabalhadas, pm.horasAulas, pm.incorporarCalculoFolha,coalesce((\tselect sum(coalesce(pe.quantidadeMillis, 0)) from PontoEvento pe \twhere pe.pontoMes = pm and pe.tipo = 'A' and pe.evento.classificacao = '24' ), 0), (\tselect coalesce(sum(s.horas), 0.0)    from BancoHoraMovimento s \tleft join s.sipbhParametros p \twhere s.trabalhador = tr \tand re.ultimoDiaFreq between p.dataVigenciaInicio and p.dataVigenciaTermino    and s.pk.data <= re.ultimoDiaFreq ),(\tselect coalesce(sum(s.horas), 0.0)    from BancoHoraMovimento s \tleft join s.sipbhParametros p \twhere s.trabalhador = tr \tand re.codigo = s.pk.referencia ),un.departamentoDespesa, un.nome, (\tselect coalesce(sum(s.horas), 0.0)    from BancoHoraMovimento s \tleft join s.sipbhParametros p \twhere s.trabalhador = tr \tand re.ultimoDiaFreq between p.dataVigenciaInicio and p.dataVigenciaTermino    and s.pk.data < re.primeiroDiaFreq ) )]} FROM Referencia re INNER JOIN re.pontoMesList pm LEFT JOIN pm.trabalhador tr LEFT JOIN pm.jornada jo LEFT JOIN pm.cargo ca LEFT JOIN pm.vinculo vi LEFT JOIN pm.divisao di LEFT JOIN pm.subdivisao su LEFT JOIN pm.localTrabalho lo LEFT JOIN pm.grupoPonto gp LEFT JOIN pm.unidade un LEFT JOIN tr.subdivisaoItem si WHERE re.codigo = :referenciaCodigo AND $P{[divisoesPerfil], [tr.divisao.divisaoPK], [:divisoesPerfil]} AND $P{[registro],[tr.trabalhadorPK.registro],[:registro]} AND $P{[matricula],[tr.matricula],[:matricula]} AND $P{[contrato],[tr.contrato],[:contrato]} AND $P{[nome],[tr.nome],[:nome]} AND $P{[pis],[tr.documentosPessoais.pis],[:pis]} AND $P{[cpf],[tr.documentosPessoais.cpf],[:cpf]} AND $P{[numeroCartao],[tr.ponto.numeroCartao],[:numeroCartao]} AND $P{[dataAdmissao],[tr.dataAdmissao],[:dataAdmissao]} AND $P{[cargo],[pm.cargo],[:cargo]} AND $P{[jornada],[pm.jornada],[:jornada]} AND $P{[divisao],[pm.divisao],[:divisao]}AND $P{[subdivisao],[pm.subdivisao],[:subdivisao]} AND $P{[localTrabalho],[pm.localTrabalho],[:localTrabalho]} AND $P{[vinculo],[pm.vinculo],[:vinculo]} AND $P{[horasNormais],[pm.horasNormais],[:horasNormais]} AND $P{[horasNoturnas],[pm.horasNoturnas],[:horasNoturnas]} AND $P{[horasMes],[tr.horasMes],[:horasMes]} AND $P{[horasSemana],[tr.horasSemana],[:horasSemana]} AND $P{[tipoSalario],[tr.tipoSalario],[:tipoSalario]} AND $P{[horasAulas],[pm.horasAulas],[:horasAulas]} AND $P{[horasTrabalhadas],[pm.horasTrabalhadas],[:horasTrabalhadas]} AND $P{[jornadaNome],[concat(jo.jornadaPK.codigo, ' - ', jo.nome)],[:jornadaNome]} AND $P{[cargoNome],[concat(ca.cargoPK.codigo, ' - ', ca.nome)],[:cargoNome]} AND $P{[vinculoNome],[concat(vi.vinculoPK.codigo, ' - ', vi.nome)],[:vinculoNome]} AND $P{[grupoPonto],[pm.grupoPonto],[:grupoPonto]} AND $P{[grupoPontoNome],[concat(gp.grupoPontoPK.codigo, ' - ', gp.nome)],[:grupoPontoNome]} AND (        ($E{(SELECT 'S' FROM PontoEvento pe WHERE pe.pontoMes = pm AND $P{[evento],[pe.evento],[(:evento)]})}) \t\tOR ($E{(SELECT 'S' FROM Falta f WHERE f.entidadeCodigo = pm.pontoMesPK.entidade AND f.registro = pm.pontoMesPK.registro AND f.data BETWEEN re.primeiroDiaFreq AND re.ultimoDiaFreq AND $P{[evento],[f.evento],[(:evento)]})})     ) AND $P{[gruposPontoPerfil], [tr.grupoPonto.grupoPontoPK], [:gruposPontoPerfil]} ", displayField=10)
@FilterConfigParameters(value={@FilterConfigParameter(fieldClass=String.class, id="registro", label="Registro", inputType=FilterInputType.NUMBER, order=3), @FilterConfigParameter(fieldClass=Integer.class, id="matricula", label="Matr\u00edcula", inputType=FilterInputType.NUMBER, order=1), @FilterConfigParameter(fieldClass=String.class, id="nome", label="Nome", inputType=FilterInputType.TEXT, condition=FilterCondition.COMECE, order=2), @FilterConfigParameter(fieldClass=Jornada.class, id="jornada", label="Jornada", inputType=FilterInputType.AUTO_COMPLETE, query="SELECT j FROM Jornada j where j.jornadaPK.entidade = :entidadeCodigo \tand ((\t\t((length(cast(:param as text)) <= 3)) and (cast(j.jornadaPK.codigo as text) = cast(:param as text)))\t\tor ((length(cast(:param as text)) > 3) and \t\t   ((concat(j.jornadaPK.codigo, j.nome) LIKE concat('%', cast(:param as text), '%')) \t\t   or (concat('#', j.apelido) LIKE concat(cast(:param as text), '%')))\t\t))", order=6), @FilterConfigParameter(fieldClass=LocalTrabalho.class, id="localTrabalho", label="Local de Trabalho", inputType=FilterInputType.AUTO_COMPLETE, query="SELECT l FROM LocalTrabalho l where UPPER(concat(l.localTrabalhoPK.codigo, l.nome)) LIKE UPPER('%'||:param||'%') AND l.localTrabalhoPK.entidade = :entidadeCodigo", order=4), @FilterConfigParameter(fieldClass=Divisao.class, id="divisao", label="Divis\u00e3o", inputType=FilterInputType.AUTO_COMPLETE, query="SELECT d FROM Divisao d WHERE UPPER(concat(d.divisaoPK.codigo, d.nome)) LIKE UPPER('%'||:param||'%') AND d.divisaoPK.entidade = :entidadeCodigo", order=5), @FilterConfigParameter(fieldClass=String.class, id="pis", label="PIS", inputType=FilterInputType.TEXT, order=7), @FilterConfigParameter(fieldClass=Vinculo.class, id="vinculo", label="V\u00ednculo", inputType=FilterInputType.AUTO_COMPLETE, query="SELECT v FROM Vinculo v WHERE concat(v.vinculoPK.codigo, v.nome) LIKE concat('%', :param, '%') AND v.vinculoPK.entidade = :entidadeCodigo", order=9), @FilterConfigParameter(fieldClass=GrupoPonto.class, id="grupoPonto", label="Grupo", inputType=FilterInputType.AUTO_COMPLETE, query="SELECT g FROM GrupoPonto g where g.grupoPontoPK.entidade = :entidadeCodigo AND concat(g.grupoPontoPK.codigo, g.nome) LIKE concat('%', :param, '%') ", order=10), @FilterConfigParameter(fieldClass=Cargo.class, id="cargo", label="Cargo", inputType=FilterInputType.AUTO_COMPLETE, query="SELECT c FROM Cargo c WHERE UPPER(concat(c.cargoPK.codigo, c.nome)) LIKE UPPER('%'||:param||'%') AND c.cargoPK.entidade = :entidadeCodigo ORDER BY c.nome"), @FilterConfigParameter(fieldClass=Date.class, id="dataAdmissao", label="Dt. Admiss\u00e3o", inputType=FilterInputType.CALENDAR), @FilterConfigParameter(fieldClass=Subdivisao.class, id="subdivisao", label="Subdivis\u00e3o", inputType=FilterInputType.AUTO_COMPLETE, query="SELECT s FROM Subdivisao s WHERE UPPER(concat(s.subdivisaoPK.codigo, s.nome)) LIKE UPPER('%'||:param||'%') AND s.subdivisaoPK.entidade = :entidadeCodigo"), @FilterConfigParameter(fieldClass=Short.class, id="contrato", label="Contrato", inputType=FilterInputType.NUMBER), @FilterConfigParameter(fieldClass=String.class, id="numeroCartao", label="N\u00fam. Cart\u00e3o Ponto"), @FilterConfigParameter(fieldClass=Double.class, id="horasNormal", label="Horas Normais", inputType=FilterInputType.NUMBER), @FilterConfigParameter(fieldClass=Double.class, id="horasNoturna", label="Horas Noturnas", inputType=FilterInputType.NUMBER), @FilterConfigParameter(fieldClass=Double.class, id="horasAula", label="Horas Aulas", inputType=FilterInputType.NUMBER), @FilterConfigParameter(fieldClass=Double.class, id="horasTrabalhada", label="Horas Trabahadas", inputType=FilterInputType.NUMBER), @FilterConfigParameter(fieldClass=Double.class, id="horasSemana", label="Horas Semana", inputType=FilterInputType.NUMBER), @FilterConfigParameter(fieldClass=Double.class, id="horasMes", label="Horas M\u00eas", inputType=FilterInputType.NUMBER), @FilterConfigParameter(fieldClass=TrabalhadorTipoSalario.class, id="tipoSalario", label="Tipo Ref. Sal. Atual", enumClass=TrabalhadorTipoSalario.class, enumId="codigo", enumLabel="descricao", inputType=FilterInputType.SELECT_ONE_MENU), @FilterConfigParameter(fieldClass=String.class, id="jornadaNome", label="Jornada Nome", inputType=FilterInputType.TEXT, condition=FilterCondition.CONTENHA), @FilterConfigParameter(fieldClass=String.class, id="vinculoNome", label="V\u00ednculo Nome", inputType=FilterInputType.TEXT, condition=FilterCondition.CONTENHA), @FilterConfigParameter(fieldClass=String.class, id="cargoNome", label="Cargo Nome", inputType=FilterInputType.TEXT, condition=FilterCondition.CONTENHA), @FilterConfigParameter(fieldClass=String.class, id="grupoPontoNome", label="Grupo Nome", inputType=FilterInputType.TEXT, condition=FilterCondition.CONTENHA), @FilterConfigParameter(fieldClass=Evento.class, id="evento", label="Evento", inputType=FilterInputType.AUTO_COMPLETE, query="SELECT e FROM Evento e WHERE UPPER(concat(e.eventoPK.codigo, e.nome)) LIKE UPPER(concat('%', :param, '%')) AND e.eventoPK.entidade = :entidadeCodigo ORDER BY e.nome"), @FilterConfigParameter(fieldClass=DivisaoPK.class, id="divisoesPerfil", label="Divis\u00f5es Perfil", condition=FilterCondition.SEQUENCIA, hide=true, disable=true), @FilterConfigParameter(fieldClass=GrupoPontoPK.class, id="gruposPontoPerfil", label="Grupo Ponto Perfil", condition=FilterCondition.SEQUENCIA, hide=true, disable=true), @FilterConfigParameter(fieldClass=String.class, id="cpf", label="CPF", inputType=FilterInputType.TEXT, order=8)})
public class PontoMesVo {
    public static final String QUERY = "SELECT $R{[pm.pontoMesPK.registro], [NEW br.com.fiorilli.sip.persistence.vo.PontoMesVo(pm.pontoMesPK.entidade, pm.pontoMesPK.registro, tr.dadosEstadoSaoPaulo.registroServidor, pm.pontoMesPK.referencia, tr.matricula, tr.contrato, tr.nome, tr.documentosPessoais.cpf, tr.documentosPessoais.pis, tr.documentosPessoais.rg.numero, tr.dataAdmissao, coalesce(tr.ponto.numeroCartao, ''), tr.ponto.dataImplantacaoCartao, tr.horasMes, pm.jornadaCodigo, jo.nome, pm.cargoCodigo, ca.nome, pm.vinculoCodigo, vi.nome, pm.divisaoCodigo, di.nome, pm.subdivisaoCodigo, su.nome, si.codigo, si.nome, pm.localTrabalhoCodigo, lo.nome,pm.horasNormais, pm.horasNoturnas, pm.horasTrabalhadas, pm.horasAulas, pm.incorporarCalculoFolha,coalesce((\tselect sum(coalesce(pe.quantidadeMillis, 0)) from PontoEvento pe \twhere pe.pontoMes = pm and pe.tipo = 'A' and pe.evento.classificacao = '24' ), 0), (\tselect coalesce(sum(s.horas), 0.0)    from BancoHoraMovimento s \tleft join s.sipbhParametros p \twhere s.trabalhador = tr \tand re.ultimoDiaFreq between p.dataVigenciaInicio and p.dataVigenciaTermino    and s.pk.data <= re.ultimoDiaFreq ),(\tselect coalesce(sum(s.horas), 0.0)    from BancoHoraMovimento s \tleft join s.sipbhParametros p \twhere s.trabalhador = tr \tand re.codigo = s.pk.referencia ),un.departamentoDespesa, un.nome, (\tselect coalesce(sum(s.horas), 0.0)    from BancoHoraMovimento s \tleft join s.sipbhParametros p \twhere s.trabalhador = tr \tand re.ultimoDiaFreq between p.dataVigenciaInicio and p.dataVigenciaTermino    and s.pk.data < re.primeiroDiaFreq ) )]} FROM Referencia re INNER JOIN re.pontoMesList pm LEFT JOIN pm.trabalhador tr LEFT JOIN pm.jornada jo LEFT JOIN pm.cargo ca LEFT JOIN pm.vinculo vi LEFT JOIN pm.divisao di LEFT JOIN pm.subdivisao su LEFT JOIN pm.localTrabalho lo LEFT JOIN pm.grupoPonto gp LEFT JOIN pm.unidade un LEFT JOIN tr.subdivisaoItem si WHERE re.codigo = :referenciaCodigo AND $P{[divisoesPerfil], [tr.divisao.divisaoPK], [:divisoesPerfil]} AND $P{[registro],[tr.trabalhadorPK.registro],[:registro]} AND $P{[matricula],[tr.matricula],[:matricula]} AND $P{[contrato],[tr.contrato],[:contrato]} AND $P{[nome],[tr.nome],[:nome]} AND $P{[pis],[tr.documentosPessoais.pis],[:pis]} AND $P{[cpf],[tr.documentosPessoais.cpf],[:cpf]} AND $P{[numeroCartao],[tr.ponto.numeroCartao],[:numeroCartao]} AND $P{[dataAdmissao],[tr.dataAdmissao],[:dataAdmissao]} AND $P{[cargo],[pm.cargo],[:cargo]} AND $P{[jornada],[pm.jornada],[:jornada]} AND $P{[divisao],[pm.divisao],[:divisao]}AND $P{[subdivisao],[pm.subdivisao],[:subdivisao]} AND $P{[localTrabalho],[pm.localTrabalho],[:localTrabalho]} AND $P{[vinculo],[pm.vinculo],[:vinculo]} AND $P{[horasNormais],[pm.horasNormais],[:horasNormais]} AND $P{[horasNoturnas],[pm.horasNoturnas],[:horasNoturnas]} AND $P{[horasMes],[tr.horasMes],[:horasMes]} AND $P{[horasSemana],[tr.horasSemana],[:horasSemana]} AND $P{[tipoSalario],[tr.tipoSalario],[:tipoSalario]} AND $P{[horasAulas],[pm.horasAulas],[:horasAulas]} AND $P{[horasTrabalhadas],[pm.horasTrabalhadas],[:horasTrabalhadas]} AND $P{[jornadaNome],[concat(jo.jornadaPK.codigo, ' - ', jo.nome)],[:jornadaNome]} AND $P{[cargoNome],[concat(ca.cargoPK.codigo, ' - ', ca.nome)],[:cargoNome]} AND $P{[vinculoNome],[concat(vi.vinculoPK.codigo, ' - ', vi.nome)],[:vinculoNome]} AND $P{[grupoPonto],[pm.grupoPonto],[:grupoPonto]} AND $P{[grupoPontoNome],[concat(gp.grupoPontoPK.codigo, ' - ', gp.nome)],[:grupoPontoNome]} AND (        ($E{(SELECT 'S' FROM PontoEvento pe WHERE pe.pontoMes = pm AND $P{[evento],[pe.evento],[(:evento)]})}) \t\tOR ($E{(SELECT 'S' FROM Falta f WHERE f.entidadeCodigo = pm.pontoMesPK.entidade AND f.registro = pm.pontoMesPK.registro AND f.data BETWEEN re.primeiroDiaFreq AND re.ultimoDiaFreq AND $P{[evento],[f.evento],[(:evento)]})})     ) AND $P{[gruposPontoPerfil], [tr.grupoPonto.grupoPontoPK], [:gruposPontoPerfil]} ";
    public static final String QUERY_REGISTROS_ON_AFD_BATIDAS = "SELECT \t$R{\t\t[DISTINCT tr.trabalhadorPK.registro], \t\t[DISTINCT tr.trabalhadorPK.registro, CONCAT(tr.matricula, '-', tr.contrato, ' ', tr.nome)]\t} FROM Trabalhador tr WHERE tr.trabalhadorPK.entidade = :entidadeCodigo AND ((tr.situacao IN ('1', '5'))    OR ((tr.dataDemissao >= :dataInicialFreq) AND (COALESCE(tr.vinculo.periodoPonto, 0) = 0))    OR ((tr.dataDemissao >= :dataInicial) AND (COALESCE(tr.vinculo.periodoPonto, 0) = 1))    OR (tr.dataDemissao is null)) AND (((tr.dataAdmissao <= :dataFinalFreq) AND (COALESCE(tr.vinculo.periodoPonto, 0) = 0))    OR ((tr.dataAdmissao <= :dataFinal) AND (COALESCE(tr.vinculo.periodoPonto, 0) = 1))) AND tr.ponto.tipo = '1' and tr.jornadaCodigo is not null and tr.cargoAtualCodigo is not null AND $P{[divisoesPerfil], [tr.divisao.divisaoPK], [:divisoesPerfil]} AND $P{[registro],[tr.trabalhadorPK.registro],[:registro]} AND $P{[matricula],[tr.matricula],[:matricula]} AND $P{[contrato],[tr.contrato],[:contrato]} AND $P{[nome],[tr.nome],[:nome]} AND $P{[pis],[tr.documentosPessoais.pis],[:pis]} AND $P{[cpf],[tr.documentosPessoais.cpf],[:cpf]} AND $P{[numeroCartao],[tr.ponto.numeroCartao],[:numeroCartao]} AND $P{[dataAdmissao],[tr.dataAdmissao],[:dataAdmissao]} AND $P{[cargo],[tr.cargoAtual],[:cargo]} AND $P{[jornada],[tr.jornada],[:jornada]} AND $P{[divisao],[tr.divisao],[:divisao]} AND $P{[vinculo],[tr.vinculo],[:vinculo]} AND $P{[subdivisao],[tr.subdivisao],[:subdivisao]} AND $P{[localTrabalho],[tr.localTrabalho],[:localTrabalho]} AND $P{[tipoSalario],[tr.tipoSalario],[:tipoSalario]}  AND $P{[grupoPonto],[tr.grupoPonto],[:grupoPonto]} AND (        ($E{(SELECT 'S' FROM PontoEvento pe WHERE pe.entidadeCodigo = tr.trabalhadorPK.entidade AND pe.registro = tr.trabalhadorPK.registro AND $P{[evento],[pe.evento],[(:evento)]})}) \t    OR ($E{(SELECT 'S' FROM Falta f WHERE f.entidadeCodigo = tr.trabalhadorPK.entidade                    AND f.registro = tr.trabalhadorPK.registro                    AND (((f.data BETWEEN :dataInicialFreq AND :dataFinalFreq END) AND (COALESCE(tr.vinculo.periodoPonto, 0) = 0))                        OR ((f.data BETWEEN :dataInicial AND :dataFinal END) AND (COALESCE(tr.vinculo.periodoPonto, 0) = 1)))                   AND $P{[evento],[f.evento],[(:evento)]})})     ) AND $P{[gruposPontoPerfil], [tr.grupoPonto.grupoPontoPK], [:gruposPontoPerfil]} ";
    public static final String QUERY_REGISTROS_WITH_DATE_LIMIT = "SELECT \t$R{\t\t[DISTINCT tr.trabalhadorPK.registro], \t\t[DISTINCT new br.com.fiorilli.sip.persistence.vo.cartaoponto.autorizacaoHoraExtra.TrabalhadorVO(tr.trabalhadorPK.entidade, tr.trabalhadorPK.registro, tr.matricula, tr.contrato, tr.nome)]\t} FROM Trabalhador tr WHERE tr.trabalhadorPK.entidade = :entidadeCodigo AND ((tr.situacao IN ('1', '5'))    OR (tr.dataDemissao >= :dataFinal)    OR (tr.dataDemissao is null)) and tr.dataAdmissao <= :dataFinal AND tr.ponto.tipo = '1' and tr.jornadaCodigo is not null and tr.cargoAtualCodigo is not null AND $P{[divisoesPerfil], [tr.divisao.divisaoPK], [:divisoesPerfil]} AND $P{[registro],[tr.trabalhadorPK.registro],[:registro]} AND $P{[matricula],[tr.matricula],[:matricula]} AND $P{[contrato],[tr.contrato],[:contrato]} AND $P{[nome],[tr.nome],[:nome]} AND $P{[pis],[tr.documentosPessoais.pis],[:pis]} AND $P{[cpf],[tr.documentosPessoais.cpf],[:cpf]} AND $P{[numeroCartao],[tr.ponto.numeroCartao],[:numeroCartao]} AND $P{[dataAdmissao],[tr.dataAdmissao],[:dataAdmissao]} AND $P{[cargo],[tr.cargoAtual],[:cargo]} AND $P{[jornada],[tr.jornada],[:jornada]} AND $P{[divisao],[tr.divisao],[:divisao]} AND $P{[vinculo],[tr.vinculo],[:vinculo]} AND $P{[subdivisao],[tr.subdivisao],[:subdivisao]} AND $P{[localTrabalho],[tr.localTrabalho],[:localTrabalho]} AND $P{[tipoSalario],[tr.tipoSalario],[:tipoSalario]}  AND $P{[grupoPonto],[tr.grupoPonto],[:grupoPonto]} AND (        ($E{(SELECT 'S' FROM PontoEvento pe WHERE pe.entidadeCodigo = tr.trabalhadorPK.entidade AND pe.registro = tr.trabalhadorPK.registro AND $P{[evento],[pe.evento],[(:evento)]})}) \t    OR ($E{(SELECT 'S' FROM Falta f WHERE f.entidadeCodigo = tr.trabalhadorPK.entidade AND f.registro = tr.trabalhadorPK.registro AND f.data BETWEEN :dataInicial AND :dataFinal AND $P{[evento],[f.evento],[(:evento)]})})     ) AND $P{[gruposPontoPerfil], [tr.grupoPonto.grupoPontoPK], [:gruposPontoPerfil]} ";
    public static final String QUERY_WITH_PERIOD = "SELECT $R{[pm.pontoMesPK.registro], distinct [NEW br.com.fiorilli.sip.persistence.vo.PontoMesVo(pm.pontoMesPK.entidade, pm.pontoMesPK.registro, tr.dadosEstadoSaoPaulo.registroServidor, pm.pontoMesPK.referencia, tr.matricula, tr.contrato, tr.nome, tr.documentosPessoais.cpf, tr.documentosPessoais.pis, tr.documentosPessoais.rg.numero, tr.dataAdmissao, coalesce(tr.ponto.numeroCartao, ''), tr.ponto.dataImplantacaoCartao, tr.horasMes, pm.jornadaCodigo, jo.nome, pm.cargoCodigo, ca.nome, pm.vinculoCodigo, vi.nome, pm.divisaoCodigo, di.nome, pm.subdivisaoCodigo, su.nome, si.codigo, si.nome, pm.localTrabalhoCodigo, lo.nome,pm.horasNormais, pm.horasNoturnas, pm.horasTrabalhadas, pm.horasAulas, pm.incorporarCalculoFolha,coalesce((\tselect sum(coalesce(pe.quantidadeMillis, 0)) from PontoEvento pe \twhere pe.pontoMes = pm and pe.tipo = 'A' and pe.evento.classificacao = '24' ), 0), (\tselect coalesce(sum(s.horas), 0.0)    from BancoHoraMovimento s \tleft join s.sipbhParametros p \twhere s.trabalhador = tr \tand (((re.ultimoDiaFreq between p.dataVigenciaInicio and p.dataVigenciaTermino) and (coalesce(vi.periodoPonto, 0) = 0))        or ((re.ultimoDia between p.dataVigenciaInicio and p.dataVigenciaTermino) and (coalesce(vi.periodoPonto, 0) = 1)))    and (((s.pk.data <= re.ultimoDiaFreq) and (coalesce(vi.periodoPonto, 0) = 0)) or ((s.pk.data <= re.ultimoDia) and (coalesce(vi.periodoPonto, 0) = 1))) ),(\tselect coalesce(sum(s.horas), 0.0)    from BancoHoraMovimento s \tleft join s.sipbhParametros p \twhere s.trabalhador = tr \tand re.codigo = s.pk.referencia ), un.departamentoDespesa, un.nome, (\tselect coalesce(sum(s.horas), 0.0)    from BancoHoraMovimento s \tleft join s.sipbhParametros p \twhere s.trabalhador = tr \tand re.ultimoDiaFreq between p.dataVigenciaInicio and p.dataVigenciaTermino    and (((s.pk.data < re.primeiroDiaFreq) and (coalesce(vi.periodoPonto, 0) = 0)) or ((s.pk.data < re.primeiroDia) and (coalesce(vi.periodoPonto, 0) = 1))) ) ) ]} FROM PontoMes pm JOIN pm.referencia re JOIN pm.trabalhador tr LEFT JOIN pm.jornada jo LEFT JOIN pm.cargo ca LEFT JOIN pm.vinculo vi LEFT JOIN pm.divisao di LEFT JOIN pm.subdivisao su LEFT JOIN pm.localTrabalho lo LEFT JOIN pm.vinculo vi LEFT JOIN pm.grupoPonto gp LEFT JOIN pm.unidade un LEFT JOIN tr.subdivisaoItem si WHERE pm.pontoMesPK.entidade = :entidadeCodigo AND (   ((:tipoFiltro = " + TipoFiltroRelatorio.REFERENCIA.ordinal() + ") AND (re.codigo = :codigoReferencia)) " + "   OR ((:tipoFiltro = " + TipoFiltroRelatorio.PERIODO.ordinal() + ") AND (:dataInicio between re.primeiroDiaFreq and re.ultimoDiaFreq) AND (COALESCE(vi.periodoPonto, 0) = 0)) " + "   OR ((:tipoFiltro = " + TipoFiltroRelatorio.PERIODO.ordinal() + ") AND (:dataInicio between re.primeiroDia and re.ultimoDia) AND (COALESCE(vi.periodoPonto, 0) = 1)) " + ") " + "AND tr.dataAdmissao <= :dataFim " + "AND $P{[registro],[tr.trabalhadorPK.registro],[:registro]} " + "AND $P{[matricula],[tr.matricula],[:matricula]} " + "AND $P{[contrato],[tr.contrato],[:contrato]} " + "AND $P{[nome],[tr.nome],[:nome]} " + "AND $P{[pis],[tr.documentosPessoais.pis],[:pis]} " + "AND $P{[cpf],[tr.documentosPessoais.cpf],[:cpf]} " + "AND $P{[numeroCartao],[tr.ponto.numeroCartao],[:numeroCartao]} " + "AND $P{[dataAdmissao],[tr.dataAdmissao],[:dataAdmissao]} " + "AND $P{[cargo],[pm.cargo],[:cargo]} " + "AND $P{[jornada],[pm.jornada],[:jornada]} " + "AND $P{[divisao],[pm.divisao],[:divisao]}" + "AND $P{[subdivisao],[pm.subdivisao],[:subdivisao]} " + "AND $P{[localTrabalho],[pm.localTrabalho],[:localTrabalho]} " + "AND $P{[vinculo],[pm.vinculo],[:vinculo]} " + "AND $P{[horasNormais],[pm.horasNormais],[:horasNormais]} " + "AND $P{[horasNoturnas],[pm.horasNoturnas],[:horasNoturnas]} " + "AND $P{[horasMes],[tr.horasMes],[:horasMes]} " + "AND $P{[horasSemana],[tr.horasSemana],[:horasSemana]} " + "AND $P{[tipoSalario],[tr.tipoSalario],[:tipoSalario]} " + "AND $P{[horasAulas],[pm.horasAulas],[:horasAulas]} " + "AND $P{[horasTrabalhadas],[pm.horasTrabalhadas],[:horasTrabalhadas]} " + "AND $P{[jornadaNome],[concat(jo.jornadaPK.codigo, ' - ', jo.nome)],[:jornadaNome]} " + "AND $P{[cargoNome],[concat(ca.cargoPK.codigo, ' - ', ca.nome)],[:cargoNome]} " + "AND $P{[vinculoNome],[concat(vi.vinculoPK.codigo, ' - ', vi.nome)],[:vinculoNome]} " + "AND $P{[grupoPonto],[pm.grupoPonto],[:grupoPonto]} " + "AND $P{[grupoPontoNome],[concat(gp.grupoPontoPK.codigo, ' - ', gp.nome)],[:grupoPontoNome]} " + "AND ( " + "       ($E{(SELECT 'S' " + "               FROM PontoEvento pe " + "               WHERE pe.pontoMes = pm AND $P{[evento],[pe.evento],[(:evento)]})}) " + "\t\tOR ($E{(SELECT 'S' " + "                   FROM Falta f " + "                   WHERE f.entidadeCodigo = pm.pontoMesPK.entidade " + "                       AND f.registro = pm.pontoMesPK.registro " + "                       AND (((f.data BETWEEN re.primeiroDiaFreq AND re.ultimoDiaFreq) AND (COALESCE(vi.periodoPonto, 0) = 0))" + "                           OR ((f.data BETWEEN re.primeiroDia AND re.ultimoDia) AND (COALESCE(vi.periodoPonto, 0) = 1))) " + "                       AND $P{[evento],[f.evento],[(:evento)]})}) " + "    ) " + "AND $P{[divisoesPerfil], [tr.divisao.divisaoPK], [:divisoesPerfil]} " + "AND $P{[gruposPontoPerfil], [tr.grupoPonto.grupoPontoPK], [:gruposPontoPerfil]} " + "";
    public static final String QUERY_WITH_PERIOD_NO_FILTER = "SELECT distinct NEW br.com.fiorilli.sip.persistence.vo.PontoMesVo(pm.pontoMesPK.entidade, pm.pontoMesPK.registro, tr.dadosEstadoSaoPaulo.registroServidor, pm.pontoMesPK.referencia, tr.matricula, tr.contrato, tr.nome, tr.documentosPessoais.cpf, tr.documentosPessoais.pis, tr.documentosPessoais.rg.numero, tr.dataAdmissao, coalesce(tr.ponto.numeroCartao, ''), tr.ponto.dataImplantacaoCartao, tr.horasMes, pm.jornadaCodigo, jo.nome, pm.cargoCodigo, ca.nome, pm.vinculoCodigo, vi.nome, pm.divisaoCodigo, di.nome, pm.subdivisaoCodigo, su.nome, si.codigo, si.nome, pm.localTrabalhoCodigo, lo.nome,pm.horasNormais, pm.horasNoturnas, pm.horasTrabalhadas, pm.horasAulas, pm.incorporarCalculoFolha,coalesce((\tselect sum(coalesce(pe.quantidadeMillis, 0)) from PontoEvento pe \twhere pe.pontoMes = pm and pe.tipo = 'A' and pe.evento.classificacao = '24' ), 0), (\tselect coalesce(sum(s.horas), 0.0)    from BancoHoraMovimento s \tleft join s.sipbhParametros p \twhere s.trabalhador = tr \t  and re.ultimoDiaFreq between p.dataVigenciaInicio and p.dataVigenciaTermino      and s.pk.data <= re.ultimoDiaFreq),(\tselect coalesce(sum(s.horas), 0.0)    from BancoHoraMovimento s \tleft join s.sipbhParametros p \twhere s.trabalhador = tr \tand re.codigo = s.pk.referencia ), un.departamentoDespesa, un.nome, (\tselect coalesce(sum(s.horas), 0.0)    from BancoHoraMovimento s \tleft join s.sipbhParametros p \twhere s.trabalhador = tr \tand re.ultimoDiaFreq between p.dataVigenciaInicio and p.dataVigenciaTermino    and s.pk.data < re.primeiroDiaFreq ) ) FROM PontoMes pm JOIN pm.referencia re JOIN pm.trabalhador tr LEFT JOIN pm.jornada jo LEFT JOIN pm.cargo ca LEFT JOIN pm.vinculo vi LEFT JOIN pm.divisao di LEFT JOIN pm.subdivisao su LEFT JOIN pm.localTrabalho lo LEFT JOIN pm.vinculo vi LEFT JOIN pm.unidade un LEFT JOIN tr.subdivisaoItem si WHERE pm.pontoMesPK.entidade = :entidadeCodigo AND :dataInicio between re.primeiroDiaFreq and re.ultimoDiaFreq AND tr.dataAdmissao <= :dataFim AND tr.trabalhadorPK.registro = :registro ";
    private String entidade;
    private String registro;
    private String registroSma;
    private Integer referencia;
    private Integer matricula;
    private Short contrato;
    private String nome;
    private String cpf;
    private String pis;
    private String rg;
    private Date dataAdmissao;
    private String numeroCartaoPonto;
    private Date dataImplantacaoCartao;
    private Double horaMes;
    private Short jornadaCodigo;
    private String jornadaNome;
    private String cargoCodigo;
    private String cargoNome;
    private String vinculoCodigo;
    private String vinculoNome;
    private String divisaoCodigo;
    private String divisaoNome;
    private String subdivisaoCodigo;
    private String subdivisaoNome;
    private String subdivisaoItemCodigo;
    private String subdivisaoItemNome;
    private String localTrabalhoCodigo;
    private String localTrabalhoNome;
    private String unidadeCodigo;
    private String unidadeNome;
    private Duration horasNormais;
    private Duration horasNoturnas;
    private Duration horasTrabalhadas;
    private Duration horasAulas;
    private Boolean incorporarCalculoFolha;
    private Duration adicionalNoturno;
    private Double totalBancoDeHoras;
    private String totalBancoDeHorasConvertido;
    private Double totalBancoDeHorasMensal;
    private String totalBancoDeHorasMensalConvertido;
    private Double totalBancoDeHorasAnterior;

    public PontoMesVo() {
    }

    public PontoMesVo(String entidade, String registro, String registroSma, Integer referencia, Integer matricula, Short contrato, String nome, String cpf, String pis, String rg, Date dataAdmissao, String numeroCartaoPonto, Date dataImplantacaoCartao, BigDecimal horaMes, Short jornadaCodigo, String jornadaNome, String cargoCodigo, String cargoNome, String vinculoCodigo, String vinculoNome, String divisaoCodigo, String divisaoNome, String subdivisaoCodigo, String subdivisaoNome, String subdivisaoItemCodigo, String subdivisaoItemNome, String localTrabalhoCodigo, String localTrabalhoNome, Duration horasNormais, Duration horasNoturnas, Duration horasTrabalhadas, Duration horasAulas, Boolean incorporarCalculoFolha, Long adicionalNoturnoMillis, Double totalBancoDeHoras, Double totalBancoDeHorasMensal, String unidadeCodigo, String unidadeNome, Double totalBancoDeHorasAnterior) {
        this.entidade = entidade;
        this.registro = registro;
        this.registroSma = registroSma;
        this.referencia = referencia;
        this.matricula = matricula;
        this.contrato = contrato;
        this.nome = nome;
        this.cpf = cpf;
        this.pis = pis;
        this.rg = rg;
        this.dataAdmissao = dataAdmissao;
        this.numeroCartaoPonto = numeroCartaoPonto;
        this.dataImplantacaoCartao = dataImplantacaoCartao;
        this.totalBancoDeHoras = totalBancoDeHoras;
        this.totalBancoDeHorasMensal = totalBancoDeHorasMensal;
        this.horaMes = horaMes.doubleValue();
        this.jornadaCodigo = jornadaCodigo;
        this.jornadaNome = jornadaNome;
        this.cargoCodigo = cargoCodigo;
        this.cargoNome = cargoNome;
        this.vinculoCodigo = vinculoCodigo;
        this.vinculoNome = vinculoNome;
        this.divisaoCodigo = divisaoCodigo;
        this.divisaoNome = divisaoNome;
        this.subdivisaoCodigo = subdivisaoCodigo;
        this.subdivisaoNome = subdivisaoNome;
        this.subdivisaoItemCodigo = subdivisaoItemCodigo;
        this.subdivisaoItemNome = subdivisaoItemNome;
        this.localTrabalhoCodigo = localTrabalhoCodigo;
        this.localTrabalhoNome = localTrabalhoNome;
        this.unidadeCodigo = unidadeCodigo;
        this.unidadeNome = unidadeNome;
        this.horasNormais = horasNormais;
        this.horasNoturnas = horasNoturnas;
        this.horasTrabalhadas = horasTrabalhadas;
        this.horasAulas = horasAulas;
        this.incorporarCalculoFolha = incorporarCalculoFolha;
        this.adicionalNoturno = Duration.millis((long)adicionalNoturnoMillis);
        this.totalBancoDeHorasAnterior = totalBancoDeHorasAnterior;
    }

    public String getEntidade() {
        return this.entidade;
    }

    public String getRegistro() {
        return this.registro;
    }

    public String getRegistroSma() {
        return this.registroSma;
    }

    public Integer getReferencia() {
        return this.referencia;
    }

    public Integer getMatricula() {
        return this.matricula;
    }

    public Short getContrato() {
        return this.contrato;
    }

    public String getNumeroCartaoPonto() {
        return this.numeroCartaoPonto;
    }

    public String getNome() {
        return this.nome;
    }

    public String getCpf() {
        return this.cpf;
    }

    public String getPis() {
        return this.pis;
    }

    public Date getDataAdmissao() {
        return this.dataAdmissao;
    }

    public Date getDataImplantacaoCartao() {
        return this.dataImplantacaoCartao;
    }

    public String getJornadaNome() {
        return this.jornadaNome;
    }

    public Short getJornadaCodigo() {
        return this.jornadaCodigo;
    }

    public String getCargoCodigo() {
        return this.cargoCodigo;
    }

    public String getCargoNome() {
        return this.cargoNome;
    }

    public String getVinculoCodigo() {
        return this.vinculoCodigo;
    }

    public String getVinculoNome() {
        return this.vinculoNome;
    }

    public String getDivisaoCodigo() {
        return this.divisaoCodigo;
    }

    public String getDivisaoNome() {
        return this.divisaoNome;
    }

    public String getSubdivisaoCodigo() {
        return this.subdivisaoCodigo;
    }

    public String getSubdivisaoNome() {
        return this.subdivisaoNome;
    }

    public String getLocalTrabalhoCodigo() {
        return this.localTrabalhoCodigo;
    }

    public String getLocalTrabalhoNome() {
        return this.localTrabalhoNome;
    }

    public String getUnidadeCodigo() {
        return this.unidadeCodigo;
    }

    public String getUnidadeNome() {
        return this.unidadeNome;
    }

    public Duration getHorasNormais() {
        return this.horasNormais;
    }

    public Duration getHorasNoturnas() {
        return this.horasNoturnas;
    }

    public Duration getHorasTrabalhadas() {
        return this.horasTrabalhadas;
    }

    public Duration getHorasAulas() {
        return this.horasAulas;
    }

    public Boolean getIncorporarCalculoFolha() {
        return this.incorporarCalculoFolha;
    }

    public void setIncorporarCalculoFolha(Boolean incorporarCalculoFolha) {
        this.incorporarCalculoFolha = incorporarCalculoFolha;
    }

    public Double getHoraMes() {
        return this.horaMes;
    }

    public Duration getAdicionalNoturno() {
        return this.adicionalNoturno;
    }

    public Double getTotalBancoDeHoras() {
        return this.totalBancoDeHoras;
    }

    public String getTotalBancoDeHorasConvertido() {
        String totalConvertido = TimeUtils.toStringFromDecimal((Double)this.totalBancoDeHoras, (int)2);
        return totalConvertido;
    }

    public Double getTotalBancoDeHorasMensal() {
        return this.totalBancoDeHorasMensal;
    }

    public String getTotalBancoDeHorasMensalConvertido() {
        String totalConvertido = TimeUtils.toStringFromDecimal((Double)this.totalBancoDeHorasMensal, (int)2);
        return totalConvertido;
    }

    public String getNomeAbreviado() {
        return SIPUtil.getFirstAndLastWord((String)this.nome);
    }

    public String getFormattedCpf() {
        try {
            MaskFormatter mf = new MaskFormatter("###.###.###-##");
            mf.setValueContainsLiteralCharacters(false);
            return mf.valueToString(this.cpf);
        }
        catch (Exception e) {
            return this.cpf;
        }
    }

    public String getRg() {
        return this.rg;
    }

    public String getSubdivisaoItemCodigo() {
        return this.subdivisaoItemCodigo;
    }

    public String getSubdivisaoItemNome() {
        return this.subdivisaoItemNome;
    }

    public Double getTotalBancoDeHorasAnterior() {
        return this.totalBancoDeHorasAnterior;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PontoMesVo that = (PontoMesVo)o;
        return Objects.equals(this.entidade, that.entidade) && Objects.equals(this.registro, that.registro);
    }

    public int hashCode() {
        return Objects.hash(this.entidade, this.registro);
    }

    public String toString() {
        return "PontoMesVo [matricula=" + this.matricula + ", contrato=" + this.contrato + ", nome=" + this.nome + "]";
    }
}

