/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.vo;

import br.com.fiorilli.filter.annotations.FilterConfigParameter;
import br.com.fiorilli.filter.annotations.FilterConfigParameters;
import br.com.fiorilli.filter.annotations.FilterConfigType;
import br.com.fiorilli.filter.model.FilterCondition;
import br.com.fiorilli.filter.model.FilterInputType;
import br.com.fiorilli.sip.persistence.entity.Trabalhador;
import java.util.Date;

@FilterConfigType(query="SELECT $R{[p.id], [NEW br.com.fiorilli.sip.persistence.vo.PcmsoFilterVo( p.id, t.trabalhadorPK.registro as registro, t.matricula, t.contrato, t.nome, p.dataExame, p.situacaoExame)]} FROM Pcmso p left join p.trabalhador t WHERE $P{[registro],[t.trabalhadorPK.registro],[:registro]} AND $P{[matricula],[t.matricula],[:matricula]} AND $P{[contrato],[t.contrato],[:contrato]} AND $P{[nome],[t.nome],[:nome]} ", autoFilter=true, rootEntityAlias="p")
@FilterConfigParameters(value={@FilterConfigParameter(fieldClass=String.class, id="registro", label="Registro", inputType=FilterInputType.NUMBER, order=1), @FilterConfigParameter(fieldClass=Integer.class, id="matricula", label="Matr\u00edcula", inputType=FilterInputType.NUMBER, order=2), @FilterConfigParameter(fieldClass=Short.class, id="contrato", label="Contrato", inputType=FilterInputType.NUMBER, order=3), @FilterConfigParameter(fieldClass=Trabalhador.class, id="nome", label="Nome", inputType=FilterInputType.TEXT, condition=FilterCondition.COMECE, order=4)})
public class PcmsoFilterVo {
    public static final String QUERY = "SELECT $R{[p.id], [NEW br.com.fiorilli.sip.persistence.vo.PcmsoFilterVo( p.id, t.trabalhadorPK.registro as registro, t.matricula, t.contrato, t.nome, p.dataExame, p.situacaoExame)]} FROM Pcmso p left join p.trabalhador t WHERE $P{[registro],[t.trabalhadorPK.registro],[:registro]} AND $P{[matricula],[t.matricula],[:matricula]} AND $P{[contrato],[t.contrato],[:contrato]} AND $P{[nome],[t.nome],[:nome]} ";
    private final int id;
    private final String registro;
    private final Integer matricula;
    private final Short contrato;
    private final String nome;
    private final Date dataExame;
    private final String situacaoExame;

    public PcmsoFilterVo(int id, String registro, Integer matricula, Short contrato, String nome, Date dataExame, String situacaoExame) {
        this.id = id;
        this.registro = registro;
        this.matricula = matricula;
        this.contrato = contrato;
        this.nome = nome;
        this.dataExame = dataExame;
        this.situacaoExame = situacaoExame;
    }

    public String getMatriculaContrato() {
        return this.matricula + "-" + this.contrato;
    }

    public int getId() {
        return this.id;
    }

    public String getRegistro() {
        return this.registro;
    }

    public Integer getMatricula() {
        return this.matricula;
    }

    public Short getContrato() {
        return this.contrato;
    }

    public String getNome() {
        return this.nome;
    }

    public Date getDataExame() {
        return this.dataExame;
    }

    public String getSituacaoExame() {
        return this.situacaoExame;
    }

    public String toString() {
        return "PcmsoFilterVo [registro=" + this.registro + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.registro == null ? 0 : this.registro.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PcmsoFilterVo other = (PcmsoFilterVo)obj;
        return !(this.registro == null ? other.registro != null : !this.registro.equals(other.registro));
    }
}

