/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.vo;

import br.com.fiorilli.sip.persistence.entity.ReferenciaTipo;
import br.com.fiorilli.sip.persistence.entity.VinculoTabelaPrevidencia;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;

public class PagamentoDeRendimentoESocialVo {
    private final String cpf;
    private List<PagamentoDeRendimentoDetalhesESocialVo> detalhes;

    public PagamentoDeRendimentoESocialVo(String cpf) {
        this.cpf = cpf;
        this.detalhes = new ArrayList<PagamentoDeRendimentoDetalhesESocialVo>();
    }

    public String getCpf() {
        return this.cpf;
    }

    public List<PagamentoDeRendimentoDetalhesESocialVo> getDetalhes() {
        return Collections.unmodifiableList(this.detalhes);
    }

    public void addDetalhe(PagamentoDeRendimentoDetalhesESocialVo detalhe) {
        if (!this.detalhes.contains(detalhe)) {
            this.detalhes.add(detalhe);
        }
    }

    public void addDetalhes(List<PagamentoDeRendimentoDetalhesESocialVo> detalhes) {
        this.detalhes = detalhes;
    }

    public static class PagamentoDeRendimentoDetalhesESocialVo {
        private boolean irrf;
        private final int refenciaCodigo;
        private final Date dataPagamento;
        private final ReferenciaTipo tipoReferencia;
        private final Double liquido;
        private final boolean decimoTerceiro;
        private final boolean folhaPagamento;

        public PagamentoDeRendimentoDetalhesESocialVo(int refenciaCodigo, Date dataPagamento, ReferenciaTipo tipoReferencia, Double liquido, VinculoTabelaPrevidencia tabelaPrevidencia) {
            this.refenciaCodigo = refenciaCodigo;
            this.dataPagamento = dataPagamento;
            this.tipoReferencia = tipoReferencia;
            this.liquido = liquido;
            this.irrf = VinculoTabelaPrevidencia.getOpcoesDeInss().contains((Object)tabelaPrevidencia);
            this.decimoTerceiro = tipoReferencia == ReferenciaTipo.FECHAMENTO_13;
            this.folhaPagamento = tipoReferencia != ReferenciaTipo.DESLIGAMENTO && tipoReferencia != ReferenciaTipo.COMPLEMENTAR_DESLIGAMENTO;
        }

        public int getRefenciaCodigo() {
            return this.refenciaCodigo;
        }

        public Date getDataPagamento() {
            return this.dataPagamento;
        }

        public ReferenciaTipo getTipoReferencia() {
            return this.tipoReferencia;
        }

        public Double getLiquido() {
            return this.liquido;
        }

        public boolean isDecimoTerceiro() {
            return this.decimoTerceiro;
        }

        public boolean isFolhaPagamento() {
            return this.folhaPagamento;
        }

        public boolean isRPPS() {
            return this.irrf;
        }

        public byte getTpPgto() {
            return (byte)(this.irrf ? 5 : 1);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.refenciaCodigo;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            PagamentoDeRendimentoDetalhesESocialVo other = (PagamentoDeRendimentoDetalhesESocialVo)obj;
            return this.refenciaCodigo == other.refenciaCodigo;
        }
    }
}

