/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.vo;

import br.com.fiorilli.sip.commons.util.SIPDateUtil;
import br.com.fiorilli.sip.persistence.entity.JornadaDia;
import br.com.fiorilli.sip.persistence.entity.JornadaDiaMovimento;
import br.com.fiorilli.sip.persistence.entity.JornadaDiaPK;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.joda.time.Duration;
import org.joda.time.Interval;
import org.joda.time.LocalTime;

public class JornadaESocialVo {
    private final String codHorContrat;
    private final LocalTime entrada;
    private final LocalTime saida;
    private final Duration duracao;
    private final boolean flexivel;
    private final String inicioVigencia;
    private final String fimVigencia;
    private List<JornadaIntervalESocial> intervalos;

    public JornadaESocialVo(JornadaDia jornadaDia, Date dataVigenciaInicial, Date dataVigenciaFinal, Boolean flexivel) {
        JornadaDiaPK pk = jornadaDia.getJornadaDiasPK();
        this.codHorContrat = pk.getEntidade() + "-" + pk.getJornada() + "-" + pk.getDia().getCodigo();
        this.entrada = jornadaDia.getFirstEntradaLocalTime();
        this.saida = jornadaDia.getLastSaidaLocalTime();
        this.duracao = jornadaDia.getDurationOfJornada();
        this.flexivel = flexivel;
        this.inicioVigencia = SIPDateUtil.toString((String)"yyyy-MM", (Date)dataVigenciaInicial);
        this.fimVigencia = SIPDateUtil.toString((String)"yyyy-MM", (Date)dataVigenciaFinal);
        this.intervalos = this.getIntervalos(jornadaDia);
    }

    private List<JornadaIntervalESocial> getIntervalos(JornadaDia jornadaDia) {
        ArrayList<JornadaIntervalESocial> _intervalos = new ArrayList<JornadaIntervalESocial>();
        Interval[] intervals = JornadaDiaMovimento.intervalsOfJornadaDia(jornadaDia, new Date());
        Interval last = null;
        for (Interval current : intervals) {
            if (current == null) continue;
            if (last == null) {
                last = current;
                continue;
            }
            Interval interval = new Interval(last.getEndMillis(), current.getStartMillis());
            JornadaIntervalESocial intervalo = JornadaIntervalESocial.create(interval, (byte)1);
            _intervalos.add(intervalo);
        }
        return _intervalos;
    }

    public String getHrEntr() {
        return this.entrada.toString("HHmm");
    }

    public String getHrSaida() {
        return this.saida.toString("HHmm");
    }

    public BigInteger getDurJornada() {
        return BigInteger.valueOf(this.duracao.getMillis());
    }

    public String getPerHorFlexivel() {
        return this.flexivel ? "S" : "N";
    }

    public String getCodHorContrat() {
        return this.codHorContrat;
    }

    public List<JornadaIntervalESocial> getIntervalos() {
        return this.intervalos;
    }

    public String getIniValid() {
        return this.inicioVigencia;
    }

    public String getFimValid() {
        return this.fimVigencia;
    }

    public static class JornadaIntervalESocial {
        private final String entrada;
        private final String saida;
        private final BigInteger duracao;
        private final byte tipo;

        public JornadaIntervalESocial(String entrada, String saida, BigInteger duracao, byte tipo) {
            this.entrada = entrada;
            this.saida = saida;
            this.duracao = duracao;
            this.tipo = tipo;
        }

        public String getEntrada() {
            return this.entrada;
        }

        public String getSaida() {
            return this.saida;
        }

        public BigInteger getDuracao() {
            return this.duracao;
        }

        public byte getTipo() {
            return this.tipo;
        }

        public static JornadaIntervalESocial create(Interval interval, byte tipo) {
            String entrada = interval.getStart().toString("HHmm");
            String saida = interval.getEnd().toString("HHmm");
            BigInteger duracao = BigInteger.valueOf(interval.toDuration().getStandardMinutes());
            return new JornadaIntervalESocial(entrada, saida, duracao, tipo);
        }
    }
}

