/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.vo;

import br.com.fiorilli.sip.persistence.entity.EventoFormula;
import br.com.fiorilli.sip.persistence.entity.EventoIncidencia;
import br.com.fiorilli.sip.persistence.entity.EventoNatureza;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.SimpleDateFormat;
import java.util.Date;

public class EventoESocialVo {
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-mm");
    private final String entidade;
    private final String codigo;
    private final String nome;
    private final Date dataCriacao;
    private final Date dataExtincao;
    private final Integer classificacaoESocialId;
    private final EventoFormula formula;
    private final EventoNatureza natureza;
    private final EventoIncidencia incidencia;

    public EventoESocialVo(String entidade, String codigo, String nome, Date dataCriacao, Date dataExtincao, Integer classificacaoESocialId, EventoNatureza natureza, EventoIncidencia incidencia, EventoFormula formula) {
        this.entidade = entidade;
        this.codigo = codigo;
        this.nome = nome;
        this.dataCriacao = dataCriacao;
        this.dataExtincao = dataExtincao;
        this.classificacaoESocialId = classificacaoESocialId;
        this.natureza = natureza;
        this.incidencia = incidencia;
        this.formula = formula;
    }

    public String getEntidade() {
        return this.entidade;
    }

    public String getCodigo() {
        return this.codigo;
    }

    public String getNome() {
        return this.nome;
    }

    public Date getDataCriacao() {
        return this.dataCriacao;
    }

    public Date getDataExtincao() {
        return this.dataExtincao;
    }

    public Integer getClassificacaoESocialId() {
        return this.classificacaoESocialId;
    }

    public EventoNatureza getNatureza() {
        return this.natureza;
    }

    public EventoIncidencia getIncidencia() {
        return this.incidencia;
    }

    public String getCodigoRubrica() {
        return this.entidade + "-" + this.codigo;
    }

    public String getIniValid() {
        return this.format(this.dataCriacao);
    }

    public String getFimValid() {
        return this.format(this.dataExtincao);
    }

    private String format(Date date) {
        if (date != null) {
            return DATE_FORMAT.format(date);
        }
        return null;
    }

    public BigInteger getNatRubr() {
        return BigInteger.valueOf(this.natureza.ordinal());
    }

    public byte getTpRubr() {
        return this.classificacaoESocialId.byteValue();
    }

    public EventoFormula getFormula() {
        return this.formula;
    }

    public BigDecimal getFatorRubr() {
        if (this.formula != null && this.formula.getPercentual() != null) {
            return BigDecimal.valueOf(this.formula.getPercentual());
        }
        return null;
    }

    public String getRep13() {
        return this.incidencia.getSalario13().getIncide() != false ? "S" : "N";
    }

    public String getRepFerias() {
        return this.incidencia.getFerias().getIncide() != false ? "S" : "N";
    }
}

