/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.vo;

import br.com.fiorilli.sip.persistence.entity.Endereco;
import br.com.fiorilli.sip.persistence.entity.Entidade;
import br.com.fiorilli.sip.persistence.entity.EntidadeTipo;
import br.com.fiorilli.sip.persistence.entity.IdentificadorTipo;

public class EntidadeMinVo {
    private final String codigo;
    private final String nome;
    private final String identificador;
    private final IdentificadorTipo identificadorTipo;
    private final EntidadeTipo tipo;
    private final Endereco endereco;
    private final String telefone;
    private final String email;
    private final byte[] brasao;

    public EntidadeMinVo(String codigo, String nome, String identificador, IdentificadorTipo tipoIdentificador, EntidadeTipo tipo, Endereco endereco, String telefone, String email, byte[] brasao) {
        this.codigo = codigo;
        this.nome = nome;
        this.identificador = identificador;
        this.identificadorTipo = tipoIdentificador;
        this.tipo = tipo;
        this.endereco = endereco;
        this.telefone = telefone;
        this.email = email;
        this.brasao = brasao;
    }

    public boolean isSMA() {
        return Entidade.isSMA(this.tipo, this.endereco.getUf());
    }

    public final String getCodigo() {
        return this.codigo;
    }

    public final String getNome() {
        return this.nome;
    }

    public final String getIdentificador() {
        return this.identificador;
    }

    public final IdentificadorTipo getIdentificadorTipo() {
        return this.identificadorTipo;
    }

    public final EntidadeTipo getTipo() {
        return this.tipo;
    }

    public Endereco getEndereco() {
        return this.endereco;
    }

    public String getTelefone() {
        return this.telefone;
    }

    public String getEmail() {
        return this.email;
    }

    public boolean isMarau() {
        return this.identificador != null && this.identificador.equals("87.599.122/0001-24");
    }

    public boolean isVotuporanga() {
        return this.identificador != null && this.identificador.equals("46.599.809/0001-82");
    }

    public boolean isTupa() {
        return this.identificador != null && this.identificador.equals("44.573.087/0001-61");
    }

    public boolean isConsorcioSaudeTupa() {
        return this.identificador != null && this.identificador.equals("07.833.463/0001-83");
    }

    public boolean isBotucatu() {
        return this.identificador != null && this.identificador.equals("46.634.101/0001-15");
    }

    public boolean isCamaraPresidentePrudente() {
        return this.identificador != null && this.identificador.equals("67.662.726/0001-60");
    }

    public boolean isPrefeituraCasimiroAbreu() {
        return this.identificador != null && this.identificador.equals("29.115.458/0001-78");
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.codigo == null ? 0 : this.codigo.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EntidadeMinVo other = (EntidadeMinVo)obj;
        return !(this.codigo == null ? other.codigo != null : !this.codigo.equals(other.codigo));
    }

    public String toString() {
        return "EntidadeMinVo [codigo=" + this.codigo + ", nome=" + this.nome + "]";
    }

    public byte[] getBrasao() {
        return this.brasao;
    }
}

