/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.vo;

import br.com.fiorilli.sip.persistence.entity.TipoServico;
import br.com.fiorilli.sip.persistence.entity.VinculoTabelaPrevidencia;
import java.util.Date;
import java.util.Objects;

public class EmpregoAnteriorVO {
    private final String cpf;
    private final Date dataInicial;
    private final Date dataFinal;
    private final TipoServico tipoServico;
    private final Short abatimento;
    private final Boolean contaAposentadoria;
    private Short diasAbatidos = 0;

    public EmpregoAnteriorVO(String cpf, Date dataInicial, Date dataFinal, TipoServico tipoServico, Short abatimento, Boolean contaAposentadoria) {
        this.cpf = cpf;
        this.dataInicial = dataInicial;
        this.dataFinal = dataFinal;
        this.tipoServico = tipoServico;
        this.abatimento = abatimento != null ? abatimento : Short.valueOf((short)0);
        this.contaAposentadoria = contaAposentadoria;
    }

    public EmpregoAnteriorVO(String cpf, Date dataInicial, Date dataFinal, VinculoTabelaPrevidencia tabelaPrevidencia, Integer abatimento) {
        this.cpf = cpf;
        this.dataInicial = dataInicial;
        this.dataFinal = dataFinal;
        this.tipoServico = tabelaPrevidencia != null ? TipoServico.getBy(tabelaPrevidencia.getCodigo()) : null;
        this.abatimento = abatimento != null ? Short.valueOf(abatimento.shortValue()) : Short.valueOf((short)0);
        this.contaAposentadoria = Boolean.TRUE;
    }

    public String getCpf() {
        return this.cpf;
    }

    public Date getDataInicial() {
        return this.dataInicial;
    }

    public Date getDataFinal() {
        return this.dataFinal;
    }

    public TipoServico getTipoServico() {
        return this.tipoServico;
    }

    public Short getAbatimento() {
        return this.abatimento;
    }

    public Boolean getContaAposentadoria() {
        return this.contaAposentadoria;
    }

    public Short getDiasAbatidos() {
        return this.diasAbatidos;
    }

    public void setDiasAbatidos(Short diasAbatidos) {
        this.diasAbatidos = diasAbatidos;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EmpregoAnteriorVO that = (EmpregoAnteriorVO)o;
        return Objects.equals(this.cpf, that.cpf) && Objects.equals(this.dataInicial, that.dataInicial) && Objects.equals(this.dataFinal, that.dataFinal);
    }

    public int hashCode() {
        return Objects.hash(this.cpf, this.dataInicial, this.dataFinal);
    }
}

