/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.vo;

import br.com.fiorilli.sip.persistence.entity.CargoCriacao;
import java.text.SimpleDateFormat;
import java.util.Date;

public class CargoESocialVo {
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-mm");
    private final String entidade;
    private final String codigo;
    private final String nome;
    private final String cbo;
    private final CargoCriacao criacao;
    private final CargoCriacao extincao;

    public CargoESocialVo(String entidade, String codigo, String nome, String cbo, CargoCriacao criacao, CargoCriacao extincao) {
        this.entidade = entidade;
        this.codigo = codigo;
        this.nome = nome;
        this.cbo = cbo;
        this.criacao = criacao;
        this.extincao = extincao;
    }

    public String getEntidade() {
        return this.entidade;
    }

    public String getCodigo() {
        return this.codigo;
    }

    public String getNome() {
        return this.nome;
    }

    public String getCbo() {
        return this.cbo;
    }

    public CargoCriacao getCriacao() {
        return this.criacao;
    }

    public CargoCriacao getExtincao() {
        return this.extincao;
    }

    public String getCodCargo() {
        return this.entidade + "-" + this.codigo;
    }

    public String getIniValid() {
        return DATE_FORMAT.format(this.criacao.getData());
    }

    public String getFimValid() {
        if (this.extincao == null || this.extincao.getData() == null) {
            return null;
        }
        return DATE_FORMAT.format(this.extincao.getData());
    }

    public String getNrLei() {
        if (this.criacao == null || this.criacao.getTipoLegalCodigo() == null) {
            return null;
        }
        return this.criacao.getTipoLegalCodigo().toString();
    }

    public byte getSitCargo() {
        return 1;
    }

    public Date getDtLei() {
        return this.criacao.getData();
    }
}

