/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.util;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import javax.persistence.EntityManager;
import javax.persistence.MappedSuperclass;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.Session;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.service.jdbc.connections.spi.ConnectionProvider;

public class JPAUtil {
    public static final String PU_NAME = "sipwebPU";
    public static final int SINGLE_RESULT = 1;
    public static final int FIRST_RESULT = 0;
    public static final int MAX_RESULT_FILTER = 50;
    public static final String CAST_NULL_STRING = "cast(null as string), ";
    public static final String CAST_NULL_INTEGER = "cast(null as integer), ";
    public static final String CAST_NULL_SHORT = "cast(null as short), ";
    public static final String CAST_NULL_DATE = "cast(null as date), ";
    private static final String PORCENTO = "%";

    public static String getNamedQueryCode(Class<? extends Object> clazz, String namedQueryKey) {
        NamedQueries namedQueriesAnnotation = clazz.getAnnotation(NamedQueries.class);
        NamedQuery[] namedQueryAnnotations = namedQueriesAnnotation.value();
        String code = null;
        for (NamedQuery namedQuery : namedQueryAnnotations) {
            if (!namedQuery.name().equals(namedQueryKey)) continue;
            code = namedQuery.query();
            break;
        }
        if (code == null && clazz.getSuperclass().getAnnotation(MappedSuperclass.class) != null) {
            code = JPAUtil.getNamedQueryCode(clazz.getSuperclass(), namedQueryKey);
        }
        return code;
    }

    public static String parseLikeStartWith(String str) {
        return StringUtils.defaultString((String)str).trim().toLowerCase() + PORCENTO;
    }

    public static String parseLikeEndWith(String str) {
        return PORCENTO + StringUtils.defaultString((String)str).trim().toLowerCase();
    }

    public static String parseLikeContains(String str) {
        return PORCENTO + StringUtils.defaultString((String)str).trim().toLowerCase() + PORCENTO;
    }

    public static Connection getConnection(EntityManager em) throws SQLException {
        Session session = (Session)em.unwrap(Session.class);
        SessionFactoryImplementor sfi = (SessionFactoryImplementor)session.getSessionFactory();
        ConnectionProvider cp = sfi.getConnectionProvider();
        return cp.getConnection();
    }

    public static Connection getSCPIConnection(String url) {
        try {
            Class.forName("org.firebirdsql.jdbc.FBDriver");
            return DriverManager.getConnection(url, "fscscpi8", "scpi");
        }
        catch (ClassNotFoundException | SQLException e) {
            throw new RuntimeException("N\u00e3o foi poss\u00edvel conectar \u00e0 base do SCPI");
        }
    }
}

