/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.enums;

import org.apache.commons.lang3.StringUtils;

public enum PontoWebStatus {
    PENDENTE("P", "Pendente"),
    APROVADO("A", "Aprovado"),
    REPROVADO("R", "Reprovado");

    private final String id;
    private final String descricao;

    public static PontoWebStatus getBy(String id) {
        if (id != null) {
            for (PontoWebStatus status : PontoWebStatus.values()) {
                if (!StringUtils.equals((CharSequence)status.getId(), (CharSequence)id)) continue;
                return status;
            }
        }
        return null;
    }

    public boolean isPendente() {
        return this.equals((Object)PENDENTE);
    }

    public boolean isAprovado() {
        return this.equals((Object)APROVADO);
    }

    public boolean isReprovado() {
        return this.equals((Object)REPROVADO);
    }

    private PontoWebStatus(String id, String descricao) {
        this.id = id;
        this.descricao = descricao;
    }

    public String getId() {
        return this.id;
    }

    public String getDescricao() {
        return this.descricao;
    }
}

