/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.entity;

import java.util.Arrays;
import java.util.List;

public enum VinculoTabelaPrevidencia {
    TABELA_INSS(1, "Previd\u00eancia Nacional - INSS"),
    TABELA_RPPS(2, "Previd\u00eancia Municipal - RPPS"),
    TABELA_NENHUMA(3, "Nenhuma Tabela ser\u00e1 Aplicada"),
    TABELA_USUARIO(4, "Outra Tabela de Previd\u00eancia");

    private final Integer codigo;
    private final String descricao;

    private VinculoTabelaPrevidencia(Integer codigo, String descricao) {
        this.codigo = codigo;
        this.descricao = descricao;
    }

    public static VinculoTabelaPrevidencia get(Integer codigo) {
        for (VinculoTabelaPrevidencia pt : VinculoTabelaPrevidencia.values()) {
            if (!pt.getCodigo().equals(codigo)) continue;
            return pt;
        }
        return null;
    }

    public static List<VinculoTabelaPrevidencia> getOpcoesDeRpps() {
        return Arrays.asList(TABELA_RPPS, TABELA_USUARIO);
    }

    public static List<VinculoTabelaPrevidencia> getOpcoesDeInss() {
        return Arrays.asList(TABELA_INSS);
    }

    public boolean isTabelaUsuario() {
        return this.equals((Object)TABELA_USUARIO);
    }

    public boolean isTabelaRppsOuUsuario() {
        return VinculoTabelaPrevidencia.getOpcoesDeRpps().contains((Object)this);
    }

    public boolean isTabelaInss() {
        return this.equals((Object)TABELA_INSS);
    }

    public Integer getCodigo() {
        return this.codigo;
    }

    public String getDescricao() {
        return this.descricao;
    }
}

