/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.entity;

import br.com.fiorilli.sip.persistence.api.VinculoRegional;
import br.com.fiorilli.sip.persistence.auditoria.Audited;
import br.com.fiorilli.sip.persistence.entity.TipoRegimeTCERJ;
import br.com.fiorilli.sip.persistence.entity.Vinculo;
import br.com.fiorilli.sip.persistence.entity.VinculoPK;
import java.io.Serializable;
import javax.persistence.AttributeOverride;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.OneToOne;
import javax.persistence.Table;

@Entity
@Table(name="SIPRJ_VINCULO")
@Audited
public class VinculoRJ
implements Serializable,
VinculoRegional {
    private static final long serialVersionUID = 1L;
    @EmbeddedId
    @AttributeOverride(name="codigo", column=@Column(name="VINCULO"))
    protected VinculoPK pk;
    @Basic(optional=false)
    @Column(name="REGIME")
    private String regime;
    @OneToOne(fetch=FetchType.LAZY)
    @JoinColumns(value={@JoinColumn(name="EMPRESA", referencedColumnName="EMPRESA", nullable=false, insertable=false, updatable=false), @JoinColumn(name="VINCULO", referencedColumnName="CODIGO", nullable=false, insertable=false, updatable=false)})
    private Vinculo vinculo;

    public VinculoRJ() {
    }

    public VinculoRJ(VinculoPK pk) {
        this.pk = pk;
    }

    public VinculoRJ(VinculoPK pk, String regime) {
        this.pk = pk;
        this.regime = regime;
    }

    public TipoRegimeTCERJ getRegime() {
        return TipoRegimeTCERJ.get(this.regime);
    }

    public void setRegime(TipoRegimeTCERJ regime) {
        this.regime = regime != null ? regime.getCodigo() : null;
    }

    public int hashCode() {
        int hash = 0;
        return hash += this.pk != null ? this.pk.hashCode() : 0;
    }

    public boolean equals(Object object) {
        if (!(object instanceof VinculoRJ)) {
            return false;
        }
        VinculoRJ other = (VinculoRJ)object;
        return (this.pk != null || other.pk == null) && (this.pk == null || this.pk.equals(other.pk));
    }

    public String toString() {
        return "entity.VinculoRJ[ pk=" + this.pk + " ]";
    }

    @Override
    public VinculoPK getPk() {
        return this.pk;
    }

    @Override
    public void setPk(VinculoPK pk) {
        this.pk = pk;
    }

    public Vinculo getVinculo() {
        return this.vinculo;
    }

    public void setVinculo(Vinculo vinculo) {
        if (this.pk == null) {
            this.pk = new VinculoPK();
        }
        if (vinculo != null) {
            this.pk.setEntidade(vinculo.getVinculoPK().getEntidade());
            this.pk.setCodigo(vinculo.getVinculoPK().getCodigo());
        } else {
            this.pk.setEntidade(null);
            this.pk.setCodigo(null);
        }
        this.vinculo = vinculo;
    }
}

