/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.entity;

import br.com.fiorilli.filter.annotations.FilterConfig;
import br.com.fiorilli.filter.annotations.FilterConfigEnum;
import br.com.fiorilli.filter.annotations.FilterConfigType;
import br.com.fiorilli.filter.model.FilterInputType;
import br.com.fiorilli.filter.service.Filterable;
import br.com.fiorilli.sip.persistence.api.GenericEntity;
import br.com.fiorilli.sip.persistence.api.SearchNome;
import br.com.fiorilli.sip.persistence.api.VinculoRegional;
import br.com.fiorilli.sip.persistence.auditoria.Audited;
import br.com.fiorilli.sip.persistence.entity.Adiantamento13SalarioAutomaticoNoMensal;
import br.com.fiorilli.sip.persistence.entity.ClassificacaoManadVinculo;
import br.com.fiorilli.sip.persistence.entity.DescontarDsrInjustificadaVinculo;
import br.com.fiorilli.sip.persistence.entity.Entidade;
import br.com.fiorilli.sip.persistence.entity.Evento;
import br.com.fiorilli.sip.persistence.entity.EventoVinculo;
import br.com.fiorilli.sip.persistence.entity.OpcaoMediaDe13SalarioAdmissaoDesligamento;
import br.com.fiorilli.sip.persistence.entity.PublicoAlvoRpps;
import br.com.fiorilli.sip.persistence.entity.RetencaoDIRF;
import br.com.fiorilli.sip.persistence.entity.Sat;
import br.com.fiorilli.sip.persistence.entity.TipoDocumentoLegal;
import br.com.fiorilli.sip.persistence.entity.TipoNaturezaTCEPR;
import br.com.fiorilli.sip.persistence.entity.VinculoAliquotaVigente;
import br.com.fiorilli.sip.persistence.entity.VinculoFerias;
import br.com.fiorilli.sip.persistence.entity.VinculoIdadeIrrf;
import br.com.fiorilli.sip.persistence.entity.VinculoIdadeSalarioFamilia;
import br.com.fiorilli.sip.persistence.entity.VinculoInformar;
import br.com.fiorilli.sip.persistence.entity.VinculoLicencaPremio;
import br.com.fiorilli.sip.persistence.entity.VinculoPK;
import br.com.fiorilli.sip.persistence.entity.VinculoRais;
import br.com.fiorilli.sip.persistence.entity.VinculoRegime;
import br.com.fiorilli.sip.persistence.entity.VinculoTabelaPrevidencia;
import br.com.fiorilli.sip.persistence.enums.VinculoPeriodoPonto;
import java.io.Serializable;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Embedded;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import javax.validation.constraints.Size;
import org.hibernate.annotations.Type;

@FilterConfigType
@Entity
@Table(name="VINCULO")
@Audited
public class Vinculo
implements Serializable,
GenericEntity,
Filterable {
    public static final String FIND_FOR_FILTER = "SELECT v FROM Vinculo v WHERE concat(v.vinculoPK.codigo, v.nome) LIKE concat('%', :param, '%') AND v.vinculoPK.entidade = :entidadeCodigo";
    public static final String FIND_PARA_EDICAO = "SELECT v FROM Vinculo v LEFT JOIN FETCH v.retencaoDIRF WHERE v.vinculoPK = :pk";
    private static final long serialVersionUID = 1L;
    @EmbeddedId
    protected VinculoPK vinculoPK;
    @SearchNome
    @FilterConfig(label="Nome", order=3)
    @Size(max=150)
    @Column(name="NOME")
    private String nome;
    @FilterConfigEnum(enumClass=VinculoRais.class, enumId="codigo", itemLabel="descricao")
    @FilterConfig(label="V\u00ednculo Rais", order=2, inputType=FilterInputType.SELECT_ONE_MENU)
    @Column(name="VINCULORAIS")
    private String vinculoRais;
    @Column(name="PERFGTS")
    private Double porcentagemFgts;
    @Embedded
    private VinculoIdadeSalarioFamilia idadeSalarioFamilia;
    @Type(type="BooleanTypeSip")
    @Column(name="NIVER14SAL")
    private Boolean pagar14SalarioNoAniversario;
    @Type(type="BooleanTypeSip")
    @Column(name="APOSUMANO")
    private Boolean pagar14SalarioNoAniversarioAposUmAno;
    @Size(max=4)
    @Column(name="CODRETDIRF")
    private String retencaoDIRFCodigo;
    @JoinColumn(name="CODRETDIRF", referencedColumnName="CODIGO", insertable=false, updatable=false)
    @ManyToOne(optional=false, fetch=FetchType.LAZY)
    private RetencaoDIRF retencaoDIRF;
    @Column(name="TBLAPLICALIQ")
    @Type(type="VinculoTabelaPrevidenciaria")
    private VinculoTabelaPrevidencia tabelaPrevidenciaria;
    @Type(type="BooleanTypeSip")
    @Column(name="MUDAREFAUTOM")
    private Boolean mudarReferenciaSalarialAutomaticamente;
    @Type(type="BooleanTypeSip")
    @Column(name="CALCSALMAT")
    private Boolean calcularSalarioMaternidade;
    @Column(name="DTCALCSALMAT")
    @Temporal(value=TemporalType.DATE)
    private Date dataInicialParaCalcularSalarioMaternidade;
    @Type(type="BooleanTypeSip")
    @Column(name="MEDIAMATERNIDADE")
    private Boolean calcularMediaMaternidade;
    @Type(type="BooleanTypeSip")
    @Column(name="PGAVISOPREVAUTOM")
    private Boolean calcularAvisoPrevioIndenizadoAutomaticamente;
    @Column(name="TXEMPRESA")
    private Double taxaEntidade;
    @Column(name="TXACIDENTES")
    private Double taxaAcidente;
    @Column(name="TXTERCEIROS")
    private Double taxaTerceirosOuComplementar;
    @Column(name="ALIQUOTA_FAP")
    private Double taxaFap;
    @Embedded
    private VinculoIdadeIrrf idadeIrrf;
    @Column(name="DIAS_ACIDENTE")
    private Short diasAcidentePagosPelaEntidade;
    @Column(name="DIAS_DOENCA")
    private Short diasDoencaPagosPelaEntidade;
    @Column(name="ADTO13SALPADRAO")
    private String adiantamento13SalarioAutomaticoNoMensal;
    @Embedded
    private VinculoLicencaPremio licencaPremio;
    @Embedded
    private VinculoInformar informar;
    @Embedded
    private VinculoFerias ferias;
    @Enumerated
    @Column(name="MANAD")
    private ClassificacaoManadVinculo manad;
    @Type(type="BooleanTypeSip")
    @Column(name="SALARIO13")
    private Boolean calcular13Salario;
    @Type(type="BooleanTypeSip")
    @Column(name="SALARIO13_PREV_SEPARADO")
    private Boolean calcularPrevidenciaNoAdto13SalSeparadaNoMensal;
    @Type(type="BooleanTypeSip")
    @Column(name="SALARIO13_FGTS")
    private Boolean calcularFgtsNoAdiantamentoDo13Salario;
    @Type(type="BooleanTypeSip")
    @Column(name="SALARIO13_PREVIDENCIA")
    private Boolean calcularPrevidenciaNoAdto13Salario;
    @Column(name="MEDIA_RESCISAO_PROPORCIONAL")
    private Short opcaoMediaDe13SalarioAdmissaoDesligamento;
    @Type(type="BooleanTypeSip")
    @Column(name="RESCINDIR_PRAZO_DETERMINADO")
    private Boolean rescindirPrazoDeterminado;
    @Column(name="DESCONTAR_DSR_INJUSTIFICADA")
    private String descontarDsrInjustificada;
    @Type(type="BooleanTypeSip")
    @Column(name="PATRONAL_SEMVENCIMENTO")
    private Boolean calcularPatronalParaAfastados;
    @Column(name="PATRONAL_SEMVENCIMENTO_DIAS")
    private Short calcularPatronalParaAfastadosLimiteEmDias;
    @Type(type="BooleanTypeSip")
    @Column(name="ABATETEMPOSERVICO")
    private Boolean calcularAbatimentoEmTempoDeServico;
    @Type(type="BooleanTypeSip")
    @Column(name="PERMITIR_ADTOSAL_SIPWEB")
    private Boolean permitirAdiantamentoSalarial;
    @Type(type="BooleanTypeSip")
    @Column(name="DIARIAS_PREVIDENCIA_50PORCENTO")
    private Boolean diariasPrevidencia50porcento;
    @Type(type="BooleanTypeSip")
    @Column(name="ABATE_AFAST_DIAS_PG_ENTIDADE")
    private Boolean abateAfastamentoDiasPagosPelaEntidade;
    @Column(name="TIPO_TCEPR")
    private Integer tipoNaturezaTCEPR;
    @JoinColumn(name="MUDAREFSAL_TIPOLEGAL", referencedColumnName="CODIGO")
    @ManyToOne(fetch=FetchType.LAZY)
    private TipoDocumentoLegal mudarefsalTipolegal;
    @Column(name="FPAS")
    private String fpasCodigo;
    @Column(name="publico_alvo_rpps")
    private PublicoAlvoRpps publicoAlvoRpps;
    @Size(max=50)
    @Column(name="legis_segurado_diferenciado")
    private String legislacaoSeguradoDiferenciado;
    @Column(name="SAT")
    private String satCodigo;
    @JoinColumns(value={@JoinColumn(name="FPAS", referencedColumnName="CODFPAS", insertable=false, updatable=false), @JoinColumn(name="SAT", referencedColumnName="CODSAT", insertable=false, updatable=false)})
    @ManyToOne(fetch=FetchType.LAZY)
    private Sat sat;
    @Size(min=1, max=3)
    @Column(name="EVENTO_DESCDSRINJUSTIFICADA")
    private String eventoDescontoDSRFaltaInjustificadaCodigo;
    @JoinColumns(value={@JoinColumn(name="EMPRESA", referencedColumnName="EMPRESA", insertable=false, updatable=false), @JoinColumn(name="EVENTO_DESCDSRINJUSTIFICADA", referencedColumnName="CODIGO", insertable=false, updatable=false)})
    @ManyToOne(optional=false, fetch=FetchType.LAZY)
    private Evento eventoDescontoDSRFaltaInjustificada;
    @OneToMany(fetch=FetchType.LAZY, mappedBy="vinculo", cascade={CascadeType.ALL}, orphanRemoval=true)
    private Set<EventoVinculo> eventoVinculoList;
    @JoinColumn(name="EMPRESA", referencedColumnName="CODIGO", insertable=false, updatable=false)
    @ManyToOne(fetch=FetchType.LAZY)
    private Entidade entidade;
    @Column(name="PERIODO_PONTO")
    private Short periodoPonto;
    @Transient
    private VinculoRegional vinculoRegional;
    @Embedded
    private VinculoAliquotaVigente aliquotaVigente;

    public Vinculo() {
        this.vinculoPK = new VinculoPK();
        this.eventoVinculoList = new HashSet<EventoVinculo>();
    }

    public Vinculo(VinculoPK vinculoPK) {
        this.vinculoPK = vinculoPK;
    }

    public Vinculo(String entidade, String codigo) {
        this.vinculoPK = new VinculoPK(entidade, codigo);
    }

    public VinculoPK getVinculoPK() {
        return this.vinculoPK;
    }

    public void setVinculoPK(VinculoPK vinculoPK) {
        this.vinculoPK = vinculoPK;
    }

    public String getNome() {
        return this.nome;
    }

    public void setNome(String nome) {
        this.nome = nome;
    }

    public Double getPorcentagemFgts() {
        return this.porcentagemFgts;
    }

    public void setPorcentagemFgts(Double porcentagemFgts) {
        this.porcentagemFgts = porcentagemFgts;
    }

    public VinculoFerias getFerias() {
        return this.ferias;
    }

    public void setFerias(VinculoFerias ferias) {
        this.ferias = ferias;
    }

    public VinculoIdadeSalarioFamilia getIdadeSalarioFamilia() {
        return this.idadeSalarioFamilia;
    }

    public void setIdadeSalarioFamilia(VinculoIdadeSalarioFamilia idadeSalarioFamilia) {
        this.idadeSalarioFamilia = idadeSalarioFamilia;
    }

    public String getRetencaoDIRFCodigo() {
        return this.retencaoDIRFCodigo;
    }

    public void setRetencaoDIRFCodigo(String codigoDeRetencaoDaDirf) {
        this.retencaoDIRFCodigo = codigoDeRetencaoDaDirf;
    }

    public VinculoTabelaPrevidencia getTabelaPrevidenciaria() {
        return this.tabelaPrevidenciaria;
    }

    public void setTabelaPrevidenciaria(VinculoTabelaPrevidencia tabelaPrevidenciaria) {
        this.tabelaPrevidenciaria = tabelaPrevidenciaria;
    }

    public Date getDataInicialParaCalcularSalarioMaternidade() {
        return this.dataInicialParaCalcularSalarioMaternidade;
    }

    public void setDataInicialParaCalcularSalarioMaternidade(Date dataInicialParaCalcularSalarioMaternidade) {
        this.dataInicialParaCalcularSalarioMaternidade = dataInicialParaCalcularSalarioMaternidade;
    }

    public Double getTaxaEntidade() {
        return this.taxaEntidade;
    }

    public void setTaxaEntidade(Double taxaEntidade) {
        this.taxaEntidade = taxaEntidade;
    }

    public Double getTaxaAcidente() {
        return this.taxaAcidente;
    }

    public void setTaxaAcidente(Double taxaAcidente) {
        this.taxaAcidente = taxaAcidente;
    }

    public Double getTaxaTerceirosOuComplementar() {
        return this.taxaTerceirosOuComplementar;
    }

    public void setTaxaTerceirosOuComplementar(Double taxaTerceirosOuComplementar) {
        this.taxaTerceirosOuComplementar = taxaTerceirosOuComplementar;
    }

    public VinculoIdadeIrrf getIdadeIrrf() {
        return this.idadeIrrf;
    }

    public void setIdadeIrrf(VinculoIdadeIrrf idadeIrrf) {
        this.idadeIrrf = idadeIrrf;
    }

    public Short getDiasAcidentePagosPelaEntidade() {
        return this.diasAcidentePagosPelaEntidade;
    }

    public void setDiasAcidentePagosPelaEntidade(Short diasAcidentePagosPelaEntidade) {
        this.diasAcidentePagosPelaEntidade = diasAcidentePagosPelaEntidade;
    }

    public Short getDiasDoencaPagosPelaEntidade() {
        return this.diasDoencaPagosPelaEntidade;
    }

    public void setDiasDoencaPagosPelaEntidade(Short diasDoencaPagosPelaEntidade) {
        this.diasDoencaPagosPelaEntidade = diasDoencaPagosPelaEntidade;
    }

    public Adiantamento13SalarioAutomaticoNoMensal getAdiantamento13SalarioAutomaticoNoMensal() {
        return Adiantamento13SalarioAutomaticoNoMensal.get(this.adiantamento13SalarioAutomaticoNoMensal);
    }

    public void setAdiantamento13SalarioAutomaticoNoMensal(Adiantamento13SalarioAutomaticoNoMensal adiantamento13SalarioAutomaticoNoMensal) {
        this.adiantamento13SalarioAutomaticoNoMensal = adiantamento13SalarioAutomaticoNoMensal.getCodigo();
    }

    public VinculoLicencaPremio getLicencaPremio() {
        return this.licencaPremio;
    }

    public void setLicencaPremio(VinculoLicencaPremio licencaPremio) {
        this.licencaPremio = licencaPremio;
    }

    public ClassificacaoManadVinculo getManad() {
        return this.manad;
    }

    public void setManad(ClassificacaoManadVinculo manad) {
        this.manad = manad;
    }

    public Boolean getPagar14SalarioNoAniversario() {
        return this.pagar14SalarioNoAniversario;
    }

    public void setPagar14SalarioNoAniversario(Boolean pagar14SalarioNoAniversario) {
        this.pagar14SalarioNoAniversario = pagar14SalarioNoAniversario;
    }

    public Boolean getPagar14SalarioNoAniversarioAposUmAno() {
        return this.pagar14SalarioNoAniversarioAposUmAno;
    }

    public void setPagar14SalarioNoAniversarioAposUmAno(Boolean pagar14SalarioNoAniversarioAposUmAno) {
        this.pagar14SalarioNoAniversarioAposUmAno = pagar14SalarioNoAniversarioAposUmAno;
    }

    public Boolean getMudarReferenciaSalarialAutomaticamente() {
        return this.mudarReferenciaSalarialAutomaticamente;
    }

    public void setMudarReferenciaSalarialAutomaticamente(Boolean mudarReferenciaSalarialAutomaticamente) {
        this.mudarReferenciaSalarialAutomaticamente = mudarReferenciaSalarialAutomaticamente;
    }

    public Boolean getCalcularSalarioMaternidade() {
        return this.calcularSalarioMaternidade;
    }

    public void setCalcularSalarioMaternidade(Boolean calcularSalarioMaternidade) {
        this.calcularSalarioMaternidade = calcularSalarioMaternidade;
    }

    public Boolean getCalcularMediaMaternidade() {
        return this.calcularMediaMaternidade;
    }

    public void setCalcularMediaMaternidade(Boolean calcularMediaMaternidade) {
        this.calcularMediaMaternidade = calcularMediaMaternidade;
    }

    public Boolean getCalcularAvisoPrevioIndenizadoAutomaticamente() {
        return this.calcularAvisoPrevioIndenizadoAutomaticamente;
    }

    public void setCalcularAvisoPrevioIndenizadoAutomaticamente(Boolean calcularAvisoPrevioIndenizadoAutomaticamente) {
        this.calcularAvisoPrevioIndenizadoAutomaticamente = calcularAvisoPrevioIndenizadoAutomaticamente;
    }

    public Boolean getCalcular13Salario() {
        return this.calcular13Salario;
    }

    public void setCalcular13Salario(Boolean calcular13Salario) {
        this.calcular13Salario = calcular13Salario;
    }

    public Boolean getCalcularPrevidenciaNoAdto13SalSeparadaNoMensal() {
        return this.calcularPrevidenciaNoAdto13SalSeparadaNoMensal;
    }

    public void setCalcularPrevidenciaNoAdto13SalSeparadaNoMensal(Boolean calcularPrevidenciaNoAdto13SalSeparadaNoMensal) {
        this.calcularPrevidenciaNoAdto13SalSeparadaNoMensal = calcularPrevidenciaNoAdto13SalSeparadaNoMensal;
    }

    public Boolean getCalcularFgtsNoAdiantamentoDo13Salario() {
        return this.calcularFgtsNoAdiantamentoDo13Salario;
    }

    public void setCalcularFgtsNoAdiantamentoDo13Salario(Boolean calcularFgtsNoAdiantamentoDo13Salario) {
        this.calcularFgtsNoAdiantamentoDo13Salario = calcularFgtsNoAdiantamentoDo13Salario;
    }

    public Boolean getCalcularPrevidenciaNoAdto13Salario() {
        return this.calcularPrevidenciaNoAdto13Salario;
    }

    public void setCalcularPrevidenciaNoAdto13Salario(Boolean calcularPrevidenciaNoAdto13Salario) {
        this.calcularPrevidenciaNoAdto13Salario = calcularPrevidenciaNoAdto13Salario;
    }

    public Boolean getRescindirPrazoDeterminado() {
        return this.rescindirPrazoDeterminado;
    }

    public void setRescindirPrazoDeterminado(Boolean rescindirPrazoDeterminado) {
        this.rescindirPrazoDeterminado = rescindirPrazoDeterminado;
    }

    public Boolean getCalcularPatronalParaAfastados() {
        return this.calcularPatronalParaAfastados;
    }

    public void setCalcularPatronalParaAfastados(Boolean calcularPatronalParaAfastados) {
        this.calcularPatronalParaAfastados = calcularPatronalParaAfastados;
    }

    public Boolean getCalcularAbatimentoEmTempoDeServico() {
        return this.calcularAbatimentoEmTempoDeServico;
    }

    public void setCalcularAbatimentoEmTempoDeServico(Boolean calcularAbatimentoEmTempoDeServico) {
        this.calcularAbatimentoEmTempoDeServico = calcularAbatimentoEmTempoDeServico;
    }

    public OpcaoMediaDe13SalarioAdmissaoDesligamento getOpcaoMediaDe13SalarioAdmissaoDesligamento() {
        return OpcaoMediaDe13SalarioAdmissaoDesligamento.toEntity(this.opcaoMediaDe13SalarioAdmissaoDesligamento);
    }

    public void setOpcaoMediaDe13SalarioAdmissaoDesligamento(OpcaoMediaDe13SalarioAdmissaoDesligamento value) {
        this.opcaoMediaDe13SalarioAdmissaoDesligamento = value.getId();
    }

    public DescontarDsrInjustificadaVinculo getDescontarDsrInjustificada() {
        return DescontarDsrInjustificadaVinculo.of(this.descontarDsrInjustificada);
    }

    public void setDescontarDsrInjustificada(DescontarDsrInjustificadaVinculo descontarDsrInjustificada) {
        this.descontarDsrInjustificada = descontarDsrInjustificada.getId();
    }

    public Double getTaxaFap() {
        return this.taxaFap;
    }

    public void setTaxaFap(Double taxaFap) {
        this.taxaFap = taxaFap;
    }

    public Boolean getDiariasPrevidencia50porcento() {
        return this.diariasPrevidencia50porcento;
    }

    public void setDiariasPrevidencia50porcento(Boolean diariasPrevidencia50porcento) {
        this.diariasPrevidencia50porcento = diariasPrevidencia50porcento;
    }

    public Short getCalcularPatronalParaAfastadosLimiteEmDias() {
        return this.calcularPatronalParaAfastadosLimiteEmDias;
    }

    public void setCalcularPatronalParaAfastadosLimiteEmDias(Short calcularPatronalParaAfastadosLimiteEmDias) {
        this.calcularPatronalParaAfastadosLimiteEmDias = calcularPatronalParaAfastadosLimiteEmDias;
    }

    public VinculoRais getVinculoRais() {
        return VinculoRais.toEntity(this.vinculoRais);
    }

    public void setVinculoRais(VinculoRais vinculorais) {
        this.vinculoRais = vinculorais != null ? vinculorais.getCodigo() : null;
    }

    public TipoDocumentoLegal getMudarefsalTipolegal() {
        return this.mudarefsalTipolegal;
    }

    public void setMudarefsalTipolegal(TipoDocumentoLegal mudarefsalTipolegal) {
        this.mudarefsalTipolegal = mudarefsalTipolegal;
    }

    public Sat getSat() {
        return this.sat;
    }

    public void setSat(Sat sat) {
        if (sat != null) {
            this.satCodigo = sat.getSatPK().getSatCodigo();
            this.fpasCodigo = sat.getSatPK().getFpasCodigo();
        } else {
            this.satCodigo = null;
            this.fpasCodigo = null;
        }
        this.sat = sat;
    }

    public Evento getEventoDescontoDSRFaltaInjustificada() {
        return this.eventoDescontoDSRFaltaInjustificada;
    }

    public void setEventoDescontoDSRFaltaInjustificada(Evento eventoDescontoDSRFaltaInjustificada) {
        this.eventoDescontoDSRFaltaInjustificadaCodigo = eventoDescontoDSRFaltaInjustificada != null ? eventoDescontoDSRFaltaInjustificada.getEventoPK().getCodigo() : null;
        this.eventoDescontoDSRFaltaInjustificada = eventoDescontoDSRFaltaInjustificada;
    }

    public static VinculoRegime getRegimeVinculo(VinculoTabelaPrevidencia value) {
        if (VinculoTabelaPrevidencia.TABELA_INSS.equals((Object)value)) {
            return VinculoRegime.REGIME_GERAL;
        }
        return VinculoRegime.REGIME_PROPRIO;
    }

    public VinculoRegime getRegime() {
        return Vinculo.getRegimeVinculo(this.getTabelaPrevidenciaria());
    }

    public VinculoInformar getInformar() {
        return this.informar;
    }

    public void setInformar(VinculoInformar informar) {
        this.informar = informar;
    }

    public Boolean getPermitirAdiantamentoSalarial() {
        return this.permitirAdiantamentoSalarial;
    }

    public void setPermitirAdiantamentoSalarial(Boolean permitirAdiantamentoSalarial) {
        this.permitirAdiantamentoSalarial = permitirAdiantamentoSalarial;
    }

    public RetencaoDIRF getRetencaoDIRF() {
        return this.retencaoDIRF;
    }

    public void setRetencaoDIRF(RetencaoDIRF retencaoDIRF) {
        this.retencaoDIRFCodigo = retencaoDIRF != null ? retencaoDIRF.getCodigo() : null;
        this.retencaoDIRF = retencaoDIRF;
    }

    public Boolean getAbateAfastamentoDiasPagosPelaEntidade() {
        return this.abateAfastamentoDiasPagosPelaEntidade;
    }

    public void setAbateAfastamentoDiasPagosPelaEntidade(Boolean abateAfastamentoDiasPagosPelaEntidade) {
        this.abateAfastamentoDiasPagosPelaEntidade = abateAfastamentoDiasPagosPelaEntidade;
    }

    public String getEventoDescontoDSRFaltaInjustificadaCodigo() {
        return this.eventoDescontoDSRFaltaInjustificadaCodigo;
    }

    public void setEventoDescontoDSRFaltaInjustificadaCodigo(String eventoDescontoDSRFaltaInjustificadaCodigo) {
        this.eventoDescontoDSRFaltaInjustificadaCodigo = eventoDescontoDSRFaltaInjustificadaCodigo;
    }

    public String getFpasCodigo() {
        return this.fpasCodigo;
    }

    public void setFpasCodigo(String fpasCodigo) {
        this.fpasCodigo = fpasCodigo;
    }

    public String getSatCodigo() {
        return this.satCodigo;
    }

    public void setSatCodigo(String satCodigo) {
        this.satCodigo = satCodigo;
    }

    public Set<EventoVinculo> getEventoVinculoList() {
        return this.eventoVinculoList;
    }

    public void setEventoVinculoList(Set<EventoVinculo> eventoVinculoList) {
        this.eventoVinculoList = eventoVinculoList;
    }

    public VinculoRegional getVinculoRegional() {
        return this.vinculoRegional;
    }

    public void setVinculoRegional(VinculoRegional vinculoRegional) {
        this.vinculoRegional = vinculoRegional;
    }

    public TipoNaturezaTCEPR getTipoNaturezaTCEPR() {
        return TipoNaturezaTCEPR.get(this.tipoNaturezaTCEPR);
    }

    public void setTipoNaturezaTCEPR(TipoNaturezaTCEPR tipoNaturezaTCEPR) {
        this.tipoNaturezaTCEPR = tipoNaturezaTCEPR != null ? Integer.valueOf(tipoNaturezaTCEPR.getCodigo()) : null;
    }

    public PublicoAlvoRpps getPublicoAlvoRpps() {
        return this.publicoAlvoRpps;
    }

    public void setPublicoAlvoRpps(PublicoAlvoRpps publicoAlvoRpps) {
        this.publicoAlvoRpps = publicoAlvoRpps;
    }

    public String getLegislacaoSeguradoDiferenciado() {
        return this.legislacaoSeguradoDiferenciado;
    }

    public void setLegislacaoSeguradoDiferenciado(String legislacaoSeguradoDiferenciado) {
        this.legislacaoSeguradoDiferenciado = legislacaoSeguradoDiferenciado;
    }

    public Entidade getEntidade() {
        return this.entidade;
    }

    public void setEntidade(Entidade entidade) {
        this.entidade = entidade;
    }

    public Short getPeriodoPonto() {
        return this.periodoPonto;
    }

    public void setPeriodoPonto(Short periodoPonto) {
        this.periodoPonto = periodoPonto;
    }

    public VinculoPeriodoPonto getPeriodoPontoEnum() {
        return VinculoPeriodoPonto.getBy(this.periodoPonto);
    }

    public int hashCode() {
        int hash = 0;
        return hash += this.vinculoPK != null ? this.vinculoPK.hashCode() : 0;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Vinculo)) {
            return false;
        }
        Vinculo other = (Vinculo)object;
        return (this.vinculoPK != null || other.vinculoPK == null) && (this.vinculoPK == null || this.vinculoPK.equals(other.vinculoPK));
    }

    public String toString() {
        return "entity.Vinculo[ vinculoPK=" + this.vinculoPK + " ]";
    }

    @Override
    public String getHashId() {
        return String.valueOf(this.hashCode());
    }

    public String getItemId() {
        return this.vinculoPK.getCodigo();
    }

    public String getItemLabel() {
        return this.nome;
    }
}

