/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.entity;

import br.com.fiorilli.filter.annotations.FilterConfig;
import br.com.fiorilli.filter.model.FilterCondition;
import br.com.fiorilli.filter.model.FilterInputType;
import br.com.fiorilli.filter.service.Filterable;
import br.com.fiorilli.sip.persistence.api.GenericEntity;
import br.com.fiorilli.sip.persistence.auditoria.Audited;
import java.io.Serializable;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

@Entity
@Table(name="VEICULO_PUBLICACAO")
@Audited
public class VeiculoPublicacao
implements Serializable,
GenericEntity,
Filterable {
    private static final long serialVersionUID = 1L;
    public static final String GET_NEXT_CODIGO = "SELECT COALESCE(MAX(v.codigo), 0) + 1 FROM VeiculoPublicacao v";
    public static final String FIND_ALL = "SELECT v FROM VeiculoPublicacao v ORDER BY v.nome";
    public static final String FIND_BY_NOME = "SELECT v FROM VeiculoPublicacao v WHERE lower(v.nome) LIKE lower('%'||:param||'%') ORDER BY v.nome";
    @Id
    @Basic(optional=false)
    @NotNull
    @Column(name="CODIGO")
    @FilterConfig(label="C\u00f3digo", inputType=FilterInputType.NUMBER)
    private Integer codigo;
    @Basic(optional=false)
    @NotNull
    @Size(min=1, max=150)
    @Column(name="NOME")
    @FilterConfig(label="Nome", condition=FilterCondition.COMECE)
    private String nome;

    public VeiculoPublicacao() {
    }

    public VeiculoPublicacao(Integer codigo) {
        this.codigo = codigo;
    }

    public VeiculoPublicacao(Integer codigo, String nome) {
        this.codigo = codigo;
        this.nome = nome;
    }

    public Integer getCodigo() {
        return this.codigo;
    }

    public void setCodigo(Integer codigo) {
        this.codigo = codigo;
    }

    public String getNome() {
        return this.nome;
    }

    public void setNome(String nome) {
        this.nome = nome;
    }

    public int hashCode() {
        int hash = 0;
        return hash += this.codigo != null ? this.codigo.hashCode() : 0;
    }

    public boolean equals(Object object) {
        if (!(object instanceof VeiculoPublicacao)) {
            return false;
        }
        VeiculoPublicacao other = (VeiculoPublicacao)object;
        return (this.codigo != null || other.codigo == null) && (this.codigo == null || this.codigo.equals(other.codigo));
    }

    public String toString() {
        return "entity.VeiculoPublicacao[ codigo=" + this.codigo + " ]";
    }

    @Override
    public String getHashId() {
        return String.valueOf(this.codigo);
    }

    public String getItemId() {
        return String.valueOf(this.hashCode());
    }

    public String getItemLabel() {
        return this.nome;
    }
}

