/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.entity;

import br.com.fiorilli.filter.annotations.FilterConfig;
import br.com.fiorilli.filter.annotations.FilterConfigType;
import br.com.fiorilli.sip.persistence.auditoria.Audited;
import br.com.fiorilli.sip.persistence.entity.Endereco;
import br.com.fiorilli.sip.persistence.entity.IdentificadorTipo;
import br.com.fiorilli.sip.persistence.entity.TelefoneFixo;
import br.com.fiorilli.sip.persistence.entity.ValeTransporteLinha;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.OneToMany;
import javax.persistence.PostLoad;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

@FilterConfigType(rootQueryType=ValeTransporteEmpresa.class)
@Entity
@Table(name="VTEMPRESAS")
@Audited
public class ValeTransporteEmpresa
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String GENERATOR = "GEN_VTEMPRESAS";
    @FilterConfig(label="C\u00f3digo", order=1)
    @Id
    @Basic(optional=false)
    @NotNull
    @Column(name="CODIGO")
    private Integer codigo;
    @FilterConfig(label="Nome", order=2)
    @Size(max=60)
    @Column(name="NOME")
    private String nome;
    @FilterConfig(label="Identificador", order=3)
    @Size(max=18)
    @Column(name="IDENTIFICADOR")
    private String identificador;
    @Column(name="TIPOID")
    @Enumerated(value=EnumType.STRING)
    private IdentificadorTipo identificadorTipo;
    @Embedded
    private Endereco endereco;
    @Size(max=60)
    @Column(name="CONTATO")
    private String contato;
    @Embedded
    private TelefoneFixo telefone;
    @OneToMany(mappedBy="valeTransporteEmpresa", fetch=FetchType.LAZY)
    List<ValeTransporteLinha> linhas;

    public ValeTransporteEmpresa() {
        this.linhas = new ArrayList<ValeTransporteLinha>();
        this.postLoad();
    }

    @PostLoad
    public void postLoad() {
        if (this.endereco == null) {
            this.endereco = new Endereco();
        }
        if (this.telefone == null) {
            this.telefone = new TelefoneFixo();
        }
    }

    public ValeTransporteEmpresa(Integer codigo) {
        this.codigo = codigo;
    }

    public Integer getCodigo() {
        return this.codigo;
    }

    public void setCodigo(Integer codigo) {
        this.codigo = codigo;
    }

    public String getNome() {
        return this.nome;
    }

    public void setNome(String nome) {
        this.nome = nome;
    }

    public IdentificadorTipo getIdentificadorTipo() {
        return this.identificadorTipo;
    }

    public void setIdentificadorTipo(IdentificadorTipo tipoId) {
        this.identificadorTipo = tipoId;
    }

    public String getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(String identificador) {
        this.identificador = identificador;
    }

    public Endereco getEndereco() {
        return this.endereco;
    }

    public void setEndereco(Endereco endereco) {
        this.endereco = endereco;
    }

    public String getContato() {
        return this.contato;
    }

    public void setContato(String contato) {
        this.contato = contato;
    }

    public TelefoneFixo getTelefone() {
        return this.telefone;
    }

    public void setTelefone(TelefoneFixo telefone) {
        this.telefone = telefone;
    }

    public List<ValeTransporteLinha> getLinhas() {
        return this.linhas;
    }

    public void setLinhas(List<ValeTransporteLinha> linhas) {
        this.linhas = linhas;
    }

    public int hashCode() {
        int hash = 0;
        return hash += this.codigo != null ? this.codigo.hashCode() : 0;
    }

    public boolean equals(Object object) {
        if (!(object instanceof ValeTransporteEmpresa)) {
            return false;
        }
        ValeTransporteEmpresa other = (ValeTransporteEmpresa)object;
        return (this.codigo != null || other.codigo == null) && (this.codigo == null || this.codigo.equals(other.codigo));
    }

    public String toString() {
        return "entity.Vtempresas[ codigo=" + this.codigo + " ]";
    }
}

