/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.entity;

import br.com.fiorilli.sip.persistence.auditoria.Audited;
import br.com.fiorilli.sip.persistence.entity.Cargo;
import br.com.fiorilli.sip.persistence.entity.DocumentoCriacaoLotacao;
import br.com.fiorilli.sip.persistence.entity.DocumentoExtincaoLotacao;
import br.com.fiorilli.sip.persistence.entity.Trabalhador;
import java.io.Serializable;
import javax.persistence.Column;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

@Entity
@Table(name="VAGA")
@Audited
public class Vaga
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String FIND_BY_CARGO = "SELECT v FROM Vaga v LEFT JOIN FETCH v.cargo c LEFT JOIN FETCH v.documentoCriacao.tipolegalCriacao tc LEFT JOIN FETCH v.documentoExtincao.tipolegalExtincao te LEFT JOIN FETCH v.trabalhador t WHERE v.cargo.cargoPK = :cargoPK ORDER BY v.numero";
    @Id
    @Column(name="ID")
    private Integer id;
    @Column(name="NUMERO")
    private Integer numero;
    @Column(name="NATUREZA")
    private Integer natureza;
    @Column(name="SITUACAO")
    private Integer situacao;
    @Column(name="ITEM")
    private Short item;
    @NotNull
    @Size(min=1, max=4)
    @Column(name="CODIGO_CARGO")
    private String cargoCodigo;
    @NotNull
    @Size(min=1, max=3)
    @Column(name="EMPRESA_CARGO")
    private String entidadeCodigo;
    @JoinColumns(value={@JoinColumn(name="EMPRESA_CARGO", referencedColumnName="EMPRESA", insertable=false, updatable=false), @JoinColumn(name="CODIGO_CARGO", referencedColumnName="CODIGO", insertable=false, updatable=false)})
    @ManyToOne(fetch=FetchType.LAZY)
    private Cargo cargo;
    @Embedded
    private DocumentoCriacaoLotacao documentoCriacao;
    @Embedded
    private DocumentoExtincaoLotacao documentoExtincao;
    @Size(max=6)
    @Column(name="REGISTRO_TRABALHADOR")
    private String registro;
    @Size(max=3)
    @Column(name="EMPRESA_TRABALHADOR")
    private String entidadeTrabalhador;
    @JoinColumns(value={@JoinColumn(name="EMPRESA_TRABALHADOR", referencedColumnName="EMPRESA", insertable=false, updatable=false), @JoinColumn(name="REGISTRO_TRABALHADOR", referencedColumnName="REGISTRO", insertable=false, updatable=false)})
    @ManyToOne(fetch=FetchType.LAZY)
    private Trabalhador trabalhador;

    public Vaga() {
    }

    public Vaga(Integer id) {
        this.id = id;
    }

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public Integer getNumero() {
        return this.numero;
    }

    public void setNumero(Integer numero) {
        this.numero = numero;
    }

    public Integer getNatureza() {
        return this.natureza;
    }

    public void setNatureza(Integer natureza) {
        this.natureza = natureza;
    }

    public Integer getSituacao() {
        return this.situacao;
    }

    public void setSituacao(Integer situacao) {
        this.situacao = situacao;
    }

    public Short getItem() {
        return this.item;
    }

    public void setItem(Short item) {
        this.item = item;
    }

    public String getCargoCodigo() {
        return this.cargoCodigo;
    }

    public void setCargoCodigo(String cargoCodigo) {
        this.cargoCodigo = cargoCodigo;
    }

    public Cargo getCargo() {
        return this.cargo;
    }

    public void setCargo(Cargo cargo) {
        if (cargo != null) {
            this.setCargoCodigo(cargo.getCargoPK().getCodigo());
            this.setEntidadeCodigo(cargo.getCargoPK().getEntidade());
        }
        this.cargo = cargo;
    }

    public String getRegistro() {
        return this.registro;
    }

    public void setRegistro(String registro) {
        this.registro = registro;
    }

    public Trabalhador getTrabalhador() {
        return this.trabalhador;
    }

    public void setTrabalhador(Trabalhador trabalhador) {
        if (trabalhador != null) {
            this.setRegistro(trabalhador.getTrabalhadorPK().getRegistro());
            this.setEntidadeTrabalhador(trabalhador.getTrabalhadorPK().getEntidade());
        }
        this.trabalhador = trabalhador;
    }

    public String getEntidadeCodigo() {
        return this.entidadeCodigo;
    }

    public void setEntidadeCodigo(String entidadeCodigo) {
        this.entidadeCodigo = entidadeCodigo;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Vaga other = (Vaga)obj;
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }

    public String toString() {
        return "Vaga [id=" + this.id + "]";
    }

    public DocumentoCriacaoLotacao getDocumentoCriacao() {
        if (this.documentoCriacao == null) {
            this.documentoCriacao = new DocumentoCriacaoLotacao();
        }
        return this.documentoCriacao;
    }

    public void setDocumentoCriacao(DocumentoCriacaoLotacao documentoCriacao) {
        this.documentoCriacao = documentoCriacao;
    }

    public DocumentoExtincaoLotacao getDocumentoExtincao() {
        if (this.documentoExtincao == null) {
            this.documentoExtincao = new DocumentoExtincaoLotacao();
        }
        return this.documentoExtincao;
    }

    public void setDocumentoExtincao(DocumentoExtincaoLotacao documentoExtincao) {
        this.documentoExtincao = documentoExtincao;
    }

    public String getEntidadeTrabalhador() {
        return this.entidadeTrabalhador;
    }

    public void setEntidadeTrabalhador(String entidadeTrabalhador) {
        this.entidadeTrabalhador = entidadeTrabalhador;
    }
}

