/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.entity;

import br.com.fiorilli.filter.annotations.FilterConfig;
import br.com.fiorilli.filter.annotations.FilterConfigJoin;
import br.com.fiorilli.filter.annotations.FilterConfigSelect;
import br.com.fiorilli.filter.annotations.FilterConfigType;
import br.com.fiorilli.filter.model.FilterInputType;
import br.com.fiorilli.filter.model.FilterJoinType;
import br.com.fiorilli.filter.service.Filterable;
import br.com.fiorilli.sip.persistence.api.SearchCodigo;
import br.com.fiorilli.sip.persistence.api.SearchNome;
import br.com.fiorilli.sip.persistence.auditoria.Audited;
import br.com.fiorilli.sip.persistence.entity.Entidade;
import br.com.fiorilli.sip.persistence.entity.FonteRecursoUnidade;
import br.com.fiorilli.sip.persistence.entity.Trabalhador;
import br.gov.sp.tce.persistence.entity.FuncaoGoverno;
import java.io.Serializable;
import java.util.Date;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.hibernate.annotations.Type;

@FilterConfigType(rootQueryType=Unidade.class)
@Entity
@Table(name="UNIDADE")
@Audited
public class Unidade
implements Serializable,
Filterable {
    private static final long serialVersionUID = 1L;
    public static final String GENERETOR = "GEN_UNIDADE";
    public static final String QUERY_FIND_NO_ANO = "SELECT u FROM Unidade u where u.responsavelEntidade = :entidadeCodigo AND u.ano = :ano";
    public static final String FIND_BY_ENITDADE_NOME = "SELECT u FROM Unidade u WHERE (u.responsavelEntidade = :entidadeId OR :entidadeId = '000') AND u.nome LIKE :nome AND YEAR(CURRENT_DATE) = u.ano";
    public static final String FIND_BY_ENITDADE_DEPDESP = "SELECT u FROM Unidade u WHERE (u.responsavelEntidade = :entidadeId OR :entidadeId = '000') AND u.departamentoDespesa LIKE :departamentoDespesa AND YEAR(CURRENT_DATE) = u.ano";
    public static final String FIND_FOR_FILTER = "SELECT u FROM Unidade u WHERE UPPER(u.nome) LIKE UPPER('%'||:param||'%') AND u.responsavelEntidade = :entidadeCodigo AND YEAR(CURRENT_DATE) = u.ano";
    @SearchCodigo
    @Id
    @NotNull
    @Column(name="CODIGO")
    private Integer codigo;
    @Basic(optional=false)
    @NotNull
    @Size(min=1, max=6)
    @Column(name="DEPDESPESA")
    private String departamentoDespesa;
    @Column(name="UNIDADE", length=2)
    private String unidade;
    @Basic(optional=false)
    @NotNull
    @Size(min=1, max=4)
    @Column(name="ANO")
    @FilterConfig(label="Ano", inputType=FilterInputType.NUMBER, required=true, requiredMessage="O Campo 'Ano' \u00e9 obrigat\u00f3rio", order=1)
    private String ano;
    @SearchNome
    @FilterConfig(label="Nome", order=2)
    @Size(max=60)
    @Column(name="NOMEUNIDADE")
    private String nome;
    @FilterConfig(label="Ficha de Despesa", order=3)
    @Column(name="FICHA")
    private Integer ficha;
    @Type(type="BooleanTypeSip")
    @Column(name="MUDAREFSAL")
    private Boolean mudaReferenciaSalarial;
    @Size(min=1, max=6)
    @Column(name="REGISTRO")
    private String responsavelRegistro;
    @Column(name="EMPRESA")
    private String responsavelEntidade;
    @JoinColumn(name="EMPRESA", referencedColumnName="CODIGO", insertable=false, updatable=false)
    @ManyToOne(optional=false, fetch=FetchType.LAZY)
    private Entidade entidade;
    @FilterConfigJoin(type=FilterJoinType.LEFT, fetch=true)
    @FilterConfig(label="Respons\u00e1vel", order=4)
    @FilterConfigSelect(query="SELECT t FROM Trabalhador t WHERE concat(t.matricula, t.trabalhadorPK.registro, lower(t.nome)) LIKE lower('%'||:param||'%') AND t.situacao = '1' AND t.trabalhadorPK.entidade = :entidadeCodigo")
    @JoinColumns(value={@JoinColumn(name="EMPRESA", referencedColumnName="EMPRESA", insertable=false, updatable=false), @JoinColumn(name="REGISTRO", referencedColumnName="REGISTRO", insertable=false, updatable=false)})
    @ManyToOne(optional=false, fetch=FetchType.LAZY)
    private Trabalhador responsavel;
    @Column(name="DTCRIACAO")
    @Temporal(value=TemporalType.DATE)
    private Date dataCriacao;
    @Column(name="TCERO")
    private Integer tcero;
    @Enumerated
    @Column(name="FONTE_RECURSO")
    private FonteRecursoUnidade fonteRecurso;
    @Column(name="DTEXTINCAO")
    @Temporal(value=TemporalType.DATE)
    private Date dataExtincao;
    @Column(name="OBN_FINALIDADE", length=3)
    private String obnFinalidade;
    @Column(name="EMPENHO", length=15)
    private String empenho;
    @Enumerated
    @Column(name="FUNCAO_GOVERNO_SP")
    private FuncaoGoverno funcaoGovernoTceSp;

    public Unidade() {
    }

    public Unidade(Integer codigo) {
        this.codigo = codigo;
    }

    public Unidade(Integer codigo, String depdespesa, String ano) {
        this.codigo = codigo;
        this.departamentoDespesa = depdespesa;
        this.ano = ano;
    }

    public Unidade withNextAno() {
        String nextAno = String.valueOf(Integer.parseInt(this.ano) + 1);
        Unidade unidade = new Unidade(this.codigo, this.departamentoDespesa, nextAno);
        unidade.unidade = this.unidade;
        unidade.nome = this.nome;
        unidade.ficha = this.ficha;
        unidade.mudaReferenciaSalarial = this.mudaReferenciaSalarial;
        unidade.responsavelEntidade = this.responsavelEntidade;
        unidade.responsavelRegistro = this.responsavelRegistro;
        unidade.dataCriacao = this.dataCriacao;
        unidade.tcero = this.tcero;
        unidade.fonteRecurso = this.fonteRecurso;
        unidade.dataExtincao = this.dataExtincao;
        unidade.obnFinalidade = this.obnFinalidade;
        unidade.empenho = this.empenho;
        return unidade;
    }

    public Integer getCodigo() {
        return this.codigo;
    }

    public void setCodigo(Integer codigo) {
        this.codigo = codigo;
    }

    public String getDepartamentoDespesa() {
        return this.departamentoDespesa;
    }

    public void setDepartamentoDespesa(String departamentoDespesa) {
        this.departamentoDespesa = departamentoDespesa;
    }

    public String getAno() {
        return this.ano;
    }

    public void setAno(String ano) {
        this.ano = ano;
    }

    public String getNome() {
        return this.nome;
    }

    public void setNome(String nome) {
        this.nome = nome;
    }

    public Date getDataCriacao() {
        return this.dataCriacao;
    }

    public void setDataCriacao(Date dtcriacao) {
        this.dataCriacao = dtcriacao;
    }

    public Integer getTcero() {
        return this.tcero;
    }

    public void setTcero(Integer tcero) {
        this.tcero = tcero;
    }

    public FonteRecursoUnidade getFonteRecurso() {
        return this.fonteRecurso;
    }

    public void setFonteRecurso(FonteRecursoUnidade fonteRecurso) {
        this.fonteRecurso = fonteRecurso;
    }

    public Date getDataExtincao() {
        return this.dataExtincao;
    }

    public void setDataExtincao(Date dtextincao) {
        this.dataExtincao = dtextincao;
    }

    public String getResponsavelEntidade() {
        return this.responsavelEntidade;
    }

    public void setResponsavelEntidade(String entidade) {
        this.responsavelEntidade = entidade;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.codigo == null ? 0 : this.codigo.hashCode());
        return result;
    }

    public String toString() {
        return "entity.Unidade[ codigo=" + this.codigo + " ]";
    }

    public String getUnidade() {
        return this.unidade;
    }

    public void setUnidade(String unidade) {
        this.unidade = unidade;
    }

    public Integer getFicha() {
        return this.ficha;
    }

    public void setFicha(Integer ficha) {
        this.ficha = ficha;
    }

    public Boolean getMudaReferenciaSalarial() {
        return this.mudaReferenciaSalarial;
    }

    public void setMudaReferenciaSalarial(Boolean mudaReferenciaSalarial) {
        this.mudaReferenciaSalarial = mudaReferenciaSalarial;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Unidade other = (Unidade)obj;
        return !(this.codigo == null ? other.codigo != null : !this.codigo.equals(other.codigo));
    }

    public String getResponsavelRegistro() {
        return this.responsavelRegistro;
    }

    public void setResponsavelRegistro(String responsavelRegistro) {
        this.responsavelRegistro = responsavelRegistro;
    }

    public Trabalhador getResponsavel() {
        return this.responsavel;
    }

    public void setResponsavel(Trabalhador responsavel) {
        if (responsavel != null) {
            this.responsavelRegistro = responsavel.getTrabalhadorPK().getRegistro();
            this.responsavelEntidade = responsavel.getTrabalhadorPK().getEntidade();
        } else {
            this.responsavelRegistro = null;
            this.responsavelEntidade = null;
        }
        this.responsavel = responsavel;
    }

    public String getItemId() {
        return this.departamentoDespesa;
    }

    public String getItemLabel() {
        return this.nome;
    }

    public FuncaoGoverno getFuncaoGovernoTceSp() {
        return this.funcaoGovernoTceSp;
    }

    public void setFuncaoGovernoTceSp(FuncaoGoverno funcaoGovernoTceSp) {
        this.funcaoGovernoTceSp = funcaoGovernoTceSp;
    }
}

