/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.entity;

import java.util.Arrays;
import java.util.List;

public enum TrabalhadorTipoCargo {
    NENHUM("0", "Nenhum"),
    CARGO_EFETIVO("1", "Cargo/Efetivo"),
    COMISSAO_CONFIANCA("2", "Comiss\u00e3o/Confian\u00e7a"),
    EMPREGO_EFETIVO("3", "Emprego/Efetivo"),
    CONTRATO_TEMPORARIO("4", "Contrato/Tempor\u00e1rio");

    private final String codigo;
    private final String descricao;

    private TrabalhadorTipoCargo(String codigo, String descricao) {
        this.codigo = codigo;
        this.descricao = descricao;
    }

    public String getCodigo() {
        return this.codigo;
    }

    public String getDescricao() {
        return this.descricao;
    }

    public static TrabalhadorTipoCargo of(String codigo) {
        for (TrabalhadorTipoCargo t : TrabalhadorTipoCargo.values()) {
            if (!t.codigo.equals(codigo)) continue;
            return t;
        }
        return NENHUM;
    }

    public boolean isNenhum() {
        return this == NENHUM;
    }

    public boolean isCargoEfetivo() {
        return this == CARGO_EFETIVO;
    }

    public boolean isComissaoConfianca() {
        return this == COMISSAO_CONFIANCA;
    }

    public boolean isEmpregoEfetivo() {
        return this == EMPREGO_EFETIVO;
    }

    public boolean isContratoTemporario() {
        return this == CONTRATO_TEMPORARIO;
    }

    public static List<TrabalhadorTipoCargo> getTiposDeEfetivos() {
        return Arrays.asList(CARGO_EFETIVO, EMPREGO_EFETIVO);
    }

    public static List<String> getCodigoTiposDeEfetivos() {
        return Arrays.asList(TrabalhadorTipoCargo.CARGO_EFETIVO.codigo, TrabalhadorTipoCargo.EMPREGO_EFETIVO.codigo);
    }

    public static boolean isComissionado(String codigo) {
        return COMISSAO_CONFIANCA.getCodigo().equals(codigo);
    }
}

